AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-rapid-config"], function () {
    module("Ajax tests", {
        setup: function setup() {
            GH.Test.setUpFakeServer(this);
        },
        teardown: function teardown() {
            GH.Test.restoreServer(this);
        }
    });

    test("submitSprintData: Successful AJAX call updates the sprint data", sinon.test(function () {

        GH.Test.respondToPutWith200(this, "/sprint/", {});

        var sprintFilters = new GH.Components.SprintFilters();
        this.stub(sprintFilters, "updateSprintData");

        sprintFilters.submitSprintData({ id: 1 });

        ok(GH.Test.isRequestDataStringified(this.server.requests[0]));

        this.server.respond();

        ok(sprintFilters.updateSprintData.called, "Called success method");
    }));

    test("submitSprintData: Failed AJAX call does nothing (no error handling)", sinon.test(function () {

        GH.Test.respondToPutWith500(this, "/sprint/", {});

        var sprintFilters = new GH.Components.SprintFilters();
        this.stub(sprintFilters, "updateSprintData");

        sprintFilters.submitSprintData({ id: 1 });

        ok(GH.Test.isRequestDataStringified(this.server.requests[0]));

        this.server.respond();

        ok(!sprintFilters.updateSprintData.called, "Called success method");
    }));
});