/**
 * Sprint Select
 * Dropdown with typeahead which stores the sprint's name and id.
 *
 * @fires 'change' when the user selects an item. The value (id) of the item is passed as the first argument.
 * if null, no item is selected, this suggests a validation error.
 * @module jira-agile/rapid/ui/component/sprint-select
 * @requires module:jquery
 * @requires module:jira/ajs/select/single-select
 * @requires module:jira-agile/rapid/events
 */
define('jira-agile/rapid/ui/component/sprint-select', ['require'], function(require) {

    // REQUIRES
    var $ = require('jquery');
    var SingleSelect = require('jira/ajs/select/single-select');
    var Events = require('jira-agile/rapid/events');

    /**
     * Sprint selector dropdown implementation
     */
    var SprintSelect = function () {
        Events(this);
        this.singleSelect = undefined;
    };

    SprintSelect.prototype.initDropdown = function () {
        var singleSelect = this;
        var onSelect = function() {
            singleSelect.trigger('change', this.value);
        };

        var $select = $("#ghx-sprint-select");
        this.singleSelect = new SingleSelect({
            element : $select,
            itemAttrDisplayed: "label"
        });
        $select.on("change", onSelect);
        $select.on("unselect", onSelect);

        $('#ghx-sprint-select-form').submit(function () {
            return false;
        });
    };

    return SprintSelect;
});
