/**
 * Image gallery support.
 *
 * Code copied from jira50/jira-components/jira-webapp/src/main/webapp/includes/jira/viewissue/ViewIssue.js
 */
GH.DetailFancyBox = {};

GH.DetailFancyBox.initFancyBox = function() {
    // the class mentioned here is declared in view_attachments.jsp
    GH.DetailFancyBox.initFancyBoxForClass("a.gallery");
};

GH.DetailFancyBox.initFancyBoxForClass = function(aClassName) {
    var closeFancyBox = function()
    {
        jQuery(aClassName).fancybox.close();
    };

    var isFireFoxLinux = function()
    {
        return jQuery.os.linux && jQuery.browser.mozilla;
    };

    var useOverlay = true;
    // FF on Linux looks like a car accident when the overlay is applied.  Its all over the place
    // like a mad womans breakfast.  So lets opt out for that combination.  FF in Windows/M<ac is not affected
    if (isFireFoxLinux())
    {
        useOverlay = false;
    }

    var fancyBoxOptions = {
        'imageScale' : true,
        'centerOnScroll' : false,
        'overlayShow': useOverlay,
        //looks like this isn't used a all??
        callbackOnStart : function ()
        {
            jQuery("#header").css("zIndex", "-1");
            if (useOverlay) {
                jQuery("body").addClass("fancybox-show");
            }
        },
        //looks like this isn't used a all??
        'callbackOnShow' : function()
        {
            jQuery(document).click(function()
            {
                closeFancyBox();
            });
        },
        'onComplete' : function()
        {
            // fix up title lozenge placement for narrow images (JRADEV-1797)
            var title = AJS.$('#fancybox-title');

            var mainWidth = AJS.$('#fancybox-title-main').outerWidth();
            var leftWidth = AJS.$("#fancybox-title-left").outerWidth();
            var rightWidth = AJS.$("#fancybox-title-right").outerWidth();

            title.width(mainWidth + leftWidth + rightWidth + 5);

            var imageDivWidth = AJS.$('#fancybox-inner').width();
            title.css("marginLeft", -(title.width() / 2) + (imageDivWidth / 2));
            title.css('bottom', title.outerHeight(true) * -1);
        },
        //looks like this isn't used a all??
        'callbackOnClose' : function()
        {
            jQuery("#header").css("zIndex", "");
            if (useOverlay) {
                jQuery("body").removeClass("fancybox-show");
            }
            jQuery(document).unbind('click', closeFancyBox);
            if (jQuery.browser.safari) {
                var top = AJS.$(window).scrollTop();
                AJS.$(window).scrollTop(10 + 5 * (top == 10)).scrollTop(top);
            }
        }
    };
    if(AJS.$.browser.msie) {
        fancyBoxOptions.transitionIn = 'none';
        fancyBoxOptions.transitionOut = 'none';
    }
    jQuery(aClassName).fancybox(fancyBoxOptions);
};
