define('jira-agile/rapid/ui/detail/inlineedit/details-view-reload-reason', ['require'], function (require) {
    'use strict';

    var _ = require('underscore');
    /* global GH */
    var DetailsModel = GH.DetailsObjectFactory.getDetailsModel();

    var EditableDetailsViewReloadReason = {
        HEADER_FIELD_CHANGED: "HEADER_FIELD_CHANGED",
        DETAILS_FIELD_CHANGED: "DETAILS_FIELD_CHANGED",
        DESCRIPTION_CHANGED: "DESCRIPTION_CHANGED",
        LINKED_ISSUES_CHANGED: "LINKED_ISSUES_CHANGED",
        LINKED_ISSUE_CREATED_AND_COMMENTED: "LINKED_ISSUE_CREATED_AND_COMMENTED",
        ATTACHMENTS_CHANGED: "ATTACHMENTS_CHANGED",
        COMMENTS_CHANGED: "COMMENTS_CHANGED",
        SUBTASKS_CHANGED: "SUBTASKS_CHANGED",
        VERSION_PANEL_CHANGED: "VERSION_PANEL_CHANGED",
        EPIC_PANEL_CHANGED: "EPIC_PANEL_CHANGED",
        ISSUE_ASSIGNED_AND_COMMENTED: "ISSUE_ASSIGNED_AND_COMMENTED"
    };

    var REASON_FOR_CHANGED_FIELD = {
        'description': EditableDetailsViewReloadReason.DESCRIPTION_CHANGED,
        'summary': EditableDetailsViewReloadReason.HEADER_FIELD_CHANGED,
        'timeestimate': EditableDetailsViewReloadReason.HEADER_FIELD_CHANGED,
        'timeoriginalestimate': EditableDetailsViewReloadReason.HEADER_FIELD_CHANGED
    };

    return _.extend(EditableDetailsViewReloadReason, {
        REASON_FOR_DIALOG: {
            "delete-attachment-dialog": EditableDetailsViewReloadReason.ATTACHMENTS_CHANGED,
            "delete-issue-link-dialog": EditableDetailsViewReloadReason.LINKED_ISSUES_CHANGED,
            "edit-comment": EditableDetailsViewReloadReason.COMMENTS_CHANGED,
            "delete-comment-dialog": EditableDetailsViewReloadReason.COMMENTS_CHANGED,
            "link-issue-dialog": EditableDetailsViewReloadReason.LINKED_ISSUE_CREATED_AND_COMMENTED,
            "delete-issue-dialog": EditableDetailsViewReloadReason.SUBTASKS_CHANGED,
            "assign-to-me-link-handler": EditableDetailsViewReloadReason.DETAILS_FIELD_CHANGED,
            "assign-dialog": EditableDetailsViewReloadReason.ISSUE_ASSIGNED_AND_COMMENTED
        },
        getReloadReasonForChangedField: function getReloadReasonForChangedField(changedFieldId) {
            var reason = REASON_FOR_CHANGED_FIELD[changedFieldId];
            if (reason) {
                return reason;
            } else {
                if (DetailsModel.isFieldInSection(changedFieldId, 'estimate') || DetailsModel.isFieldInSection(changedFieldId, 'tracking')) {
                    return EditableDetailsViewReloadReason.HEADER_FIELD_CHANGED;
                } else {
                    return EditableDetailsViewReloadReason.DETAILS_FIELD_CHANGED;
                }
            }
        }
    });
});