AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-rapid-config"], function () {
    module("showSummary", {
        setup: function setup() {
            GH.Test.setUpFakeServer(this);
        },
        teardown: function teardown() {
            GH.Test.restoreServer(this);
        }
    });

    test("submit: Successful AJAX call disposes the dialog", sinon.test(function () {

        GH.Test.respondToPostWith200(this, "/rapidviewconfig/columns", { progress: { taskId: 4 } });

        var dialog = {};
        dialog.dispose = this.stub();
        dialog.enableControls = this.stub();
        dialog.updateHeight = this.stub();

        GH.Dialogs.AddColumn.dialog = dialog;
        GH.Dialogs.AddColumn.submit(dialog, { rapidViewId: 1 });

        ok(GH.Test.isRequestDataStringified(this.server.requests[0]));

        this.server.respond();

        ok(dialog.dispose.called, "Called success method");
        ok(!dialog.enableControls.called, "Did not call error method");
    }));

    test("submit: Failed AJAX call enables dialog controls", sinon.test(function () {
        GH.Test.respondToPostWith500(this, "/classicmigration/epics", {});

        var dialog = {};
        dialog.dispose = this.stub();
        dialog.enableControls = this.stub();
        dialog.updateHeight = this.stub();

        GH.Dialogs.AddColumn.dialog = dialog;
        GH.Dialogs.AddColumn.submit(dialog, { rapidViewId: 1 });

        ok(GH.Test.isRequestDataStringified(this.server.requests[0]));

        this.server.respond();

        ok(!dialog.dispose.called, "Did not call success method");
        ok(dialog.enableControls.called, "Did not call success method");
    }));
});