AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-rapid"], function () {
    module("showDialog", {
        setup: function setup() {
            GH.Test.setUpFakeServer(this);
        },
        teardown: function teardown() {
            GH.Test.restoreServer(this);
        }
    });

    test("submit: Successful AJAX call disposes the dialog", sinon.test(function () {

        GH.Test.respondToPostWith200(this, "/workflow/status/create.json", {});

        var dialog = {};
        dialog.dispose = this.stub();
        dialog.enableControls = this.stub();
        dialog.updateHeight = this.stub();

        QUnit.GhFixtures.addFixture("<select id=\"ghx-status-name\" multiple=\"true\"/><option selected value='1'></option></select>");

        GH.Dialogs.CreateStatus.dialog = dialog;
        GH.Dialogs.CreateStatus.submit(dialog, 1);

        ok(GH.Test.isRequestDataStringified(this.server.requests[0]));

        this.server.respond();

        ok(dialog.dispose.called, "Called success method");
        ok(!dialog.enableControls.called, "Did not call error method");
    }));

    test("submit: Failed AJAX call enables dialog controls (no specific error handler)", sinon.test(function () {

        GH.Test.respondToPostWith500(this, "/workflow/status/create.json", {});

        var dialog = {};
        dialog.dispose = this.stub();
        dialog.enableControls = this.stub();
        dialog.updateHeight = this.stub();

        QUnit.GhFixtures.addFixture("<select id=\"ghx-status-name\" multiple=\"true\"/><option selected value='1'></option></select>");

        GH.Dialogs.CreateStatus.dialog = dialog;
        GH.Dialogs.CreateStatus.submit(dialog, 1);

        ok(GH.Test.isRequestDataStringified(this.server.requests[0]));

        this.server.respond();

        ok(dialog.enableControls.called, "Called failure method");
        ok(!dialog.dispose.called, "Did not call dispose method");
    }));
});