define('jira-agile/rapid/ui/kanplan/KanPlanInlineDialog', ['jquery', 'jira-agile/rapid/events', 'jira-help-tips/feature/help-tip'], function ($, Events, HelpTip) {
    'use strict';

    var KanPlanInlineDialog = function KanPlanInlineDialog() {
        //apply mixin
        new Events(this);
    };

    /**
     *
     * @returns {jQuery}
     */
    KanPlanInlineDialog.prototype.getInlineDialogAnchor = function () {
        return this.inlineDialogContainer;
    };

    /**
     *
     * @param {jQuery} target
     */
    KanPlanInlineDialog.prototype.setInlineDialogAnchor = function (target) {
        this.inlineDialogContainer = target;
    };

    /**
     *
     * @returns {AJS.HelpTip}
     */
    KanPlanInlineDialog.prototype.getInlineDialog = function () {
        return this.dialog;
    };

    /**
     *
     * @private
     */
    KanPlanInlineDialog.prototype.render = function () {
        if (this.isRendered) {
            return;
        }

        this.dialog = new HelpTip({
            title: AJS.I18n.getText('gh.boards.kanplan.enable.inlinedialog.title'),
            bodyHtml: AJS.I18n.getText('gh.boards.kanplan.enable.inlinedialog.text'),
            anchor: $(document.body),
            showCloseButton: true,
            closeButtonText: AJS.I18n.getText('gh.boards.kanplan.enable.inlinedialog.button.cancel'),
            showNextButton: true,
            nextButtonText: AJS.I18n.getText('gh.boards.kanplan.enable.inlinedialog.button.next'),
            callbacks: {
                init: function () {
                    this.trigger('dialog:init');
                    //init events only after HelpTip is rendered
                    this.initEvents();
                }.bind(this)
            }
        });

        //override of useless logic of original .show() method
        this.dialog.show = function () {
            this.view.show();
        };

        this.isRendered = true;
    };

    /**
     *
     * @returns {Element}
     */
    KanPlanInlineDialog.prototype.getInlineDialogDomElement = function () {
        return this.getInlineDialog().view.$el;
    };

    /**
     * @private
     */
    KanPlanInlineDialog.prototype.initEvents = function () {
        var $dialogContainer = this.getInlineDialogDomElement();

        var nextHandler = function () {
            this.trigger('moreButton:click');
        }.bind(this);

        $dialogContainer.find('.helptip-next').off('click', nextHandler).on('click', nextHandler);

        var closeHandler = function () {
            this.trigger('closeButton:click');
        }.bind(this);

        $dialogContainer.find('.helptip-close').off('click', closeHandler).on('click', closeHandler);

        $dialogContainer.addClass('js-kanplan-enable-inline-dialog');
    };

    KanPlanInlineDialog.prototype.show = function () {
        this.render();

        var anchor = this.getInlineDialogAnchor();

        this.getInlineDialog().view.changeAnchor(anchor);

        this.getInlineDialog().show();
    };

    KanPlanInlineDialog.prototype.hide = function () {
        if (this.getInlineDialog()) {
            this.getInlineDialog().hide();
        }
    };

    return KanPlanInlineDialog;
});