AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common-base", "com.pyxis.greenhopper.jira:gh-rapid"], function () {
    var BacklogView = require('jira-agile/rapid/ui/plan/BacklogView');
    var _ = require('underscore');
    var $ = require('jquery');
    var formatter = require('jira/util/formatter');

    test("module 'jira-agile/rapid/ui/plan/BacklogView' exists", function () {
        ok(BacklogView);
        ok(GH.BacklogView);
    });

    module('BacklogView#_updateIssuesVisibilityInIssueList', {
        setup: function setup() {
            this.$container = $('<div></div>');
            this.subtasksFilteredContent = sinon.stub(GH.tpl.planissuelist, 'renderSubtasksFilteredContent');
        },

        teardown: function teardown() {
            this.subtasksFilteredContent.restore();
        },

        getIssue: function getIssue(id) {
            return this.$container.find('.js-issue[data-issue-key="' + id + '"]');
        },

        assertIssueHidden: function assertIssueHidden(id) {
            ok(this.getIssue(id).is('.ghx-filtered'), 'Issue ' + id + ' is hidden');
        },

        assertIssueVisible: function assertIssueVisible(id) {
            ok(this.getIssue(id).is(':not(.ghx-filtered)'), 'Issue ' + id + ' is visible');
        },

        assertParentStubHidden: function assertParentStubHidden(id) {
            ok(this.getIssue(id).find('.ghx-parent-stub.ghx-filtered'), 'Parent stub of issue ' + id + ' should be hidden');
        },

        assertParentStubVisible: function assertParentStubVisible(id) {
            ok(this.getIssue(id).find('.ghx-parent-stub:not(.ghx-filtered)'), 'Parent stub of issue ' + id + ' should be visible');
        },

        assertCounterContainer: function assertCounterContainer(callNumber, hiddenSubtasks, allHidden) {
            deepEqual(this.subtasksFilteredContent.getCall(callNumber).args[0], {
                hiddenSubtasks: hiddenSubtasks,
                allHidden: allHidden
            });
        }
    });

    function createIssueRenderData() {
        var response = {
            hiddenIssues: {}
        };

        _.forEach(arguments, function (issueKey) {
            response.hiddenIssues[issueKey] = true;
        });

        return response;
    }

    function createIssue(options) {
        options = _.defaults(options, {
            subtasks: [],
            subtasksCount: 0,
            isSubtask: false,
            key: -1,
            hidden: false
        });

        var $element = $('<div class="js-issue"></div>');

        $element.attr('data-issue-key', options.key);
        $element.toggleClass('ghx-filtered', options.hidden);
        $element.toggleClass('ghx-issue-subtask', options.isSubtask);

        if (options.subtasks.length > 0) {
            options.subtasks.forEach(function ($subtask) {
                $element.append($subtask);
            });

            $element.append('<div class="ghx-parent-stub"></div>');
            $element.addClass('ghx-parent-group');

            var $counterContainer = $('<div class="ghx-hidden-subtasks-count-container"></div>');
            $counterContainer.attr('data-subtasks-hidden-by-filters', options.subtasksCount);

            $element.append($counterContainer);
        }

        return $element;
    }

    function createSubtask(options) {
        options.isSubtask = true;
        return createIssue(options);
    }

    test('hidden issues should be hidden, visible should be visible, no matter of previous state', function () {
        this.$container.append(createIssue({ key: 1, hidden: true }));
        this.$container.append(createIssue({ key: 2 }));
        this.$container.append(createIssue({ key: 3 }));

        BacklogView._updateIssuesVisibilityInIssueList(this.$container, createIssueRenderData(2));

        this.assertIssueVisible(1);
        this.assertIssueHidden(2);
        this.assertIssueVisible(3);
    });

    test('allHidden should be true if all issues will be hidden after operation', function () {
        this.$container.append(createIssue({ key: 1, hidden: true }));
        this.$container.append(createIssue({ key: 2 }));

        var allHidden = BacklogView._updateIssuesVisibilityInIssueList(this.$container, createIssueRenderData(1, 2));

        ok(allHidden);
    });

    test('allHidden should be true if at least one issue will be visible after operation', function () {
        this.$container.append(createIssue({ key: 1, hidden: true }));
        this.$container.append(createIssue({ key: 2 }));

        var allHidden = BacklogView._updateIssuesVisibilityInIssueList(this.$container, createIssueRenderData(1));

        ok(!allHidden);
    });

    test('should filter also subtasks', function () {
        this.$container.append(createIssue({ key: 1, hidden: true, subtasks: [createSubtask({ key: 2 }), createSubtask({ key: 3, hidden: true })] }));

        BacklogView._updateIssuesVisibilityInIssueList(this.$container, createIssueRenderData(2));

        this.assertIssueVisible(1);
        this.assertIssueHidden(2);
        this.assertIssueVisible(3);
    });

    test('when all subtasks are filtered parent stub should be also filtered', function () {
        this.$container.append(createIssue({ key: 1, hidden: true, subtasks: [createSubtask({ key: 2 }), createSubtask({ key: 3, hidden: true })] }));

        BacklogView._updateIssuesVisibilityInIssueList(this.$container, createIssueRenderData(2, 3));

        this.assertParentStubHidden(1);
    });

    test('when at least one subtask is visible, parent stub should also be visible', function () {
        this.$container.append(createIssue({ key: 1, hidden: true, subtasks: [createSubtask({ key: 2 }), createSubtask({ key: 3, hidden: true })] }));

        BacklogView._updateIssuesVisibilityInIssueList(this.$container, createIssueRenderData(3));

        this.assertParentStubVisible(1);
    });

    test('when all subtasks are hidden counter container should have all hidden set to true', function () {
        this.$container.append(createIssue({ key: 1, hidden: true, subtasks: [createSubtask({ key: 2 }), createSubtask({ key: 3, hidden: true })] }));
        this.$container.append(createIssue({ key: 5 }));

        BacklogView._updateIssuesVisibilityInIssueList(this.$container, createIssueRenderData(2, 3, 5));

        this.assertCounterContainer(0, 2, true);
    });

    test('when at least one subtask is visible, hidden counter container should have all hidden set to false', function () {
        this.$container.append(createIssue({ key: 1, hidden: true, subtasks: [createSubtask({ key: 2 }), createSubtask({ key: 3, hidden: true })] }));
        this.$container.append(createIssue({ key: 5 }));

        BacklogView._updateIssuesVisibilityInIssueList(this.$container, createIssueRenderData(2, 5));

        this.assertCounterContainer(0, 1, false);
    });

    test('counter container should sum all containers and ', function () {
        this.$container.append(createIssue({ key: 1, subtasksCount: 10, subtasks: [createSubtask({ key: 2 }), createSubtask({ key: 3, hidden: true })] }));
        this.$container.append(createIssue({ key: 11, subtasksCount: 5, subtasks: [createSubtask({ key: 12 }), createSubtask({ key: 13, hidden: true })] }));
        this.$container.append(createIssue({ key: 21, subtasksCount: 0, subtasks: [createSubtask({ key: 22 }), createSubtask({ key: 23 }), createSubtask({ key: 24, hidden: true })] }));

        BacklogView._updateIssuesVisibilityInIssueList(this.$container, createIssueRenderData(11, 22, 23));

        this.assertCounterContainer(0, 10, false);
        this.assertCounterContainer(1, 5, false);
        this.assertCounterContainer(2, 2, false);
    });
    module('BacklogView - Sticky header', {
        setup: function setup() {
            this.$currentSprint = $("<div class=\"ghx-backlog-container\">\n                    <div class=\"ghx-backlog-header\"></div>\n                 </div>");
            this.$previousSprint = this.$currentSprint.clone();
            var $fixturesContainer = $(QUnit.GhFixtures.getFixturesContainer());
            $fixturesContainer.append(this.$currentSprint, this.$previousSprint);
            this.context = {
                element: this.$currentSprint,
                next: function next() {
                    return {
                        element: this.$previousSprint
                    };
                }
            };
        }
    });

    test('should remove stuck from previous header', function () {
        this.$previousSprint.find('.ghx-backlog-header').addClass('stuck');
        BacklogView.waypointHandler.call(this.context, 'up');
        ok(!this.$previousSprint.hasClass('stuck'));
    });
});