AJS.test.require("com.pyxis.greenhopper.jira:gh-rapid", function () {
    var PlanRankController = require('jira-agile/rapid/ui/plan/plan-rank-controller');
    var BacklogSelectionController = require('jira-agile/rapid/ui/plan/backlog-selection-controller');
    var BacklogModel = require('jira-agile/rapid/ui/plan/backlog-model');
    var IssueListModel = require('jira-agile/rapid/ui/plan/issue-list-model');

    test("module 'jira-agile/rapid/ui/plan/plan-rank-controller' exists", function () {
        ok(PlanRankController);
        ok(GH.PlanRankController);
    });

    test("rankCreatedIssues", function () {
        this.stub(BacklogSelectionController, "getSelectedIssuesInOrder");
        var issues = JSON.parse('[{"issueKey":"PRO-12","issueId":"10901","issueType":"10001"}]');
        var retval = PlanRankController.rankCreatedIssues(issues);

        ok(BacklogSelectionController.getSelectedIssuesInOrder.called, "Called getSelectedIssuesInOrder() on BacklogSelectionController");

        equal(retval, undefined, "Returns undefined");
    });

    test("rankCreatedIssuesBySelection", function () {
        var issues = JSON.parse('[{"issueKey":"PRO-12","issueId":"10901","issueType":"10001"}]');
        var bm2 = new GH.BacklogModel2(issues);
        var issueList = new IssueListModel('backlog', issues, GH.VersionController.getVersionModel());
        this.stub(bm2, "getIssueList").returns(issueList);
        this.stub(BacklogModel, "getBacklogModel2").returns(bm2);

        var retval = PlanRankController.rankCreatedIssuesBySelection(issues);

        ok(bm2.getIssueList.called, "Called getIssues() on BacklogModel2");
    });

    test("rankCreatedIssuesByVisibility", function () {
        var issues = JSON.parse('[{"issueKey":"PRO-12","issueId":"10901","issueType":"10001"}]');

        var retval = PlanRankController.rankCreatedIssuesByVisibility(issues);

        equal(retval, undefined, "Returns undefined");
    });

    test("rankCreatedIssuesAgainstIssue", function () {
        var issues = JSON.parse('[{"issueKey":"PRO-12","issueId":"10901","issueType":"10001"}]');

        var retval = PlanRankController.rankCreatedIssuesAgainstIssue(issues, "", "");

        ok(typeof retval.done === "function", "Returns a promise");
    });
});