/* global AJS, GH */
define('jira-agile/rapid/ui/plan/contextmenu/split-issue-dialog-controller', function() {
    "use strict";

    function Controller(issue, backlogController) {
        this.issue = issue;
        this.backlogController = backlogController;
    }

    Controller.prototype.bind = function(view) {
        this.view = view;
        this.view.on('submit', this.onSubmit, this);
    };

    Controller.prototype.onSubmit = function(payload) {
        putSplitIssue(this.issue.id, payload)
            .done(function(response) {
                    if (response.success.errors) {
                        this.view.processValidationErrors(response.success.errors);
                    } else {
                        this.view.hide();
                        this.backlogController.loadData();
                    }
                }.bind(this))
            .fail(function() {
                    this.view.hide();
                }.bind(this));

        AJS.trigger('analytics', {
            name: 'gh.issue.ctx.menu.action.split.submit',
            data: {
                newIssueCount: payload.newIssues.length
            }
        });
    };

    function putSplitIssue(issueId, payload) {
        return GH.Ajax.put({
            url: '/issue/' + issueId + '/split',
            data: payload
        });
    }

    return Controller;
});