AJS.test.require('com.pyxis.greenhopper.jira:gh-rapid', function() {

    var paramPassedToView;

    module('Card printing controller tests', {
        setup: function() {
            this.context = AJS.test.mockableModuleContext();
            paramPassedToView = null;

            var fakeView = {
                showPrintScreen : function(param) {
                    paramPassedToView = param;
                }
            };
            this.context.mock('jira-agile/rapid/ui/print/card-printing-view', fakeView);
        }
    });

    test('Test printing plan view', function() {
        var cardPrintingController = this.context.require('jira-agile/rapid/ui/print/card-printing-controller');

        cardPrintingController.printBoardPlanView(createPlanViewData());

        equal(paramPassedToView.issues.length, 3, 'sprint issues must be merged with backlog issues');
        // make sure issues are in in the correct order: sprint > backlog
        // and correct card category
        assertIssueSentToView(paramPassedToView.issues[0], 'ISS-1', 'sprint-1');
        assertIssueSentToView(paramPassedToView.issues[1], 'ISS-2', 'sprint-2');
        assertIssueSentToView(paramPassedToView.issues[2], 'ISS-3', 'backlog');

        // assert filter items
        equal(paramPassedToView.selectedItem, 'all', 'Default filter must be All issues');
        equal(paramPassedToView.filterItems.length, 2, 'Expect 2 sections: one for all issues & backlog, the other for sprints');
        assertFilterItem(paramPassedToView.filterItems[0][0], 'backlog', 'gh.rapid.plan.backlog.name');
        assertFilterItem(paramPassedToView.filterItems[0][1], 'all', 'gh.issue.all.title');
        assertFilterItem(paramPassedToView.filterItems[1][0], '1', 'sprint 1');
        assertFilterItem(paramPassedToView.filterItems[1][1], '2', 'sprint 2');

        // verify analytic initiative data
        assertPrintActionContext(paramPassedToView.actionContext, 'boardMenu', 'plan', 'scrum');
    });

    test('Test printing work view', function() {
        var cardPrintingController = this.context.require('jira-agile/rapid/ui/print/card-printing-controller');

        cardPrintingController.printBoardWorkView({
            issues: [
                { key : 'ISS-2' },
                { key : 'ISS-1' }
            ],
            viewMode: 'work',
            boardType: 'kanban'
        });

        equal(paramPassedToView.issues.length, 2, 'issues passed to the view must be the same as issues passed to the controller');
        // preserve the order of issues, no sorting in side the controller
        // no card category
        assertIssueSentToView(paramPassedToView.issues[0], 'ISS-2', null);
        assertIssueSentToView(paramPassedToView.issues[1], 'ISS-1', null);
        // no filter
        equal(paramPassedToView.filterItems, undefined, 'no filter when printing work-mode issues');
        // data for analyctic
        assertPrintActionContext(paramPassedToView.actionContext, 'boardMenu', 'work', 'kanban');
    });

    test('Test printing selected issues', function() {
        var cardPrintingController = this.context.require('jira-agile/rapid/ui/print/card-printing-controller');

        cardPrintingController.printSelectedIssues({
            issues: [
                { key : 'ISS-2' },
                { key : 'ISS-1' }
            ],
            viewMode: 'work',
            boardType: 'scrum'
        });

        equal(paramPassedToView.issues.length, 2, 'issues passed to the view must be the same as issues passed to the controller');
        // preserve the order of issues, no sorting in side the controller
        // no card category
        assertIssueSentToView(paramPassedToView.issues[0], 'ISS-2', null);
        assertIssueSentToView(paramPassedToView.issues[1], 'ISS-1', null);
        // no filter
        equal(paramPassedToView.filterItems, undefined, 'no filter when printing selected issues');
        // data for analyctic
        assertPrintActionContext(paramPassedToView.actionContext, 'contextMenu', 'work', 'scrum');
    });

    function createPlanViewData() {
        return {
            sprintIssues: [
                {
                    sprintId: 1,
                    sprintName: 'sprint 1',
                    issues: [
                        {
                            key: 'ISS-1'
                        }
                    ]
                },
                {
                    sprintId: 2,
                    sprintName: 'sprint 2',
                    issues: [
                        {
                            key: 'ISS-2'
                        }
                    ]
                },
                {
                    sprintId: 3,
                    sprintName: 'sprint 2'
                    // empty sprint
                }
            ],
            backlogIssues: [
                {
                    key: 'ISS-3'
                }
            ],
            viewMode: 'plan',
            boardType: 'scrum'
        };
    }

    function assertIssueSentToView(issue, expectedKey, expectedCategory) {
        equal(issue.key, expectedKey);
        equal(issue.cardPrintingCategory, expectedCategory);
    }

    function assertFilterItem(item, expectedId, expectedLabel) {
        equal(item.id, expectedId);
        equal(item.label, expectedLabel);
    }

    function assertPrintActionContext(context, expectedTriggeredFrom, expectedViewMode, expectedBoardType) {
        equal(context.triggeredFrom, expectedTriggeredFrom);
        equal(context.viewMode, expectedViewMode);
        equal(context.boardType, expectedBoardType);
    }
});