GH.VersionQuickCreate = {};

GH.VersionQuickCreate.EVENT_VERSION_CREATED = "versionCreated";
GH.VersionQuickCreate.datePickerFormat = undefined;
GH.VersionQuickCreate.accessibleProjects = [];

/** @param {string} datePickerFormat */
GH.VersionQuickCreate.setDatePickerFormat = function (datePickerFormat) {
    GH.VersionQuickCreate.datePickerFormat = datePickerFormat;
};

/** @param {number} accessibleProjects */
GH.VersionQuickCreate.setAccessibleProjects = function (accessibleProjects) {
    GH.VersionQuickCreate.accessibleProjects = accessibleProjects;
};

GH.VersionQuickCreate.showDialog = function () {
    AJS.dim();
    AJS.$('.aui-blanket').html('<span class="ghx-wait"></span>');

    GH.VersionQuickCreate.renderDialog();
};

GH.VersionQuickCreate.renderDialog = function () {
    // create the dialog
    var dialog = GH.Dialog.create({
        width: 450,
        height: 350,
        id: 'ghx-dialog-create-version'
    });
    dialog.addHeader(AJS.I18n.getText('gh.version.create.dialog.title'));
    dialog.addPanel('', 'panel');

    dialog.getCurrentPanel().html(GH.tpl.versionview.renderQuickCreateView({ projects: GH.VersionQuickCreate.accessibleProjects }));

    dialog.addButton(AJS.I18n.getText('gh.version.create.dialog.ok.button.label'), function () {
        dialog.disableControls();
        GH.VersionQuickCreate.submit(dialog);
    }, 'aui-button');
    GH.Dialog.addCancelButton(dialog);

    GH.VersionQuickCreate.registerProjectControls();
    GH.VersionQuickCreate.registerCalendarControls();

    AJS.$('.aui-dialog').addClass('ghx-dialog');

    dialog.show();
    dialog.updateHeight();
    AJS.$('.aui-blanket').empty();

    // give focus to first input element
    AJS.$('#ghx-version-name').focus();
};

/**
 * Submit the dialog
 */
GH.VersionQuickCreate.submit = function (dialog) {
    GH.Validation.clearContextualErrors(AJS.$("#ghx-dialog-create-version"));
    var model = GH.VersionQuickCreate._extractModel();

    GH.Ajax.post({
        url: '/versions',
        data: model,
        errorContextMap: {
            'projectId': '#ghx-version-project',
            'name': '#ghx-version-name',
            'startDate': '#ghx-version-start-date-error',
            'releaseDate': '#ghx-version-release-date-error'
        }
    }).done(function (response) {

        var createdVersion = response.success;

        // close our dialog
        dialog.dispose();

        // show a success message
        GH.Notification.showSuccess(AJS.I18n.getText("gh.api.version.created", "<strong>" + AJS.escapeHTML(String(createdVersion.name)) + "</strong>"));

        // tell parties about the success
        AJS.$(GH).trigger(GH.VersionQuickCreate.EVENT_VERSION_CREATED, [{ 'createdVersion': createdVersion }]);
    }).fail(dialog.enableControls);
};

GH.VersionQuickCreate.registerCalendarControls = function () {
    var cal = new Calendar(); // GHS-5829 Need to call new calendar to set up short month names and day names when they are not defined

    Calendar.setup({
        firstDay: 0,
        inputField: 'ghx-version-release-date',
        button: 'ghx-version-release-date_trigger_c',
        align: 'Tl',
        singleClick: true,
        showsTime: false,
        timeFormat: 12,
        positionStyle: 'fixed',
        ifFormat: GH.VersionQuickCreate.datePickerFormat
    });

    Calendar.setup({
        firstDay: 0,
        inputField: 'ghx-version-start-date',
        button: 'ghx-version-start-date_trigger_c',
        align: 'Tl',
        singleClick: true,
        showsTime: false,
        timeFormat: 12,
        positionStyle: 'fixed',
        ifFormat: GH.VersionQuickCreate.datePickerFormat
    });
};

GH.VersionQuickCreate.registerProjectControls = function () {
    return new AJS.SingleSelect({
        element: AJS.$("#ghx-version-project"),
        revertOnInvalid: true,
        width: 250
    });
};

GH.VersionQuickCreate.registerCreateVersionDialog = function () {
    var $versionColumn = AJS.$("#ghx-version-column");
    $versionColumn.find('.js-create-version').click(function () {
        GH.VersionQuickCreate.showDialog();
    });
};

GH.VersionQuickCreate._extractModel = function () {
    var dialog = AJS.$('#ghx-dialog-create-version');
    return {
        projectId: dialog.find('#ghx-version-project :selected').val(),
        name: dialog.find('#ghx-version-name').val(),
        description: dialog.find('#ghx-version-description').val(),
        releaseDate: dialog.find('#ghx-version-release-date').val(),
        startDate: dialog.find("#ghx-version-start-date").val()
    };
};