/* global AJS, jQuery, sinon, module, test, ok */
AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "jira.webresources:calendar", "jira.webresources:calendar-en", "com.pyxis.greenhopper.jira:gh-rapid"], function () {
    "use strict";

    var BacklogModel = require('jira-agile/rapid/ui/plan/backlog-model');

    var fakeProject = { id: 10001, key: "FAKE" };
    var number = 1;
    function fakeVersion(name) {
        return {
            description: "",
            name: name,
            id: number++,
            projectId: fakeProject.id,
            project: fakeProject,
            released: false,
            versionStats: { doneEstimate: 0 }
        };
    }

    var fakeEpicModel = new GH.EpicModel();
    fakeEpicModel.setData({ epics: [] });
    var fakeVersionModel = new GH.VersionsModel([fakeProject]);
    var fakeVersion1 = fakeVersion("One");
    var fakeVersion2 = fakeVersion("Two");
    fakeVersionModel.fixVersions = [fakeVersion1, fakeVersion2];

    module("VersionView", {
        setup: function setup() {
            // data for ScrumBase and KanPlanBase decide if it can handle the data or not
            GH.RapidViewConfig.currentData.data = {
                sprintSupportEnabled: true
            };

            this.context = AJS.test.mockableModuleContext();
            this.context.mock('jira-agile/rapid/ui/plan/analytics-helper', {
                baseEventData: sinon.stub().returns({})
            });
            this.context.mock('jira-agile/rapid/ui/version/version-controller', {
                getVersionModel: sinon.stub().returns(fakeVersionModel),
                updateVersion: sinon.stub().returns(jQuery.Deferred().resolve().promise()),
                getFilteredVersionId: sinon.stub(),
                setFilteredVersionId: sinon.stub(),
                sendAnalytics: sinon.stub()
            });

            this.versionView = this.context.require('jira-agile/rapid/ui/version/version-view');

            jQuery.fx.off = true;
            this.$el = jQuery('<div id="ghx-version-column" class="ghx-version-column ghx-classification-column"></div>').appendTo('#qunit-fixture');
            this.sandbox = sinon.sandbox.create();
            this.sandbox.stub(this.versionView, 'getTwixieState').returns('open'); // Otherwise test starting state is indeterminate
            this.sandbox.stub(this.versionView, 'setTwixieState'); // Otherwise test starting state is indeterminate
            this.sandbox.stub(BacklogModel, 'getAllIssueListsNew').returns([]);
            this.sandbox.stub(GH.EpicController, 'getEpicModel').returns(fakeEpicModel);
            this.sandbox.stub(GH.RapidBoard.Util.InlineEditable, 'datePickerActivate');
            this.sandbox.stub(fakeVersionModel, 'getUnreleasedVersionList').returns(fakeVersionModel.fixVersions);
            this.sandbox.stub(fakeVersionModel, 'canUserCreateVersion').returns(true);
            this.sandbox.stub(fakeVersionModel, 'isLinkToDevStatusVersionAvailable').returns(true);
            this.toggleSpy = this.sandbox.spy(this.versionView, 'toggleFiltering');
            GH.Test.setUpFakeServer(this);
        },
        teardown: function teardown() {
            this.sandbox.restore();
            GH.Test.restoreServer(this);
            jQuery.fx.off = false;
        },
        setupScrum: function setupScrum() {
            this.sandbox.stub(GH.RapidBoard.State, 'isScrumBoard').returns(true);
            this.sandbox.stub(GH.RapidBoard.State, 'isKanbanBoard').returns(false);

            this.versionView.init();
            this.versionView.show();
        },
        setupKanban: function setupKanban() {
            this.sandbox.stub(GH.RapidBoard.State, 'isScrumBoard').returns(false);
            this.sandbox.stub(GH.RapidBoard.State, 'isKanbanBoard').returns(true);

            this.versionView.init();
            this.versionView.show();
        }
    });

    test("Clicking the version filters the backlog", function () {
        this.setupScrum();
        var $version = jQuery(".ghx-classification-item[data-version-id=" + fakeVersion1.id + "]");

        $version.click();
        ok(this.toggleSpy.calledOnce, "should have filtered the backlog");
    });

    test("Clicking the expand/collapse icon collapses the version info", function () {
        this.setupScrum();
        var $version = jQuery(".ghx-classification-item[data-version-id=" + fakeVersion1.id + "]");
        var $icon = jQuery(".js-version-details-toggle", $version);
        ok($version.hasClass("ghx-open"), "should start open");

        $icon.click();
        ok($version.hasClass("ghx-closed"), "shouldn't be considered open any more");
        ok(!$version.hasClass("ghx-open"), "should be considered closed");
        ok(this.toggleSpy.notCalled, "should not toggle backlog filtering");
    });

    test("Clicking the details link does not filter the backlog", function () {
        this.setupScrum();
        var $version = jQuery(".ghx-classification-item[data-version-id=" + fakeVersion1.id + "]");
        var $details = jQuery(".js-version-details-link", $version);
        $details.on("click", function (e) {
            e.preventDefault();
        }); // So we don't follow the href
        $details.click();
        ok(this.toggleSpy.notCalled, "should not toggle backlog filtering");
    });

    test("Editing the start date field does not filter the backlog", function () {
        this.setupScrum();
        var $version = jQuery(".ghx-classification-item[data-version-id=" + fakeVersion1.id + "]");
        var $startDate = jQuery(".js-edit-startDateFormatted-trigger", $version);

        $startDate.click();
        ok(this.toggleSpy.notCalled, "should not toggle backlog filtering");

        var $calendarPicker = jQuery(".aui-iconfont-calendar", $version);
        $calendarPicker.click();
        ok(this.toggleSpy.notCalled, "should not toggle backlog filtering");
    });

    test("Should display estimation group when Scrum", function () {
        this.setupScrum();
        console.info('isScrumBoard', GH.RapidBoard.State.isScrumBoard());
        var estimates = jQuery(".ghx-estimates");
        var progressBar = jQuery(".ghx-classification-progress");

        ok(estimates.length > 0, 'estimates should be visible');
        ok(progressBar.length > 0, 'progress bar should be visible');
    });

    test("Should not display estimation group when Kanban", function () {
        this.setupKanban();
        console.info('isScrumBoard', GH.RapidBoard.State.isScrumBoard());
        var estimates = jQuery(".ghx-estimates");
        var progressBar = jQuery(".ghx-classification-progress");

        ok(estimates.length === 0, 'estimates should not be visible');
        ok(progressBar.length === 0, 'progress bar should not be visible');
    });
});