/**
 * globals
 * GH.WorkController, GH.GH.Ajax
 */

/**
 * Render the active sprint empty message
 * @module jira-agile/rapid/ui/work/ActiveSprintEmptyView
 * @requires module:jquery
 */
define("jira-agile/rapid/ui/work/ActiveSprintEmptyView", ["jquery"], function ($) {
    "use strict";

    // private constants

    var CONTEXT_PATH = AJS.contextPath();
    var BACKLOG_LINK_FORMAT = CONTEXT_PATH + "/secure/RapidBoard.jspa?rapidView={0}&view=planning.nodetail";
    var CLEAR_ALL_FILTERS_LINK_FORMAT = CONTEXT_PATH + "/secure/RapidBoard.jspa?rapidView={0}";
    var CONFIGURATION_LINK_FORMAT = CONTEXT_PATH + "/secure/RapidView.jspa?rapidView={0}";
    var COLUMNS_CONFIGURATION_LINK_FORMAT = CONTEXT_PATH + "/secure/RapidView.jspa?rapidView={0}&tab=columns";
    var CLASS_NAME = {
        HIDDEN: "hidden",
        DASHBOARD_MODE: "dashboard-mode",
        NO_MAPPED_COLUMNS_MODE: "no-mapped-columns-mode"
    };

    var handleNoActiveSprint = function handleNoActiveSprint(e) {
        e.preventDefault();
        GH.WorkController.trigger(GH.WorkController.EVENT_NAMES.ON_PLAN_MODE);
    };

    var clearAllFilter = function clearAllFilter(e) {
        e.preventDefault();
        GH.WorkController.trigger(GH.WorkController.EVENT_NAMES.ON_ALL_FILTERS_CLEARING);
    };

    /**
     * @constructor
     * @param {boolean} noActiveSprints     Indicate if the board has active sprint or not
     * @param {boolean} activeQuickFilters  Indicate if the quick filters is active or not
     * @param {number}  rapidViewId         The id of the current board
     * @param {boolean} noMappedColumns     Indicate if all columns is mapped or not
     * @param {jQuery}  container           The container of the view
     */
    function ActiveSprintEmptyView(noActiveSprints, activeQuickFilters, rapidViewId, noMappedColumns, container) {

        // create view
        var renderer;
        var linkAddr;
        var handler;
        if (noMappedColumns) {
            linkAddr = AJS.format(COLUMNS_CONFIGURATION_LINK_FORMAT, rapidViewId);
            renderer = GH.tpl.rapid.activesprintemptyview.noMappedColumns;
        } else if (noActiveSprints) {
            linkAddr = AJS.format(BACKLOG_LINK_FORMAT, rapidViewId);
            renderer = GH.tpl.rapid.activesprintemptyview.noActiveSprint;
            handler = handleNoActiveSprint;
        } else if (activeQuickFilters) {
            linkAddr = AJS.format(CLEAR_ALL_FILTERS_LINK_FORMAT, rapidViewId);
            renderer = GH.tpl.rapid.activesprintemptyview.clearAllFilters;
            handler = clearAllFilter;
        } else {
            linkAddr = AJS.format(CONFIGURATION_LINK_FORMAT, rapidViewId);
            renderer = GH.tpl.rapid.activesprintemptyview.noIssue;
        }

        //  linkAddr and ctaLinkHandler are added to an <a> DOM element, which comes from a translations file.
        //  when testing with qunit translations are not applied - thus the <a> doesn't exist.
        //  so instead we store what would have been added to the element here and test that instead.

        // exposed for testing
        this.linkAddr = linkAddr;
        this.view = $(renderer({
            linkAddr: linkAddr
        }));

        this.secondLineView = this.view.find("p");

        // register events
        this.ctaLink = this.secondLineView.find("a").click(handler);

        // exposed for testing
        this.ctaLinkHandler = handler;

        GH.WorkController.on(GH.WorkController.EVENT_NAMES.ON_RELOAD_EMPTY_STATE_VIEW, this._reloadView, this);

        $(container).append(this.view);
    }

    /**
     * Update the view when it show in the dashboard
     */
    ActiveSprintEmptyView.prototype.handleOnDashboardMode = function () {
        this.view.addClass(CLASS_NAME.DASHBOARD_MODE);
    };

    /**
     * Update the view when the status is no mapped column
     */
    ActiveSprintEmptyView.prototype.handleNoMappedColumnsMode = function () {
        this.view.addClass(CLASS_NAME.NO_MAPPED_COLUMNS_MODE);
    };

    /**
     * Handler for the reload view event
     * @param {boolean} canEdit Indicate if the current user can edit the board or not
     */
    ActiveSprintEmptyView.prototype._reloadView = function (canEdit) {
        if (canEdit) {
            this.secondLineView.removeClass(CLASS_NAME.HIDDEN);
        }
    };

    return ActiveSprintEmptyView;
});