AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-rapid"], function() {
    var ActiveSprintEmptyView;
    module("ActiveSprintEmptyView", {
        setup: function () {
            ActiveSprintEmptyView = require("jira-agile/rapid/ui/work/ActiveSprintEmptyView");
        }
    });

    test("ActiveSprintEmptyView: ON_PLAN_MODE should be triggered when click event trigger on backlog link", sinon.test(function() {
        var noActiveSprints = true;
        var activeQuickFilters = false;
        var rapidViewId = 7;
        var noMappedColumns = false;

        this.stub(GH.WorkController, "trigger");

        var activeSprintEmptyMsg = new ActiveSprintEmptyView(
                noActiveSprints, activeQuickFilters, rapidViewId, noMappedColumns);

        // test the click handler rather than link itself as the click handler isn't bound in test scope
        //    (the <a /> comes from translations).
        ok(!_.isUndefined(activeSprintEmptyMsg.ctaLinkHandler), "The backlog link should be registered click event");

        activeSprintEmptyMsg.ctaLinkHandler({ preventDefault : function() {}});

        ok(GH.WorkController.trigger.calledWith(GH.WorkController.EVENT_NAMES.ON_PLAN_MODE),
            "ON_PLAN_MODE should be triggered");
    }));

    test("ActiveSprintEmptyView: ON_ALL_FILTERS_CLEARING should be triggered when click event trigger on clear all filter link",
        sinon.test(function() {
            var noActiveSprints = false;
            var activeQuickFilters = true;
            var rapidViewId = 7;
            var noMappedColumns = false;

            this.stub(GH.WorkController, "trigger");

            var activeSprintEmptyMsg = new ActiveSprintEmptyView(
                    noActiveSprints, activeQuickFilters, rapidViewId, noMappedColumns);
            var events = activeSprintEmptyMsg.ctaLink.data("events");

            ok(!_.isUndefined(activeSprintEmptyMsg.ctaLinkHandler), "The backlog link should be registered click event");

            activeSprintEmptyMsg.ctaLinkHandler({ preventDefault : function() {}});

            ok(GH.WorkController.trigger.calledWith(GH.WorkController.EVENT_NAMES.ON_ALL_FILTERS_CLEARING),
                "ON_ALL_FILTERS_CLEARING should be triggered");
    }));

    test("ActiveSprintEmptyView: CTA link should has address of configuration board when no active sprint, filters not "
        + "active and columns mapped", sinon.test(function() {
            var noActiveSprints = false;
            var activeQuickFilters = false;
            var rapidViewId = 7;
            var noMappedColumns = false;
            var linkAddr = AJS.format("{0}/secure/RapidView.jspa?rapidView={1}", GH.Ajax.CONTEXT_PATH, rapidViewId);

            var activeSprintEmptyMsg = new ActiveSprintEmptyView(
                    noActiveSprints, activeQuickFilters, rapidViewId, noMappedColumns);

            ok(linkAddr === activeSprintEmptyMsg.linkAddr, "CTA link should contain address of the configuration board");
    }));

    test("ActiveSprintEmptyView: CTA link should has address of columns configuration board when no active sprint, filters not "
        + "active and columns mapped", sinon.test(function() {
        var noActiveSprints = false;
        var activeQuickFilters = false;
        var rapidViewId = 7;
        var noMappedColumns = true;
        var linkAddr = AJS.format("{0}/secure/RapidView.jspa?rapidView={1}&tab=columns", GH.Ajax.CONTEXT_PATH, rapidViewId);

        var activeSprintEmptyMsg = new ActiveSprintEmptyView(
                noActiveSprints, activeQuickFilters, rapidViewId, noMappedColumns);

        ok(linkAddr === activeSprintEmptyMsg.linkAddr, "CTA link should contain address of the configuration board");
    }));
});