/* global _ */
AJS.test.require(["com.pyxis.greenhopper.jira:gh-rapid"], function () {
    var GridSwimlanesData = require('jira-agile/rapid/ui/work/grid-swimlanes-data');

    module("GridSwimlanesData", {
        setup: function setup() {
            this.issuesData = {
                issues: [{
                    key: 'PROJ-1',
                    projectId: 10000
                }, {
                    key: 'SW-2',
                    projectId: 10001
                }, {
                    key: 'KB-1',
                    projectId: 10002
                }, {
                    key: 'KB-2',
                    projectId: 10002
                }],
                projects: [{
                    id: 10000,
                    key: "PROJ",
                    name: "Project",
                    avatarUrl: "www.avatar.com/0"
                }, {
                    id: 10001,
                    key: "SW",
                    name: "Software Project",
                    avatarUrl: "www.avatar.com/1"
                }, {
                    id: 10002,
                    key: "KB",
                    name: "Kanban Project",
                    avatarUrl: "www.avatar.com/2"
                }]
            };
        },
        teardown: function teardown() {}
    });

    test("CalculateProjectSwimlanes: test project key ordering and issue grouping.", function () {
        var issuesData = this.issuesData;

        var swimlanes = GridSwimlanesData.calculateProjectSwimlanes(issuesData);

        ok(swimlanes.length === 3, "Expected 3 swimlanes");

        var swimlane0 = swimlanes[0];
        var project2 = issuesData.projects[2];
        ok(swimlane0.name === project2.key, "Swimlane's name is project key");
        ok(swimlane0.description === project2.name, "Swimlane's description is project name");
        ok(swimlane0.avatarUrl === project2.avatarUrl, "Swimlane uses correct project avatar");
        ok(swimlane0.issueKeys.length === 2, "Swimlane contains 2 issues");

        var swimlane1 = swimlanes[1];
        var project0 = issuesData.projects[0];
        ok(swimlane1.avatarUrl === project0.avatarUrl, "Swimlane uses correct project avatar");
        ok(swimlane1.issueKeys.length === 1, "Swimlane contains 1 issue");

        var swimlane2 = swimlanes[2];
        var project1 = issuesData.projects[1];
        ok(swimlane2.avatarUrl === project1.avatarUrl, "Swimlane uses correct project avatar");
        ok(swimlane2.issueKeys.length === 1, "Swimlane contains 1 issue");
    });

    test("CalculateProjectSwimlanes: no swimlane for Project without issues", function () {
        var issuesData = this.issuesData;
        var project = {
            id: 10003,
            key: "EMPTY",
            name: "Empty Project",
            avatarUrl: "www.avatar.com/3"
        };
        issuesData.projects.push(project);

        var swimlanes = GridSwimlanesData.calculateProjectSwimlanes(issuesData);

        ok(swimlanes.length === 3, "Expected 3 swimlanes");

        var swimlaneNames = _.map(swimlanes, function (swimlane) {
            return swimlane.name;
        });
        ok(swimlaneNames.indexOf(project.key) === -1, "Empty project should not be one of the swimlanes.");
    });
});