/* global GH */
define('jira-agile/rapid/work/work-controls', ['jquery'], function ($) {

    var WorkControls = {};

    WorkControls.rapidViewConfig = {};

    /**
     * Holds the quick filters component
     */
    WorkControls.quickfilters = undefined;
    WorkControls.sprintfilters = undefined;

    WorkControls.init = function () {
        // create the quick filters component
        WorkControls.quickfilters = new GH.Components.QuickFilters('activeQuickFilters');
        WorkControls.sprintfilters = new GH.Components.SprintFilters('workSprintFilters');

        // TODO: hacky!
        GH.Components.sprintFiltersInit();
        WorkControls.sprintfilters.initializeInlineEdits();

        // complete sprint
        $(document).delegate('#ghx-complete-sprint', 'click', WorkControls.openCompleteSprintDialog);

        // handle sprint completed events
        $(GH).bind(GH.Dialogs.CompleteSprintDialog.EVENT_SPRINT_COMPLETED, function (e, sprintId) {
            // Remove sprint meta after completing sprint
            $('#ghx-modes-tools .ghx-sprint-meta').remove();

            GH.ReportController.selectChart('sprintRetrospective');
            GH.RapidBoard.ViewController.setMode('report');
            GH.SprintRetrospectiveController.sprintPicker.storeSelectedItemId(sprintId);
            GH.SprintRetrospectiveController.tryMarkSprintForRetroDialog(sprintId);
        });

        // handle sprint updated events (Plan Mode can change sprints and they may not be updated when switching back to Work Mode)
        $(GH).bind(GH.Components.EVENT_SPRINT_UPDATED, WorkControls.handleSprintUpdated);
    };

    WorkControls.setRapidViewConfig = function (rapidViewConfig) {
        WorkControls.rapidViewConfig = rapidViewConfig;

        WorkControls.quickfilters.setRapidViewConfig(rapidViewConfig);
        WorkControls.sprintfilters.setRapidViewConfig(rapidViewConfig);
    };

    WorkControls.hasSprints = function () {
        return WorkControls.sprintfilters.hasSprints();
    };

    WorkControls.getBoardType = function () {
        if (WorkControls.hasSprints()) {
            return "scrum";
        } else {
            return "kanban";
        }
    };

    WorkControls.setSprintData = function (sprints, canManageSprints) {
        this.canManageSprints = canManageSprints;
        WorkControls.sprintfilters.setSprintData(sprints, canManageSprints);

        // also validate the current sprint selection
        WorkControls.sprintfilters.validateActiveSprints();
    };

    WorkControls.drawSprints = function () {
        WorkControls.sprintfilters.drawSprints();
    };

    /**
     * Handles a single sprint being updated, from another source such as Plan Mode
     * @param event
     * @param sprintData
     */
    WorkControls.handleSprintUpdated = function (event, sprintData) {
        WorkControls.sprintfilters.updateSprintData(sprintData.id, sprintData);
    };

    /**
     * Get all active quick filters ids.
     */
    WorkControls.getActiveQuickFilterIds = function () {
        return WorkControls.quickfilters.getActiveQuickFilters();
    };

    WorkControls.getActiveQuickFilterCount = function () {
        return WorkControls.getActiveQuickFilterIds().length;
    };

    /**
     * Set the active quick filter ids
     */
    WorkControls.setActiveQuickFilterIds = function (quickFilterIds) {
        WorkControls.quickfilters.setActiveQuickFilters(quickFilterIds);
    };

    /**
     * Get all active sprint ids.
     */
    WorkControls.getActiveSprintIds = function () {
        return WorkControls.sprintfilters.getActiveSprintFilters();
    };

    /**
     * Set the active quick filter ids
     */
    WorkControls.setActiveSprintFilterIds = function (sprintFilterIds) {
        WorkControls.sprintfilters.setActiveSprintFilters(sprintFilterIds);
    };

    WorkControls.renderControls = function () {
        var workControls = $('#ghx-controls-work');
        workControls.empty();

        // render the sprints info
        if (WorkControls.rapidViewConfig.sprintSupportEnabled && !GH.RapidBoard.ViewController.shouldShowSubnavigator()) {
            workControls.append(WorkControls.sprintfilters.renderComponent());
        }

        // render the quick filters
        workControls.append(WorkControls.quickfilters.renderQuickFilters({ mode: 'work' }));

        // render the presentation mode button
        GH.PresentationMode.render(true, workControls);

        // by default, disable the swimlane options until we're sure
        GH.ViewActions.setMode(GH.ViewActions.WORK_MODE);
        GH.ViewActions.setSwimlanes(false);
    };

    /**
     * Once the GridDataModel has been loaded, we can update the swimlane options.
     */
    WorkControls.updateSwimlaneOptions = function (hasSwimlanes) {
        // this can't be done during renderControls() because we have not yet loaded the GridDataModel
        GH.ViewActions.setSwimlanes(hasSwimlanes);
    };

    WorkControls.openCompleteSprintDialog = function (e) {
        e.preventDefault();

        var $elem = $(this);
        if ($elem.hasClass('ghx-disabled')) {
            return;
        }

        // fetch the sprint we try to release, ignore if we haven't got a sprint
        var sprintId = parseInt($elem.attr('data-sprint-id'), 10);
        var sprint = WorkControls.sprintfilters.getSprintById(sprintId);
        if (!sprint) {
            return;
        }

        WorkControls.sprintfilters.removeDialog();

        var rapidViewId = GH.RapidBoard.State.getRapidViewId();

        GH.Dialogs.CompleteSprintDialog.showDialog(rapidViewId, sprint.id);
    };

    WorkControls.resizeQuickFilters = function () {
        WorkControls.quickfilters.quickExpanderLayout({ mode: 'work' });
    };

    return WorkControls;
});

AJS.namespace('GH.WorkControls', null, require('jira-agile/rapid/work/work-controls'));