AJS.test.require([
    "com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-rapid"], function () {

    const WorkDragAndDrop = require('jira-agile/rapid/ui/work/work-drag-and-drop');
    const WorkTransitionService = require('jira-agile/rapid/ui/work/work-transition-service');
    const FeatureManager = require('jira/featureflags/feature-manager');

    module("queryPossibleTransitions", {
        setup: function () {
            GH.Test.setUpFakeServer(this);
        },
        teardown: function () {
            GH.Test.restoreServer(this);
        }
    });

    test("Successful Ajax request lists transition targets", sinon.test(function () {
        this.stub(WorkDragAndDrop, "initDropZones");

        GH.Test.respondToGetWith200(this, '/xboard/issue/transitions.json', {});

        WorkDragAndDrop.queryPossibleTransitions();

        this.server.respond();

        ok(WorkDragAndDrop.initDropZones.called, "Called success method");
    }));

    test("Failed request does nothing (no specific error handling)", sinon.test(function () {
        this.stub(WorkDragAndDrop, "initDropZones");

        GH.Test.respondToGetWith500(this, '/xboard/issue/transitions.json', {});

        WorkDragAndDrop.queryPossibleTransitions();

        this.server.respond();

        ok(!WorkDragAndDrop.initDropZones.called, "Does not call process function on failure");
    }));

    test("It correctly determines if optimistic transitions should be used", () => {
            "use strict";
            const featureManagerStub = sinon.stub(FeatureManager, "isFeatureEnabled");
            const workControllerStub = sinon.stub(GH.WorkController, "getStatisticField");
            const workTransitionServiceStub = sinon.stub(WorkTransitionService, "hasAnyTransitionHasScreen");

            featureManagerStub.onFirstCall().returns(false);
            ok(!WorkDragAndDrop._shouldUseOptimisticTransitions(), "Return false if feature is disabled");

            featureManagerStub.returns(true);
            ok(!WorkDragAndDrop._shouldUseOptimisticTransitions(), "Return false if no transition data");

            WorkTransitionService.data = {};
            workControllerStub.onFirstCall().returns('foo');
            ok(!WorkDragAndDrop._shouldUseOptimisticTransitions(), "Returns false if column has statistics");

            workControllerStub.returns('none');
            workTransitionServiceStub.onFirstCall().returns(true);
            ok(!WorkDragAndDrop._shouldUseOptimisticTransitions(), "Returns false if transition has screen");

            workTransitionServiceStub.returns(false);
            const modelStub = sinon.stub();
            const unsupportedSwimlaneStrategies = ["custom", "assignee", "assigneeUnassignedFirst"];

            unsupportedSwimlaneStrategies.forEach((swimlane, index) => modelStub.onCall(index).returns(swimlane));

            sinon.stub(GH.GridDataController, "getModel", () => ({getSwimlaneStrategy: modelStub}));
            let result = unsupportedSwimlaneStrategies
                .map(() => WorkDragAndDrop._shouldUseOptimisticTransitions())
                .every(result => !result);
            ok(result, "Returns false if unsupported swimlane");

            modelStub.returns('foo');
            ok(WorkDragAndDrop._shouldUseOptimisticTransitions(), "Returns true otherwise")
        }
    )
});