AJS.test.require(['com.pyxis.greenhopper.jira:gh-test-common', 'com.pyxis.greenhopper.jira:gh-rapid', 'com.pyxis.greenhopper.jira:gh-card-new'], function () {

    var WorkTransitionService = require('jira-agile/rapid/ui/work/work-transition-service');
    var issueKey = 'GH-1';

    module('WorkTransitionService', {
        setup: function setup() {
            var data = {
                projectAndIssueTypeToWorkflow: {
                    '1000': { 1: 'Workflow 1', 2001: 'Workflow 1', 2002: 'Workflow 2' },
                    '1001': { 2001: 'Workflow 1', 1: 'Workflow 2', 2002: 'Workflow 2' }
                },
                workflowToTransitions: {
                    'Workflow 1': [{ 'transitionId': 100, isInitial: true, 'toStatusId': 1, name: 'wf1 init transition' }, // initial transition
                    { 'transitionId': 1, 'toStatusId': 2, name: 'wf1 transition 1' }, // global transition
                    { 'transitionId': 3, 'fromStatusId': 2, 'toStatusId': 3, name: 'wf1 transition 3' }, { 'transitionId': 10, 'fromStatusId': 3, 'toStatusId': 4, name: 'wf1 transition 10' //duplicate id with transition in WF2
                    }],
                    'Workflow 2': [{ 'transitionId': 10, 'fromStatusId': 1, 'toStatusId': 2, name: 'wf2 init transition 10' }, { 'transitionId': 30, 'fromStatusId': 2, 'toStatusId': 3, name: 'wf2 init transition 30' }]
                }
            };
            WorkTransitionService.dataPromise.resolve(data);
            WorkTransitionService.data = data;
        }
    });

    test('getTransitionById() can find transition object when can find transition', function () {
        givenIssueWithProjectAndStatus(1001, 1);
        var transition = WorkTransitionService.getTransitionById(issueKey, 10);
        equal(transition.transitionId, 10);
        equal(transition.name, 'wf2 init transition 10');
    });

    test('getTransitionById() should return null when can not find transition', function () {
        givenIssueWithProjectAndStatus(1001, 1);
        var transition = WorkTransitionService.getTransitionById(issueKey, 11);
        equal(transition, null);
    });

    asyncTest('queryTransitionsForColumn() when column contains status included in global transition', function () {
        givenIssueWithProjectAndStatus(1000, 1);
        var column = { statusIds: ['2'] };
        WorkTransitionService.queryTransitionsForColumn(issueKey, column).done(function (transitions) {
            start();
            equal(transitions.length, 1);
            equal(transitions[0].transitionId, 1);
        });
    });

    asyncTest('queryTransitionsForColumn() when column contains status included in normal transition', function () {
        givenIssueWithProjectAndStatus(1000, 2);
        var column = { statusIds: ['3'] };
        WorkTransitionService.queryTransitionsForColumn(issueKey, column).done(function (transitions) {
            start();
            equal(transitions.length, 1);
            equal(transitions[0].transitionId, 3);
        });
    });

    asyncTest('queryTransitionsForColumn() when column has more than 1 status', function () {
        givenIssueWithProjectAndStatus(1000, 2);
        var column = { statusIds: ['2', '3'] };
        WorkTransitionService.queryTransitionsForColumn(issueKey, column).done(function (transitions) {
            start();
            equal(transitions.length, 2);
            equal(transitions[0].transitionId, 1);
            equal(transitions[1].transitionId, 3);
        });
    });

    asyncTest('queryTransitionsForColumn() should return empty array when can not find transition', function () {
        givenIssueWithProjectAndStatus(1000, 2);
        var column = { statusIds: ['4'] };
        WorkTransitionService.queryTransitionsForColumn(issueKey, column).done(function (transitions) {
            start();
            equal(transitions.length, 0);
        });
    });

    asyncTest('queryTransitionsForColumn() when issue belongs to the second project', function () {
        givenIssueWithProjectAndStatus(1001, 2);
        var column = { statusIds: ['3'] };
        WorkTransitionService.queryTransitionsForColumn(issueKey, column).done(function (transitions) {
            start();
            equal(transitions.length, 1);
            equal(transitions[0].transitionId, 30);
        });
    });

    var givenIssueWithProjectAndStatus = function givenIssueWithProjectAndStatus(projectId, statusId) {
        var issueData = GH.IssueTest.createIssueObject({
            'key': issueKey,
            'projectId': projectId,
            'statusId': statusId
        });

        GH.GridDataController.model = GH.Test.Builders.gridDataModel().withIssue(issueData).build();
    };
});