/* global AJS, JIRA */
define('jira-agile/subnavigator/report-subnavigator-context-provider', ['underscore', 'jira/util/browser', 'jira-agile/rapid/ui/chart/report-controller'], function (_, utilBrowser, ReportController) {

    var contextProvider = {
        selectionHandler: function selectionHandler(selectedItemId) {
            if (selectedItemId === 'com.atlassian.jira.jira-projects-plugin:report-page') {
                var url = AJS.contextPath() + '/projects/' + JIRA.API.Projects.getCurrentProjectKey() + '?selectedItem=' + selectedItemId;
                utilBrowser.reloadViaWindowLocation(url);
            } else {
                ReportController.selectChart(selectedItemId);
                this._storeLastViewedReportLink(selectedItemId); //we just selected a new agile report - remember this.
            }
        },

        header: function header() {
            return ReportController.rapidViewConfig.name;
        },

        hasSubnavigator: function hasSubnavigator() {
            return true;
        },

        itemList: function itemList() {
            var reports = _.map(ReportController.getApplicableCharts(), function (report) {
                return {
                    id: report.id,
                    label: report.name,
                    description: report.tooltip
                };
            });

            if (JIRA.API.Sidebar.isProjectSidebar()) {
                return [reports, [{
                    id: 'com.atlassian.jira.jira-projects-plugin:report-page',
                    label: AJS.I18n.getText('gh.rapid.subnavigator.report.item.all.label'),
                    description: AJS.I18n.getText('gh.rapid.subnavigator.report.item.all.description')
                }]];
            } else {
                return reports;
            }
        },

        onLoad: function onLoad() {
            var reportId = this.selectedItem();
            this._storeLastViewedReportLink(reportId); //report view just loaded - remember the report on display.
        },

        selectedItem: function selectedItem() {
            return ReportController.getSelectedChart();
        },

        getChangeViewText: function getChangeViewText() {
            return AJS.I18n.getText('gh.rapid.subnavigator.report.change.view');
        },

        analyticEvent: function analyticEvent(itemId, initialLoad) {
            return {
                name: 'jira.project.sidebar.report.select',
                data: {
                    reportId: itemId,
                    initialLoad: initialLoad
                }
            };
        },

        _storeLastViewedReportLink: function _storeLastViewedReportLink(reportId) {
            JIRA.API.getSidebar().done(function (sidebarApi) {
                if (sidebarApi.isProjectSidebar() && JIRA.Projects.Sidebar.Reports) {
                    //Only store if we're in a project context AND the store API exists.
                    var rapidViewId = ReportController.rapidViewData.id;
                    var projectKey = JIRA.API.Projects.getCurrentProjectKey();
                    var url = AJS.contextPath() + '/secure/RapidBoard.jspa?rapidView=' + rapidViewId + '&projectKey=' + projectKey + '&view=reporting&chart=' + reportId + '&useStoredSettings=true';
                    JIRA.Projects.Sidebar.Reports.storeLastViewedReportLink(url);
                }
            });
        }
    };

    return contextProvider;
});

AJS.namespace('GH.RapidBoard.ReportSubnavigatorContextProvider', null, require('jira-agile/subnavigator/report-subnavigator-context-provider'));