AJS.namespace('GH.RapidBoard.SubnavigatorController');

GH.RapidBoard.SubnavigatorController = (function(
    PlanSubnavigatorContextProvider,
    WorkSubnavigatorContextProvider,
    ReportSubnavigatorContextProvider,
    Template,
    State,
    $,
    FeatureFlagManager
) {
    var controller = {
        contextProviders: {
            plan: PlanSubnavigatorContextProvider,
            work: WorkSubnavigatorContextProvider,
            report: ReportSubnavigatorContextProvider
        },

        render: function() {
            this._getContextProvider().onLoad();

            this.setHeader();
            this.renderSubnavigator();
        },

        //Set the header on the subnavigator. If a selector exists, this is the text to the left
        //of the selector.
        setHeader: function() {
            // Remove whatever was inside the header before and add the subnavigator header
            $('#ghx-view-selector').children().remove();

            $('#ghx-view-selector').html(Template.header({
                headerText: this._getContextProvider().header()
            }));
            this.renderSprintGoal();
        },
        renderSprintGoal: function() {
            var mode =State.getMode();
            if(!(mode === 'work') || !FeatureFlagManager.isFeatureEnabled("com.atlassian.jira.agile.darkfeature.sprint.goal")){ // Only render sprint goal inside header in work mode.
                return;
            }
            //Remove old sprint goal if present
            $('#ghx-view-selector #ghx-sprint-goal').remove();

            $('#ghx-view-selector').append(Template.sprintgoal({
                sprintGoal: this._getContextProvider().getSprintGoal()
            }));

            $('#ghx-view-selector #ghx-sprint-goal') .tooltip({className: 'ghx-sprint-goal-tooltip'});
        },

        renderSubnavigator: function() {
            var contextProvider = this._getContextProvider();
            if(!contextProvider.hasSubnavigator()) {
                return;
            }

            this.createSubnavigatorPlaceholders();
            var Subnavigator = JIRA.Projects.Subnavigator;
            var subnavSetting = this._getSubnavSettings(Subnavigator, contextProvider);
            var subnavigator = new Subnavigator(subnavSetting);

            subnavigator.on('itemSelected', function(e) {
                e.preventDefault();
                contextProvider.selectionHandler(e.item.id);
                controller.renderSprintGoal();
                AJS.trigger('analyticsEvent', contextProvider.analyticEvent(e.item.id, false));
            });

            subnavigator.show();
            AJS.trigger('analyticsEvent', contextProvider.analyticEvent(contextProvider.selectedItem(), true));
        },

        createSubnavigatorPlaceholders: function() {
            $('#ghx-view-selector h1').append(Template.subnavigator());
        },

        _getContextProvider: function() {
            var mode =State.getMode();
            return this.contextProviders[mode];
        },

        /**
         * Interrogate the version of JIRA.Projects.Subnavigator, and return appropriate settings.
         *   3.0.9  Included a bug when rendering empty option lists
         *   3.0.12 Includes a fix and a new private method `_shouldShowTriggerView()`
         *
         * @param JIRA.Projects.Subnavigator
         * @param contextProvider
         * @returns subnavigatorSettings
         * @private
         */
        _getSubnavSettings: function(Subnavigator, contextProvider) {
            var subnavSettings = {
                id: State.getMode(),
                triggerPlaceholder: '#subnav-trigger',
                contentPlaceholder: '#subnav-opts',
                itemGroups: contextProvider.itemList(),
                selectedItem: contextProvider.selectedItem()
            };

            var isNewSubnav = Subnavigator.prototype._shouldShowTriggerView !== undefined;
            // Passing titlePlaceholder, hideSelectedItem, changeViewText will construct the new Subnavigator
            if (isNewSubnav) {
                subnavSettings.titlePlaceholder = '#subnav-title';
                subnavSettings.hideSelectedItem = true;
                subnavSettings.changeViewText = contextProvider.getChangeViewText();
            }

            return subnavSettings;
        }

    };

    return controller;
}(
    GH.RapidBoard.PlanSubnavigatorContextProvider,
    GH.RapidBoard.WorkSubnavigatorContextProvider,
    GH.RapidBoard.ReportSubnavigatorContextProvider,
    GH.tpl.subnavigator,
    GH.RapidBoard.State,
    require('jquery'),
    require('jira/featureflags/feature-manager')
));
