AJS.test.require(["com.pyxis.greenhopper.jira:gh-rapid", "com.pyxis.greenhopper.jira:gh-test-common"], function () {
    module("AJS version tests");

    test("it should return -1.0.0 when AJS.version is not defined", function () {

        AJS.version = undefined;

        var ajsVersion = GH.ajsVersion();

        equal(ajsVersion.major, -1);
        equal(ajsVersion.minor, 0);
        equal(ajsVersion.milestone, 0);
    });

    test("it should return the major, minor and milestone versions", function () {

        AJS.version = "1.2.3";

        var ajsVersion = GH.ajsVersion();

        equal(ajsVersion.major, 1);
        equal(ajsVersion.minor, 2);
        equal(ajsVersion.milestone, 3);
    });

    test("it should return the major, minor and milestone versions", function () {

        AJS.version = "2.4-m6";

        var ajsVersion = GH.ajsVersion();

        equal(ajsVersion.major, 2);
        equal(ajsVersion.minor, 4);
        equal(ajsVersion.milestone, 6);
    });
});