var GH = GH || {};

var _ = require('underscore');

GH.IssueTest = {};

GH.IssueTest.nextId = 9999;

GH.IssueTest.generateId = function() {
    GH.IssueTest.nextId += 1;
    return GH.IssueTest.nextId;
};

GH.IssueTest.createIssueObjectWithEstimate = function(estimate, options) {
    var estimateStatistic = {
        statFieldValue: {
            value: estimate
        }
    };
    if (options) {
        return GH.IssueTest.createIssueObject(_.defaults(options, {estimateStatistic: estimateStatistic}));
    }
    return GH.IssueTest.createIssueObject({estimateStatistic: estimateStatistic});
};

GH.IssueTest.createIssueObjectWithKey = function(issueKey) {
    return GH.IssueTest.createIssueObject({key: issueKey});
};

GH.IssueTest.createIssueObject = function(options) {
    var id = GH.IssueTest.generateId();
    var defaultIssue = {
        "id":id,
        "key": "GH-" + id,
        "hidden":false,
        "typeName":"Bug",
        "typeId":"1",
        "summary":"testing is awesome",
        "typeUrl":"http://cerberus:2990/jira/images/icons/bug.gif",
        "priorityUrl":"http://cerberus:2990/jira/images/icons/priority_major.gif",
        "priorityName":"Major",
        "done":false,
        "assignee":"admin",
        "assigneeName":"admin",
        "avatarUrl":"http://cerberus:2990/jira/secure/useravatar?avatarId=10122",
        "statusId":"1",
        "statusName":"Open",
        "statusUrl":"http://cerberus:2990/jira/images/icons/status_open.gif",
        "timeInColumn":0
    };
    if (!options) {
        return defaultIssue;
    }
    return _.defaults(options, defaultIssue);
};

GH.IssueTest.createArrayOfIssues = function(countOfIssues) {
    var issues = [];
    for(var i=0;i<countOfIssues;i++) {
        issues.push(GH.IssueTest.createIssueObject());
    }
    return issues;
};

GH.IssueTest.issueObjectsFromKeys = function(issueKeys) {
    return _.map(issueKeys, function(key) {
        return GH.IssueTest.createIssueObject({key: key});
    });
};

GH.IssueTest.issueObjects = function(issueKeysOrObjects) {
    return _.map(issueKeysOrObjects, function(keyOrObject) {
        if (_.isString(keyOrObject)) {
            return GH.IssueTest.createIssueObject({key: keyOrObject});
        } else {
            return GH.IssueTest.createIssueObject(keyOrObject);
        }
    });
};


GH.MarkerTest = {};

GH.MarkerTest.createMarkerObject = function(markerId) {
    return {
        id: markerId,
        name: 'test-marker'
    };
};


GH.Test = {};
GH.Test.Builders = {};

// when init is called multiple times within a set of tests events do not always work correctly
// ensure all events are cleared by calling this method
GH.Test.selectorForInlineEditTrigger = ".js-sprint-container .js-edit-sprintName-trigger";
GH.Test.selectorForCreateSprint = ".js-add-sprint";

GH.Test.clearEvents = function() {
    AJS.$(document).undelegate(GH.Test.selectorForInlineEditTrigger, "click");
    AJS.$(document).undelegate(GH.Test.selectorForCreateSprint, "click");
};


// In JIRA 5.0, test failures result from the version not being set correctly

if (!AJS.params) {
    AJS.params = {};
}
if (!AJS.params.JiraVersion) {
    AJS.params.JiraVersion = "5.0";
}

GH.Test.setUpFakeServer = function(context) {
    context.server = sinon.fakeServer.create();
    context.clock = sinon.useFakeTimers(new Date().getTime()); // use now
    GH.Ajax.xhrRegistery = {};
    context.oldStallTimeout = GH.Ajax.stallTimeout;
    GH.Ajax.stallTimeout = -1;
};

GH.Test.restoreServer = function(context) {
    context.server.requests = [];
    context.server.queue = [];
    context.server.responses = [];
    context.server.restore();
    context.clock.restore();
    GH.Ajax.stallTimeout = context.oldStallTimeout;
};

// Errors that occur during the ajax callbacks are not logged to the test output
// Simply for visibility: override the default error logging and spit out the error
sinon.oldLogErr = sinon.logError;
sinon.logError = function (label, err) {
    console.log("Error occurred during Ajax callbacks");
    console.log(err.stack);
    sinon.oldLogErr(label, err);
};

GH.Test.respondToGetWith200 = function(context, url, data) {
    GH.Test.respondWith(context, url, data, "GET", 200);
};

GH.Test.respondToGetWith500 = function(context, url, data) {
    GH.Test.respondWith(context, url, data, "GET", 500);
};

GH.Test.respondToPostWith200 = function(context, url, data) {
    GH.Test.respondWith(context, url, data, "POST", 200);
};

GH.Test.respondToPostWith500 = function(context, url, data) {
    GH.Test.respondWith(context, url, data, "POST", 500);
};

GH.Test.respondToDeleteWith200 = function(context, url, data) {
    GH.Test.respondWith(context, url, data, "DELETE", 200);
};

GH.Test.respondToDeleteWith500 = function(context, url, data) {
    GH.Test.respondWith(context, url, data, "DELETE", 500);
};

GH.Test.respondToPutWith200 = function(context, url, data) {
    GH.Test.respondWith(context, url, data, "PUT", 200);
};

GH.Test.respondToPutWith500 = function(context, url, data) {
    GH.Test.respondWith(context, url, data, "PUT", 500);
};

GH.Test.respondWith = function(context, url, data, method, httpStatus) {
    var rest_url = new RegExp("^" + GH.Ajax.buildRestUrl(url) + "(.*)");
    context.server.respondWith(method, rest_url, [httpStatus, { "Content-Type": "application/json" }, JSON.stringify(data)]);
};

GH.Test.respondToBareUrlGetWith200 = function(context, url, data, method, httpStatus) {
    GH.Test.respondToBareUrlWith(context, url, data, "GET", 200);
};

GH.Test.respondToBareUrlGetWith500 = function(context, url, data, method, httpStatus) {
    GH.Test.respondToBareUrlWith(context, url, data, "GET", 500);
};

GH.Test.respondToBareUrlWith = function(context, url, data, method, httpStatus) {
    var bare_url = new RegExp("^" + GH.Ajax.buildBareRestUrl(url) + "(.*)");
    context.server.respondWith(method, bare_url, [httpStatus, { "Content-Type": "application/json" }, JSON.stringify(data)]);
};

GH.Test.isRequestDataStringified = function(request, ignoreNull) {
    if (!ignoreNull && request.requestBody == null) {
        return false;
    }
    try {
        JSON.parse(request.requestBody);
        return true;
    } catch (e) {
        // if we couldn't read it, assume it wasn't stringified
        return false;
    }
};

GH.Test.requestDataContains = function(request, param, expectedValue) {
    if (request.requestBody == null) {
        return false;
    }
    var requestData = JSON.parse(request.requestBody);
    var actualValue = requestData[param];

    if (_.isArray(actualValue)) {
        return _.contains(actualValue, expectedValue);
    } else {
        return actualValue == expectedValue;
    }
};

// this is part of the data that is usually set when the WorkController is loaded
// The call is made to /xboard/work/allData.json (see GH.WorkDataLoader.load)
// The order data is then set within GH.GridDataController.setData
// here we just stub the part that we need to test the keyboard shortcut code
GH.Test.setBoardToBeRankable = function(rankable) {
    GH.RankingModel.setOrderData({
        rankable: rankable,
        canRankPerProject: [ { projectKey: "ISS", canRank: rankable }],
        rankCustomFieldId: undefined
    });
};

GH.FakeEvent = {
    preventDefault: function() {}
};

GH.Test.EventTester = function(eventName) {
    var eventFired = false;
    var eventData;

    AJS.$(GH).bind(eventName, function(e, data) {
        eventFired = true;
        eventData = data;
    });

    this.eventWasFired = function() {
        return eventFired;
    };

    this.getEventData = function() {
        return eventData;
    };
};
