AJS.test.require(['com.pyxis.greenhopper.jira:gh-test-common', "com.pyxis.greenhopper.jira:gh-rapid-common"], function () {
    var $ = require('jquery');
    var UI = require('jira-agile/ui-utils');

    test("knows when an element is disabled", function () {
        QUnit.GhFixtures.addFixture("<input type='button' class='disabled' id='test-button'>");
        ok(UI.isDisabled($("#test-button")));
        ok(!UI.isEnabled($("#test-button")));
    });

    test("knows when an element is not disabled", function () {
        QUnit.GhFixtures.addFixture("<input type='button' id='test-button'>");
        ok(!UI.isDisabled($("#test-button")));
        ok(UI.isEnabled($("#test-button")));
    });

    test("ensures the element is a jquery object before checking if it's disabled", function () {
        QUnit.GhFixtures.addFixture("<input type='button' id='test-button'>");
        ok(!UI.isDisabled("#test-button"));
        ok(UI.isEnabled("#test-button"));
    });
});