/* global WRM */
/* global AJS */
define('jira-agile/onboarding/first-use-flow', [
    'jira/onboarding/choose-language-sequence',
    'jira/onboarding/avatar-picker-sequence',
    'jira/onboarding/nutshell-sequence',
    'jira-agile/onboarding/create-project-sequence',
    'jira/onboarding/next-step-sequence'
], function (
    ChooseLanguageSequence,
    AvatarPickerSequence,
    NutshellSequence,
    CreateProjectSequence,
    NextStepSequence
) {
    'use strict';

    function getNutshellData() {
        var nutshellData = WRM.data.claim('com.atlassian.jira.jira-onboarding-assets-plugin:nutshell-sequence.data');
        var dataHasSoftwareProjectTypeAvatar = !!(nutshellData.projectType && nutshellData.projectTypeAvatars && nutshellData.projectTypeAvatars.software);
        if (dataHasSoftwareProjectTypeAvatar) {
            nutshellData.projectType = 'software';
        }
        return nutshellData;
    }

    /**
     * @name FirstUseFlowFactory
     *
     * @param {Function} complete function to tell the server that the flow is complete.
     * @return {FirstUseFlow}
     */
    return function(complete) {
        var languageData = WRM.data.claim('com.atlassian.jira.jira-onboarding-assets-plugin:choose-language-sequence.data');
        var avatarData = WRM.data.claim('com.atlassian.jira.jira-onboarding-assets-plugin:avatar-picker-sequence.data');
        var nutshellData = getNutshellData();
        var createProjectData = WRM.data.claim('com.pyxis.greenhopper.jira:onboarding-create-project-sequence.data');
        var nextStepData =  WRM.data.claim('com.atlassian.jira.jira-onboarding-assets-plugin:next-step-sequence.data');


        function goToDashboard() {
            performRedirect(AJS.contextPath() + '/secure/Dashboard.jspa');
        }

        function performRedirect(url) {
            window.location.href = url;
        }


        //Note: If the key or sequence keys are changed the analytics-whitelist.json file must be updated.
        return {
            key: 'agileFirstUseFlow',
            start: 'chooseLanguage',
            sequences: {
                'chooseLanguage': {
                    instance: new ChooseLanguageSequence(languageData),
                    resolve: 'avatar',
                    reject: 'avatar'
                },
                'avatar': {
                    instance: new AvatarPickerSequence(avatarData),
                    resolve: 'nutshell',
                    reject: 'nutshell'
                },
                'nutshell': {
                    instance: new NutshellSequence(nutshellData),
                    resolve: 'createProject',
                    reject: 'createProject'
                },
                'createProject': {
                    instance: new CreateProjectSequence(createProjectData),
                    resolve: function(response) {
                        function resolveCreateProject() {
                            performRedirect(AJS.contextPath() + response.returnUrl);
                        }

                        complete().then(resolveCreateProject, resolveCreateProject);
                    },

                    reject: "nextStep"
                },
                'nextStep': {
                    instance: new NextStepSequence(nextStepData),
                    resolve: complete,
                    reject: function () {
                        // if no permissions for the next step
                        complete().then(goToDashboard, goToDashboard);
                    }
                }
            }
        };
    };
});
