AJS.test.require('com.pyxis.greenhopper.jira:agile-first-use-flow-js', function() {

    var ChooseLanguageSequence = sinon.spy();
    var AvatarPickerSequence = sinon.spy();
    var NutshellSequence = sinon.spy();
    var CreateProjectSequence = sinon.spy();
    var WrmDataClaim = sinon.stub(WRM.data, 'claim');

    var RESOURCE_NUTSHELL_SEQUENCE_DATA = 'com.atlassian.jira.jira-onboarding-assets-plugin:nutshell-sequence.data';

    var firstUseFlow;
    try {
        this.context = AJS.test.mockableModuleContext();
        this.context.mock('jira/onboarding/choose-language-sequence', ChooseLanguageSequence);
        this.context.mock('jira/onboarding/avatar-picker-sequence', AvatarPickerSequence);
        this.context.mock('jira/onboarding/nutshell-sequence', NutshellSequence);
        this.context.mock('jira-agile/onboarding/create-project-sequence', CreateProjectSequence);
        firstUseFlow = this.context.require('jira-agile/onboarding/first-use-flow');
    } catch (e) {
        AJS.log('Was not able to load the resource, likely testing on an old version of JIRA');
    }

    module('First Use Flow tests', {
        setup: function() {
        },
        teardown: function () {
            if (firstUseFlow) {
                ChooseLanguageSequence.reset();
                AvatarPickerSequence.reset();
                NutshellSequence.reset();
                CreateProjectSequence.reset();
            }
        }
    });

    function assertNutshellSequenceDataCalledWith(mockNutshellData, expectedData, msg) {
        WrmDataClaim.withArgs(RESOURCE_NUTSHELL_SEQUENCE_DATA).returns(mockNutshellData);

        firstUseFlow();

        ok(NutshellSequence.calledWithMatch(sinon.match(expectedData)), msg);
    }

    function assertNutshellSequenceDataNeverCalledWith(mockNutshellData, unexpectedData, msg) {
        WrmDataClaim.withArgs(RESOURCE_NUTSHELL_SEQUENCE_DATA).returns(mockNutshellData);

        firstUseFlow();

        ok(NutshellSequence.neverCalledWithMatch(sinon.match(unexpectedData)), msg);
    }

    //As these qunit tests cannot be put in dynamic module it must be included in all versions of JIRA, therefore,
    //It will try and run it in versions of JIRA which are not possible. If it does, do not fail these tests.
    if (!firstUseFlow) {
        test('Make sure there is at least one test for JIRA versions < 6.4', sinon.test(function () {
            ok(true);
        }));
    } else {
        test('sending the right project type to JIRA\'s NutshellSequence', function () {
            var msg = "expected projectType to be set to 'software' in NutshellData";
            var mockNutshellData =  {
                projectType: "business",
                projectTypeAvatars: {
                    business: "foo",
                    software: "bah"
                }
            };
            var expectedData = {
                projectType: "software",
                projectTypeAvatars: mockNutshellData.projectTypeAvatars
            };
            assertNutshellSequenceDataCalledWith(mockNutshellData, expectedData, msg);
        });

        test('sending no project type to JIRA\'s NutshellSequence if no software project type avatar', function () {
            var msg = "expected no extra properties in NutshellData";
            var mockNutshellData =  {
                projectType: "business",
                projectTypeAvatars: {
                    business: "foo"
                    // no software
                }
            };
            var expectedData = mockNutshellData;
            assertNutshellSequenceDataCalledWith(mockNutshellData, expectedData, msg);
        });

        test('sending no project type to JIRA\'s NutshellSequence if hidden by dark feature', function () {
            var msg = "expected no extra properties in NutshellData";
            var mockNutshellData =  {};
            var unexpectedData = {
                projectType: "software"
            };
            assertNutshellSequenceDataNeverCalledWith(mockNutshellData, unexpectedData, msg);
        });
    }
});
