/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.testkit.beans.Resolution;
import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import java.util.List;

public class ResolutionControl
extends BackdoorControl<ResolutionControl> {
    private static final GenericType<List<Resolution>> LIST_GENERIC_TYPE = new GenericType<List<Resolution>>(){};

    public ResolutionControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public Resolution createResolution(String name, String description) {
        Resolution resolution = new Resolution();
        resolution.setName(name);
        resolution.setDescription(description);
        return (Resolution)this.createResolutionResource().post(Resolution.class, (Object)resolution);
    }

    public Resolution updateResolution(long id, String name, String description) {
        Resolution resolution = new Resolution();
        resolution.setId(String.valueOf(id));
        resolution.setName(name);
        resolution.setDescription(description);
        return (Resolution)this.createResolutionResource().put(Resolution.class, (Object)resolution);
    }

    public List<Resolution> getResolutions() {
        return (List)this.createResolutionResource().get(LIST_GENERIC_TYPE);
    }

    public void deleteResolution(long id) {
        this.createResolutionResource().path(String.valueOf(id)).delete();
    }

    public void setDefaultResolution(long id) {
        this.createResolutionResource().path(String.valueOf(id)).path("default").post();
    }

    public void moveResolutionUp(long id) {
        this.createResolutionResource().path(String.valueOf(id)).path("up").post();
    }

    public void moveResolutionDown(long id) {
        this.createResolutionResource().path(String.valueOf(id)).path("down").post();
    }

    private WebResource createResolutionResource() {
        return this.createResource().path("resolution");
    }
}

