/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client;

import com.atlassian.jira.testkit.beans.Status;
import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import java.util.List;

public class StatusControl
extends BackdoorControl<StatusControl> {
    private static final String DEFAULT_ICON = "/images/icons/statuses/generic.png";
    private static final GenericType<List<Status>> LIST_GENERIC_TYPE = new GenericType<List<Status>>(){};

    public StatusControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public Status createStatus(String name) {
        return this.createStatus(name, "");
    }

    public Status createStatus(String name, String description) {
        Status status = new Status();
        status.setName(name);
        status.setDescription(description);
        status.setIconUrl(DEFAULT_ICON);
        return (Status)this.createStatusResource().post(Status.class, (Object)status);
    }

    public void editStatus(String id, String name, String description, String iconUrl) {
        Status status = new Status();
        status.setId(id);
        status.setName(name);
        status.setDescription(description);
        if (iconUrl == null) {
            status.setIconUrl(DEFAULT_ICON);
        } else {
            status.setIconUrl(iconUrl);
        }
        this.createStatusResource().put((Object)status);
    }

    public List<Status> getStatuses() {
        return (List)this.createStatusResource().get(LIST_GENERIC_TYPE);
    }

    public void deleteStatus(long id) {
        this.createStatusResource().path(String.valueOf(id)).delete();
    }

    private WebResource createStatusResource() {
        return this.createResource().path("status");
    }
}

