/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.fugue.Option;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.EntityProperty;
import com.atlassian.jira.testkit.client.restclient.EntityPropertyKeys;
import com.atlassian.jira.util.json.JSONObject;
import com.sun.jersey.api.client.WebResource;

public class EntityPropertyClient
extends RestApiClient<EntityPropertyClient> {
    private final String propertyName;

    public EntityPropertyClient(JIRAEnvironmentData environmentData, String propertyName) {
        super(environmentData);
        this.propertyName = propertyName;
    }

    public EntityPropertyKeys getKeys(String entityKeyOrId) {
        return (EntityPropertyKeys)this.resource(entityKeyOrId).get(EntityPropertyKeys.class);
    }

    public EntityProperty get(String entitykeyOrId, String propertyKey) {
        return (EntityProperty)this.resource(entitykeyOrId, propertyKey).get(EntityProperty.class);
    }

    public void put(String entityKeyOrId, String propertyKey, JSONObject value) {
        this.resource(entityKeyOrId, propertyKey).header("Content-Type", (Object)"application/json").put(String.class, (Object)value.toString());
    }

    public void delete(String entityKeyOrId, String propertyKey) {
        this.resource(entityKeyOrId, propertyKey).delete();
    }

    public WebResource resource(String entityKeyOrId) {
        return this.resource((Option<String>)Option.some((Object)entityKeyOrId), (Option<String>)Option.none());
    }

    public WebResource resource(String entityKeyOrId, String propertyKey) {
        return this.resource((Option<String>)Option.some((Object)entityKeyOrId), (Option<String>)Option.some((Object)propertyKey));
    }

    private WebResource resource(Option<String> entityKeyOrId, Option<String> propertyKey) {
        WebResource webResource = this.createResource().path(this.propertyName).path((String)entityKeyOrId.getOrElse((Object)"")).path("properties");
        return webResource.path((String)propertyKey.getOrElse((Object)""));
    }
}

