/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.rest.api.issue.JsonTypeBean;
import com.atlassian.jira.testkit.client.restclient.Attachment;
import com.atlassian.jira.testkit.client.restclient.AttachmentRendered;
import com.atlassian.jira.testkit.client.restclient.ChangeLog;
import com.atlassian.jira.testkit.client.restclient.Comment;
import com.atlassian.jira.testkit.client.restclient.CommentsWithPaginationBean;
import com.atlassian.jira.testkit.client.restclient.Component;
import com.atlassian.jira.testkit.client.restclient.Editmeta;
import com.atlassian.jira.testkit.client.restclient.IssueLink;
import com.atlassian.jira.testkit.client.restclient.IssueSecurityType;
import com.atlassian.jira.testkit.client.restclient.IssueTransitionsMeta;
import com.atlassian.jira.testkit.client.restclient.IssueType;
import com.atlassian.jira.testkit.client.restclient.Opsbar;
import com.atlassian.jira.testkit.client.restclient.Priority;
import com.atlassian.jira.testkit.client.restclient.Progress;
import com.atlassian.jira.testkit.client.restclient.Project;
import com.atlassian.jira.testkit.client.restclient.Resolution;
import com.atlassian.jira.testkit.client.restclient.Status;
import com.atlassian.jira.testkit.client.restclient.TimeTracking;
import com.atlassian.jira.testkit.client.restclient.User;
import com.atlassian.jira.testkit.client.restclient.Version;
import com.atlassian.jira.testkit.client.restclient.Vote;
import com.atlassian.jira.testkit.client.restclient.Watches;
import com.atlassian.jira.testkit.client.restclient.WorklogWithPaginationBean;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.lang.mutable.MutableInt;
import org.codehaus.jackson.annotate.JsonAnySetter;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.springframework.util.ReflectionUtils;

public class Issue {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    public String self;
    public String id;
    public String key;
    public Fields fields;
    public RenderedFields renderedFields;
    public String expand;
    public List<IssueTransitionsMeta.Transition> transitions;
    public Opsbar operations;
    public Map<String, String> names;
    public Map<String, JsonTypeBean> schema;
    public Editmeta editmeta;
    public ChangeLog changelog;

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public List<Comment> getComments() {
        return this.fields.comment.getComments();
    }

    static class AddFieldNamesTo
    implements ReflectionUtils.FieldCallback {
        private final Set<String> fieldIds;

        public AddFieldNamesTo(Set<String> fieldIds) {
            this.fieldIds = fieldIds;
        }

        public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
            JsonProperty jsonProperty = field.getAnnotation(JsonProperty.class);
            if (jsonProperty != null && !"".equals(jsonProperty.value())) {
                this.fieldIds.add(jsonProperty.value());
            } else {
                this.fieldIds.add(field.getName());
            }
        }
    }

    static class CountFieldsCallback
    implements ReflectionUtils.FieldCallback {
        private final MutableInt counter;

        public CountFieldsCallback(MutableInt counter) {
            this.counter = counter;
        }

        public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
            this.counter.increment();
        }
    }

    public static enum Expand {
        renderedFields,
        names,
        schema,
        editmeta,
        transitions,
        operations,
        changelog;

    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RenderedFields {
        public String description;
        public String environment;
        public String updated;
        public String created;
        public String resolutiondate;
        public String duedate;
        public CommentsWithPaginationBean comment;
        public WorklogWithPaginationBean worklog;
        public TimeTracking timetracking;
        public Collection<AttachmentRendered> attachment;
        private Map<String, Object> customFields;

        public int length() {
            int len = 0;
            for (Field field : RenderedFields.class.getFields()) {
                try {
                    if (field.get(this) == null) continue;
                    ++len;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            return len;
        }

        @JsonAnySetter
        public void addCustomField(String key, Object value) {
            if (this.customFields == null) {
                this.customFields = Maps.newHashMap();
            }
            this.customFields.put(key, value);
        }

        public <T> T getCustomField(String fieldID) throws IllegalArgumentException {
            if (this.customFields != null && this.customFields.containsKey(fieldID)) {
                return (T)this.customFields.get(fieldID);
            }
            return null;
        }

        public boolean equals(Object o) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Fields {
        public List<Attachment> attachment;
        public CommentsWithPaginationBean comment;
        public String description;
        public String environment;
        public String summary;
        public Vote votes;
        public IssueSecurityType security;
        public String resolutiondate;
        public String updated;
        public String created;
        public String duedate;
        public TimeTracking timetracking;
        public List<String> labels;
        public IssueType issuetype;
        public List<Version> fixVersions;
        public List<Version> versions;
        public List<Component> components;
        public Progress progress;
        public Progress aggregateprogress;
        public Priority priority;
        public Project project;
        public Resolution resolution;
        public User assignee;
        public User reporter;
        public Status status;
        public WorklogWithPaginationBean worklog;
        public Long workratio;
        public List<IssueLink> issuelinks;
        public Watches watches;
        public List<IssueLink.IssueLinkRef> subtasks;
        public IssueLink.IssueLinkRef parent;
        private Map<String, Object> customFields;

        @JsonAnySetter
        public void addCustomField(String key, Object value) {
            if (this.customFields == null) {
                this.customFields = Maps.newHashMap();
            }
            this.customFields.put(key, value);
        }

        public <T> T get(String fieldID) throws IllegalArgumentException {
            if (this.customFields != null && this.customFields.containsKey(fieldID)) {
                return (T)this.customFields.get(fieldID);
            }
            return this.reflectiveGet(fieldID);
        }

        public <T> T get(String fieldID, Class<T> cls) throws IllegalArgumentException {
            return (T)new ObjectMapper().convertValue(this.get(fieldID), cls);
        }

        public <T> T get(String fieldID, TypeReference<T> type) throws IllegalArgumentException {
            return (T)MAPPER.convertValue(this.get(fieldID), type);
        }

        public boolean has(String fieldID) {
            boolean hasCustomField;
            boolean bl = hasCustomField = this.customFields != null && this.customFields.containsKey(fieldID);
            if (!hasCustomField) {
                return this.getPublicField(fieldID) != null;
            }
            return hasCustomField;
        }

        public Set<String> idSet() {
            HashSet fieldIds = Sets.newHashSet();
            ReflectionUtils.doWithFields(Fields.class, (ReflectionUtils.FieldCallback)new AddFieldNamesTo(fieldIds), (ReflectionUtils.FieldFilter)new JsonPropertyFilter());
            if (this.customFields != null) {
                fieldIds.addAll(this.customFields.keySet());
            }
            return fieldIds;
        }

        public int size() {
            MutableInt systemFieldCount = new MutableInt();
            ReflectionUtils.doWithFields(Fields.class, (ReflectionUtils.FieldCallback)new CountFieldsCallback(systemFieldCount), (ReflectionUtils.FieldFilter)new JsonPropertyFilter());
            return systemFieldCount.intValue() + (this.customFields != null ? this.customFields.size() : 0);
        }

        public boolean equals(Object o) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this);
        }

        private <T> T reflectiveGet(String fieldID) {
            Field f = this.getPublicField(fieldID);
            if (f != null) {
                try {
                    return (T)f.get(this);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Couldn't get field value", e);
                }
            }
            throw new IllegalStateException("Field does not exist: " + fieldID);
        }

        private Field getPublicField(String fieldID) {
            Field field = null;
            try {
                field = Fields.class.getDeclaredField(fieldID);
                if (Modifier.isPublic(field.getModifiers())) {
                    return field;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            AtomicReference<Field> fRef = new AtomicReference<Field>();
            ReflectionUtils.doWithFields(Fields.class, (ReflectionUtils.FieldCallback)new ExtractFieldById(fieldID, fRef), (ReflectionUtils.FieldFilter)new JsonPropertyFilter());
            if (fRef.get() != null && Modifier.isPublic((field = fRef.get()).getModifiers())) {
                return field;
            }
            return null;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }

        class JsonPropertyFilter
        implements ReflectionUtils.FieldFilter {
            JsonPropertyFilter() {
            }

            public boolean matches(Field field) {
                return (field.getModifiers() & 1) != 0;
            }
        }

        private static class ExtractFieldById
        implements ReflectionUtils.FieldCallback {
            private final String fieldID;
            private final AtomicReference<Field> f;

            public ExtractFieldById(String fieldID, AtomicReference<Field> f) {
                this.fieldID = fieldID;
                this.f = f;
            }

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                JsonProperty jsonProperty = field.getAnnotation(JsonProperty.class);
                if (jsonProperty != null && this.fieldID.equals(jsonProperty.value())) {
                    this.f.set(field);
                }
            }
        }
    }
}

