/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.client.restclient;

import com.atlassian.jira.testkit.client.restclient.IssueType;
import com.atlassian.jira.testkit.client.restclient.Priority;
import com.atlassian.jira.testkit.client.restclient.Status;
import java.net.URI;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.codehaus.jackson.annotate.JsonProperty;

public class IssueLink {
    @JsonProperty
    private String id;
    @JsonProperty
    private URI self;
    @JsonProperty
    private Type type;
    @JsonProperty
    private IssueLinkRef inwardIssue;
    @JsonProperty
    private IssueLinkRef outwardIssue;

    public IssueLink() {
    }

    public IssueLink(Type type, IssueLinkRef inwardIssue, IssueLinkRef outwardIssue) {
        this.type = type;
        this.inwardIssue = inwardIssue;
        this.outwardIssue = outwardIssue;
    }

    public Type type() {
        return this.type;
    }

    public IssueLink type(Type type) {
        return new IssueLink(type, this.inwardIssue, this.outwardIssue);
    }

    public IssueLinkRef inwardIssue() {
        return this.inwardIssue;
    }

    public IssueLink inwardIssue(IssueLinkRef inwardIssue) {
        return new IssueLink(this.type, inwardIssue, this.outwardIssue);
    }

    public IssueLinkRef outwardIssue() {
        return this.outwardIssue;
    }

    public String id() {
        return this.id;
    }

    public URI self() {
        return this.self;
    }

    public IssueLink outwardIssue(IssueLinkRef outwardIssue) {
        return new IssueLink(this.type, this.inwardIssue, outwardIssue);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static class IssueLinkRef {
        @JsonProperty
        private String id;
        @JsonProperty
        private String key;
        @JsonProperty
        private String self;
        @JsonProperty
        private Fields fields;

        public IssueLinkRef() {
        }

        public IssueLinkRef(String id, String key, String self, Fields fields) {
            this.id = id;
            this.key = key;
            this.self = self;
            this.fields = fields;
        }

        public String id() {
            return this.id;
        }

        public IssueLinkRef id(String id) {
            return new IssueLinkRef(id, this.key, this.self, this.fields);
        }

        public String key() {
            return this.key;
        }

        public IssueLinkRef key(String key) {
            return new IssueLinkRef(this.id, key, this.self, this.fields);
        }

        public String self() {
            return this.self;
        }

        public IssueLinkRef self(String self) {
            return new IssueLinkRef(this.id, this.key, self, this.fields);
        }

        public Fields fields() {
            return this.fields;
        }

        public IssueLinkRef fields(Fields fields) {
            return new IssueLinkRef(this.id, this.key, this.self, fields);
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }

        public static class Fields {
            @JsonProperty
            private String summary;
            @JsonProperty
            private Status status;
            @JsonProperty(value="issuetype")
            private IssueType issueType;
            @JsonProperty
            private Priority priority;

            public Fields() {
            }

            public Fields(String summary, Status status, IssueType issueType, Priority priority) {
                this.summary = summary;
                this.status = status;
                this.issueType = issueType;
                this.priority = priority;
            }

            public String summary() {
                return this.summary;
            }

            public Fields summary(String summary) {
                return new Fields(summary, this.status, this.issueType, this.priority);
            }

            public Status status() {
                return this.status;
            }

            public Fields status(Status status) {
                return new Fields(this.summary, status, this.issueType, this.priority);
            }

            public IssueType issueType() {
                return this.issueType;
            }

            public Fields issueType(IssueType issueType) {
                return new Fields(this.summary, this.status, issueType, this.priority);
            }

            public Priority priority() {
                return this.priority;
            }

            public Fields priority(Priority priority) {
                return new Fields(this.summary, this.status, this.issueType, priority);
            }

            public boolean equals(Object obj) {
                return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
            }

            public int hashCode() {
                return HashCodeBuilder.reflectionHashCode((Object)this);
            }

            public String toString() {
                return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
            }
        }
    }

    public static class Type {
        @JsonProperty
        private String id;
        @JsonProperty
        private String name;
        @JsonProperty
        private String inward;
        @JsonProperty
        private String outward;
        @JsonProperty
        private String self;

        public Type() {
        }

        public Type(String id, String name, String inward, String outward, String self) {
            this.id = id;
            this.name = name;
            this.inward = inward;
            this.outward = outward;
            this.self = self;
        }

        public String id() {
            return this.id;
        }

        public Type id(String id) {
            return new Type(id, this.name, this.inward, this.outward, this.self);
        }

        public String name() {
            return this.name;
        }

        public Type name(String name) {
            return new Type(this.id, name, this.inward, this.outward, this.self);
        }

        public String inward() {
            return this.inward;
        }

        public Type inward(String inward) {
            return new Type(this.id, this.name, inward, this.outward, this.self);
        }

        public String outward() {
            return this.outward;
        }

        public Type outward(String outward) {
            return new Type(this.id, this.name, this.inward, outward, this.self);
        }

        public String self() {
            return this.self;
        }

        public Type self(String self) {
            return new Type(this.id, this.name, this.inward, this.outward, self);
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

