/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.BannedDependencies;
import com.atlassian.maven.plugins.amps.DataSource;
import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.PdkParams;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.XmlOverride;
import com.atlassian.maven.plugins.amps.minifier.MinifierParameters;
import com.atlassian.maven.plugins.amps.minifier.ResourcesMinifier;
import com.atlassian.maven.plugins.amps.product.ImportMethod;
import com.atlassian.maven.plugins.amps.product.jira.JiraDatabase;
import com.atlassian.maven.plugins.amps.product.jira.JiraDatabaseFactory;
import com.atlassian.maven.plugins.amps.util.AmpsCreatePluginPrompter;
import com.atlassian.maven.plugins.amps.util.CreatePluginProperties;
import com.atlassian.maven.plugins.amps.util.FileUtils;
import com.atlassian.maven.plugins.amps.util.MojoUtils;
import com.atlassian.maven.plugins.amps.util.PluginXmlUtils;
import com.atlassian.maven.plugins.amps.util.ProductHandlerUtil;
import com.atlassian.maven.plugins.amps.util.VersionUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import com.googlecode.htmlcompressor.compressor.XmlCompressor;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.archetype.common.DefaultPomManager;
import org.apache.maven.archetype.common.MavenJDOMWriter;
import org.apache.maven.archetype.common.util.Format;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class MavenGoals {
    @VisibleForTesting
    static final String AJP_PORT_PROPERTY = "cargo.tomcat.ajp.port";
    static final String REGEX_INTEGRATION_TESTS = "%regex[it[/\\\\].*]";
    @VisibleForTesting
    final Map<String, String> defaultArtifactIdToVersionMap;
    private final MavenContext ctx;
    private final Map<String, Container> idToContainerMap = ImmutableMap.builder().put((Object)"tomcat5x", (Object)new Container("tomcat5x", "org.apache.tomcat", "apache-tomcat", "5.5.36")).put((Object)"tomcat6x", (Object)new Container("tomcat6x", "org.apache.tomcat", "apache-tomcat", "6.0.41")).put((Object)"tomcat7x", (Object)new Container("tomcat7x", "org.apache.tomcat", "apache-tomcat", "7.0.73-atlassian-hosted", "windows-x64")).put((Object)"tomcat8x", (Object)new Container("tomcat8x", "org.apache.tomcat", "apache-tomcat", "8.0.53-atlassian-hosted", "windows-x64")).put((Object)"tomcat85x", (Object)new Container("tomcat8x", "org.apache.tomcat", "apache-tomcat", "8.5.40-atlassian-hosted", "windows-x64")).put((Object)"tomcat85_6", (Object)new Container("tomcat8x", "org.apache.tomcat", "apache-tomcat", "8.5.6-atlassian-hosted", "windows-x64")).put((Object)"tomcat85_29", (Object)new Container("tomcat8x", "org.apache.tomcat", "apache-tomcat", "8.5.29-atlassian-hosted", "windows-x64")).put((Object)"tomcat85_32", (Object)new Container("tomcat8x", "org.apache.tomcat", "apache-tomcat", "8.5.32-atlassian-hosted", "windows-x64")).put((Object)"tomcat85_35", (Object)new Container("tomcat8x", "org.apache.tomcat", "apache-tomcat", "8.5.35-atlassian-hosted", "windows-x64")).put((Object)"tomcat9x", (Object)new Container("tomcat9x", "org.apache.tomcat", "apache-tomcat", "9.0.11-atlassian-hosted", "windows-x64")).put((Object)"jetty6x", (Object)new Container("jetty6x")).put((Object)"jetty7x", (Object)new Container("jetty7x")).put((Object)"jetty8x", (Object)new Container("jetty8x")).put((Object)"jetty9x", (Object)new Container("jetty9x")).build();
    private final Log log;

    public MavenGoals(MavenContext ctx) {
        this.ctx = ctx;
        this.defaultArtifactIdToVersionMap = Collections.unmodifiableMap(this.getArtifactIdToVersionMap(ctx));
        this.log = ctx.getLog();
    }

    private Map<String, String> getArtifactIdToVersionMap(MavenContext ctx) {
        Properties overrides = ctx.getVersionOverrides();
        return ImmutableMap.builder().put((Object)"atlassian-pdk", (Object)overrides.getProperty("atlassian-pdk", "2.3.3")).put((Object)"build-helper-maven-plugin", (Object)overrides.getProperty("build-helper-maven-plugin", "3.0.0")).put((Object)"cargo-maven2-plugin", (Object)overrides.getProperty("cargo-maven2-plugin", "1.6.10")).put((Object)"maven-archetype-plugin", (Object)overrides.getProperty("maven-archetype-plugin", "3.0.1")).put((Object)"maven-bundle-plugin", (Object)overrides.getProperty("maven-bundle-plugin", "3.5.0")).put((Object)"maven-cli-plugin", (Object)overrides.getProperty("maven-cli-plugin", "1.0.11")).put((Object)"maven-dependency-plugin", (Object)overrides.getProperty("maven-dependency-plugin", "3.1.1")).put((Object)"maven-deploy-plugin", (Object)overrides.getProperty("maven-deploy-plugin", "2.8.2")).put((Object)"maven-exec-plugin", (Object)overrides.getProperty("maven-exec-plugin", "1.2.1")).put((Object)"maven-failsafe-plugin", (Object)overrides.getProperty("maven-failsafe-plugin", "2.22.1")).put((Object)"maven-help-plugin", (Object)overrides.getProperty("maven-help-plugin", "3.2.0")).put((Object)"maven-install-plugin", (Object)overrides.getProperty("maven-install-plugin", "2.5.2")).put((Object)"maven-jar-plugin", (Object)overrides.getProperty("maven-jar-plugin", "3.0.2")).put((Object)"maven-javadoc-plugin", (Object)overrides.getProperty("maven-javadoc-plugin", "3.1.1")).put((Object)"maven-release-plugin", (Object)overrides.getProperty("maven-release-plugin", "2.5.3")).put((Object)"maven-resources-plugin", (Object)overrides.getProperty("maven-resources-plugin", "2.6")).put((Object)"maven-surefire-plugin", (Object)overrides.getProperty("maven-surefire-plugin", "2.22.1")).put((Object)"sql-maven-plugin", (Object)overrides.getProperty("sql-maven-plugin", "1.5")).put((Object)"yuicompressor-maven-plugin", (Object)overrides.getProperty("yuicompressor-maven-plugin", "1.5.1")).build();
    }

    private MojoExecutor.ExecutionEnvironment executionEnvironment() {
        return this.ctx.getExecutionEnvironment();
    }

    public MavenProject getContextProject() {
        return this.ctx.getProject();
    }

    public void executeAmpsRecursively(String ampsVersion, String ampsGoal, Xpp3Dom cfg) throws MojoExecutionException {
        MojoUtils.executeWithMergedConfig(MojoExecutor.plugin(MojoExecutor.groupId("com.atlassian.maven.plugins"), MojoExecutor.artifactId("amps-maven-plugin"), MojoExecutor.version(ampsVersion)), MojoExecutor.goal(ampsGoal), cfg, this.executionEnvironment());
    }

    public void createPlugin(String productId, AmpsCreatePluginPrompter createPrompter) throws MojoExecutionException {
        CreatePluginProperties props = null;
        Properties systemProps = System.getProperties();
        if (systemProps.containsKey("groupId") && systemProps.containsKey("artifactId") && systemProps.containsKey("version") && systemProps.containsKey("package")) {
            props = new CreatePluginProperties(systemProps.getProperty("groupId"), systemProps.getProperty("artifactId"), systemProps.getProperty("version"), systemProps.getProperty("package"), systemProps.getProperty("useOsgiJavaConfig", "N"));
        }
        if (null == props) {
            try {
                props = createPrompter.prompt();
            }
            catch (PrompterException e) {
                throw new MojoExecutionException("Unable to gather properties", (Exception)((Object)e));
            }
        }
        if (null != props) {
            MojoExecutor.ExecutionEnvironment execEnv = this.executionEnvironment();
            Properties userProperties = execEnv.getMavenSession().getUserProperties();
            userProperties.setProperty("groupId", props.getGroupId());
            userProperties.setProperty("artifactId", props.getArtifactId());
            userProperties.setProperty("version", props.getVersion());
            userProperties.setProperty("package", props.getThePackage());
            userProperties.setProperty("useOsgiJavaConfig", props.getUseOsgiJavaConfigInMavenInvocationFormat());
            MojoUtils.executeWithMergedConfig(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-archetype-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-archetype-plugin"))), MojoExecutor.goal("generate"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("archetypeGroupId"), "com.atlassian.maven.archetypes"), MojoExecutor.element(MojoExecutor.name("archetypeArtifactId"), (productId.equals("all") ? "" : productId + "-") + "plugin-archetype"), MojoExecutor.element(MojoExecutor.name("archetypeVersion"), VersionUtils.getVersion()), MojoExecutor.element(MojoExecutor.name("interactiveMode"), "false")), execEnv);
            this.correctCrlf(props.getArtifactId());
            File pluginDir = new File(this.ctx.getProject().getBasedir(), props.getArtifactId());
            if (pluginDir.exists()) {
                File src = new File(pluginDir, "src");
                File test = new File(src, "test");
                File java = new File(test, "java");
                String packagePath = props.getThePackage().replaceAll("\\.", Matcher.quoteReplacement(File.separator));
                File packageFile = new File(java, packagePath);
                File packageUT = new File(packageFile, "ut");
                File packageIT = new File(packageFile, "it");
                File ut = new File(new File(java, "ut"), packagePath);
                File it = new File(new File(java, "it"), packagePath);
                if (packageFile.exists()) {
                    try {
                        if (packageUT.exists()) {
                            org.apache.commons.io.FileUtils.copyDirectory((File)packageUT, (File)ut);
                        }
                        if (packageIT.exists()) {
                            org.apache.commons.io.FileUtils.copyDirectory((File)packageIT, (File)it);
                        }
                        IOFileFilter filter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.nameFileFilter((String)"it")), FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.nameFileFilter((String)"ut"))});
                        FileUtils.cleanDirectory(java, (FileFilter)filter);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void correctCrlf(String artifactId) {
        File outputDirectoryFile;
        if (null != this.ctx && null != this.ctx.getProject() && null != this.ctx.getProject().getBasedir() && this.ctx.getProject().getBasedir().exists() && (outputDirectoryFile = new File(this.ctx.getProject().getBasedir(), artifactId)).exists()) {
            FilenameFilter pomFilter = (dir, name) -> "pom.xml".equals(name);
            File[] pomFiles = outputDirectoryFile.listFiles(pomFilter);
            DefaultPomManager pomManager = new DefaultPomManager();
            for (File pom : pomFiles) {
                this.processCorrectCrlf(pomManager, pom);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processCorrectCrlf(DefaultPomManager pomManager, File pom) {
        block5: {
            FileInputStream inputStream = null;
            OutputStreamWriter outputStreamWriter = null;
            try {
                Model model = pomManager.readPom(pom);
                String fileEncoding = StringUtils.isEmpty((CharSequence)model.getModelEncoding()) ? model.getModelEncoding() : "UTF-8";
                inputStream = new FileInputStream(pom);
                SAXBuilder builder = new SAXBuilder();
                Document doc = builder.build((InputStream)inputStream);
                MavenJDOMWriter writer = new MavenJDOMWriter();
                outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(pom), fileEncoding);
                Format form = Format.getRawFormat().setEncoding(fileEncoding);
                form.setLineSeparator("\n");
                writer.write(model, doc, (Writer)outputStreamWriter, form);
                IOUtil.close((InputStream)inputStream);
            }
            catch (Exception e) {
                this.log.error((CharSequence)"Have exception when try correct line ending.", (Throwable)e);
                break block5;
            }
            finally {
                IOUtil.close(inputStream);
                IOUtil.close(outputStreamWriter);
            }
            IOUtil.close((Writer)outputStreamWriter);
        }
    }

    public void copyBundledDependencies() throws MojoExecutionException {
        MojoUtils.executeWithMergedConfig(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-dependency-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-dependency-plugin"))), MojoExecutor.goal("copy-dependencies"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("includeScope"), "runtime"), MojoExecutor.element(MojoExecutor.name("excludeScope"), "provided"), MojoExecutor.element(MojoExecutor.name("excludeScope"), "test"), MojoExecutor.element(MojoExecutor.name("includeTypes"), "jar"), MojoExecutor.element(MojoExecutor.name("outputDirectory"), "${project.build.outputDirectory}/META-INF/lib")), this.executionEnvironment());
    }

    void validateBannedDependencies(Set<String> banExcludes) throws MojoExecutionException {
        this.log.info((CharSequence)"validate banned dependencies");
        MojoUtils.executeWithMergedConfig(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-enforcer-plugin"), MojoExecutor.version("3.0.0-M3")), MojoExecutor.goal("enforce"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("rules"), MojoExecutor.element(MojoExecutor.name("bannedDependencies"), MojoExecutor.element(MojoExecutor.name("searchTransitive"), "true"), MojoExecutor.element(MojoExecutor.name("message"), "make sure platform artifacts are not bundled into plugin"), MojoExecutor.element(MojoExecutor.name("excludes"), (MojoExecutor.Element[])BannedDependencies.getBannedElements(banExcludes).stream().toArray(MojoExecutor.Element[]::new))))), this.executionEnvironment());
    }

    public void copyTestBundledDependencies(List<ProductArtifact> testBundleExcludes) throws MojoExecutionException {
        StringBuilder sb = new StringBuilder();
        for (ProductArtifact artifact : testBundleExcludes) {
            this.log.info((CharSequence)("excluding artifact from test jar: " + artifact.getArtifactId()));
            sb.append(",").append(artifact.getArtifactId());
        }
        String customExcludes = sb.toString();
        MojoUtils.executeWithMergedConfig(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-dependency-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-dependency-plugin"))), MojoExecutor.goal("copy-dependencies"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("includeScope"), "test"), MojoExecutor.element(MojoExecutor.name("excludeScope"), "provided"), MojoExecutor.element(MojoExecutor.name("excludeArtifactIds"), "junit" + customExcludes), MojoExecutor.element(MojoExecutor.name("useSubDirectoryPerScope"), "true"), MojoExecutor.element(MojoExecutor.name("outputDirectory"), "${project.build.directory}/testlibs")), this.executionEnvironment());
        File targetDir = new File(this.ctx.getProject().getBuild().getDirectory());
        File testlibsDir = new File(targetDir, "testlibs");
        File compileLibs = new File(testlibsDir, "compile");
        File testLibs = new File(testlibsDir, "test");
        File testClassesDir = new File(this.ctx.getProject().getBuild().getTestOutputDirectory());
        File metainfDir = new File(testClassesDir, "META-INF");
        File libDir = new File(metainfDir, "lib");
        try {
            compileLibs.mkdirs();
            testLibs.mkdirs();
            libDir.mkdirs();
            org.apache.commons.io.FileUtils.copyDirectory((File)compileLibs, (File)libDir);
            org.apache.commons.io.FileUtils.copyDirectory((File)testLibs, (File)libDir);
        }
        catch (IOException e) {
            throw new MojoExecutionException("unable to copy test libs", (Exception)e);
        }
    }

    public void copyTestBundledDependenciesExcludingTestScope(List<ProductArtifact> testBundleExcludes) throws MojoExecutionException {
        StringBuilder sb = new StringBuilder();
        for (ProductArtifact artifact : testBundleExcludes) {
            this.log.info((CharSequence)("excluding artifact from test jar: " + artifact.getArtifactId()));
            sb.append(",").append(artifact.getArtifactId());
        }
        String customExcludes = sb.toString();
        MojoUtils.executeWithMergedConfig(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-dependency-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-dependency-plugin"))), MojoExecutor.goal("copy-dependencies"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("includeScope"), "runtime"), MojoExecutor.element(MojoExecutor.name("excludeScope"), "provided"), MojoExecutor.element(MojoExecutor.name("excludeScope"), "test"), MojoExecutor.element(MojoExecutor.name("includeTypes"), "jar"), MojoExecutor.element(MojoExecutor.name("excludeArtifactIds"), "junit" + customExcludes), MojoExecutor.element(MojoExecutor.name("outputDirectory"), "${project.build.testOutputDirectory}/META-INF/lib")), this.executionEnvironment());
    }

    private void extractDependencies(Xpp3Dom configuration) throws MojoExecutionException {
        Xpp3Dom copyOfConfiguration = new Xpp3Dom(configuration);
        this.doExtractDependencies(configuration);
        this.warnAboutOverwrites(copyOfConfiguration);
    }

    private void warnAboutOverwrites(Xpp3Dom configuration) throws MojoExecutionException {
        Path tempDirectory = this.createTempDirectoryForOverwriteDetection();
        configuration.getChild("outputDirectory").setValue(tempDirectory.toString());
        configuration.addChild(MojoExecutor.element("useSubDirectoryPerArtifact", "true").toDom());
        configuration.addChild(MojoExecutor.element("overWriteReleases", "true").toDom());
        configuration.addChild(MojoExecutor.element("overWriteSnapshots", "true").toDom());
        configuration.addChild(MojoExecutor.element("silent", "true").toDom());
        this.doExtractDependencies(configuration);
        this.checkForOverwrites(tempDirectory);
        try {
            org.apache.commons.io.FileUtils.deleteDirectory((File)tempDirectory.toFile());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void checkForOverwrites(Path dependencyDirectory) {
        try (Stream<Path> fileStream = Files.walk(dependencyDirectory, new FileVisitOption[0]);){
            Map<Path, Set> artifactsByPath = fileStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(dependencyDirectory::relativize).collect(Collectors.groupingBy(MavenGoals::tail, Collectors.mapping(MavenGoals::head, Collectors.toCollection(TreeSet::new))));
            Map<Path, Set<Path>> clashes = artifactsByPath.entrySet().stream().filter(e -> ((Set)e.getValue()).size() > 1).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            if (!clashes.isEmpty()) {
                this.logWarnings(clashes);
            }
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
    }

    private void logWarnings(Map<Path, Set<Path>> clashes) {
        this.log.warn((CharSequence)"Extracting your plugin's dependencies caused the following file(s) to overwrite each other:");
        clashes.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> this.log.warn((CharSequence)String.format("-- %s from %s", e.getKey(), e.getValue())));
        this.log.warn((CharSequence)"To prevent this, set <extractDependencies> to false in your AMPS configuration");
    }

    private static Path head(Path path) {
        return path.subpath(0, 1);
    }

    private static Path tail(Path path) {
        return path.subpath(1, path.getNameCount());
    }

    private Path createTempDirectoryForOverwriteDetection() {
        Path targetDirectory = Paths.get(this.ctx.getProject().getBuild().getDirectory(), new String[0]);
        try {
            Files.createDirectories(targetDirectory, new FileAttribute[0]);
            return Files.createTempDirectory(targetDirectory, "amps-overwrite-detection-", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void doExtractDependencies(Xpp3Dom configuration) throws MojoExecutionException {
        MojoUtils.executeWithMergedConfig(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-dependency-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-dependency-plugin"))), MojoExecutor.goal("unpack-dependencies"), configuration, this.executionEnvironment());
    }

    public void extractBundledDependencies() throws MojoExecutionException {
        this.extractDependencies(MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("includeScope"), "runtime"), MojoExecutor.element(MojoExecutor.name("excludeScope"), "provided"), MojoExecutor.element(MojoExecutor.name("excludeScope"), "test"), MojoExecutor.element(MojoExecutor.name("includeTypes"), "jar"), MojoExecutor.element(MojoExecutor.name("excludes"), "atlassian-plugin.xml, module-info.class, META-INF/MANIFEST.MF, META-INF/*.DSA, META-INF/*.SF"), MojoExecutor.element(MojoExecutor.name("outputDirectory"), "${project.build.outputDirectory}")));
    }

    public void extractTestBundledDependenciesExcludingTestScope(List<ProductArtifact> testBundleExcludes) throws MojoExecutionException {
        StringBuilder sb = new StringBuilder();
        for (ProductArtifact artifact : testBundleExcludes) {
            sb.append(",").append(artifact.getArtifactId());
        }
        String customExcludes = sb.toString();
        this.extractDependencies(MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("includeScope"), "runtime"), MojoExecutor.element(MojoExecutor.name("excludeScope"), "provided"), MojoExecutor.element(MojoExecutor.name("excludeScope"), "test"), MojoExecutor.element(MojoExecutor.name("includeTypes"), "jar"), MojoExecutor.element(MojoExecutor.name("excludeArtifactIds"), "junit" + customExcludes), MojoExecutor.element(MojoExecutor.name("excludes"), "atlassian-plugin.xml, module-info.class, META-INF/MANIFEST.MF, META-INF/*.DSA, META-INF/*.SF"), MojoExecutor.element(MojoExecutor.name("outputDirectory"), "${project.build.testOutputDirectory}")));
    }

    public void extractTestBundledDependencies(List<ProductArtifact> testBundleExcludes) throws MojoExecutionException {
        StringBuilder sb = new StringBuilder();
        for (ProductArtifact artifact : testBundleExcludes) {
            sb.append(",").append(artifact.getArtifactId());
        }
        String customExcludes = sb.toString();
        this.extractDependencies(MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("includeScope"), "test"), MojoExecutor.element(MojoExecutor.name("excludeScope"), "provided"), MojoExecutor.element(MojoExecutor.name("excludeArtifactIds"), "junit" + customExcludes), MojoExecutor.element(MojoExecutor.name("includeTypes"), "jar"), MojoExecutor.element(MojoExecutor.name("useSubDirectoryPerScope"), "true"), MojoExecutor.element(MojoExecutor.name("excludes"), "atlassian-plugin.xml, module-info.class, META-INF/MANIFEST.MF, META-INF/*.DSA, META-INF/*.SF"), MojoExecutor.element(MojoExecutor.name("outputDirectory"), "${project.build.directory}/testlibs")));
        File targetDir = new File(this.ctx.getProject().getBuild().getDirectory());
        File testlibsDir = new File(targetDir, "testlibs");
        File compileLibs = new File(testlibsDir, "compile");
        File testLibs = new File(testlibsDir, "test");
        File testClassesDir = new File(this.ctx.getProject().getBuild().getTestOutputDirectory());
        try {
            compileLibs.mkdirs();
            testLibs.mkdirs();
            org.apache.commons.io.FileUtils.copyDirectory((File)compileLibs, (File)testClassesDir, (FileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.nameFileFilter((String)"META-INF")));
            org.apache.commons.io.FileUtils.copyDirectory((File)testLibs, (File)testClassesDir, (FileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.nameFileFilter((String)"META-INF")));
        }
        catch (IOException e) {
            throw new MojoExecutionException("unable to copy test libs", (Exception)e);
        }
    }

    public void compressResources(boolean compressJs, boolean compressCss, boolean useClosureForJs, Charset cs, Map<String, String> closureOptions) throws MojoExecutionException {
        MinifierParameters minifierParameters = new MinifierParameters(compressJs, compressCss, useClosureForJs, cs, this.log, closureOptions);
        new ResourcesMinifier(minifierParameters).minify(this.ctx.getProject().getBuild().getResources(), this.ctx.getProject().getBuild().getOutputDirectory());
    }

    public void filterPluginDescriptor() throws MojoExecutionException {
        MojoUtils.executeWithMergedConfig(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-resources-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-resources-plugin"))), MojoExecutor.goal("copy-resources"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("encoding"), "UTF-8"), MojoExecutor.element(MojoExecutor.name("resources"), MojoExecutor.element(MojoExecutor.name("resource"), MojoExecutor.element(MojoExecutor.name("directory"), "src/main/resources"), MojoExecutor.element(MojoExecutor.name("filtering"), "true"), MojoExecutor.element(MojoExecutor.name("includes"), MojoExecutor.element(MojoExecutor.name("include"), "atlassian-plugin.xml")))), MojoExecutor.element(MojoExecutor.name("outputDirectory"), "${project.build.outputDirectory}")), this.executionEnvironment());
        XmlCompressor compressor = new XmlCompressor();
        File pluginXmlFile = new File(this.ctx.getProject().getBuild().getOutputDirectory(), "atlassian-plugin.xml");
        if (pluginXmlFile.exists()) {
            try {
                String source = org.apache.commons.io.FileUtils.readFileToString((File)pluginXmlFile, (Charset)StandardCharsets.UTF_8);
                String min = compressor.compress(source);
                org.apache.commons.io.FileUtils.writeStringToFile((File)pluginXmlFile, (String)min, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new MojoExecutionException("IOException while minifying plugin XML file", (Exception)e);
            }
        }
    }

    public void filterTestPluginDescriptor() throws MojoExecutionException {
        MojoUtils.executeWithMergedConfig(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-resources-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-resources-plugin"))), MojoExecutor.goal("copy-resources"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("encoding"), "UTF-8"), MojoExecutor.element(MojoExecutor.name("resources"), MojoExecutor.element(MojoExecutor.name("resource"), MojoExecutor.element(MojoExecutor.name("directory"), "src/test/resources"), MojoExecutor.element(MojoExecutor.name("filtering"), "true"), MojoExecutor.element(MojoExecutor.name("includes"), MojoExecutor.element(MojoExecutor.name("include"), "atlassian-plugin.xml")))), MojoExecutor.element(MojoExecutor.name("outputDirectory"), "${project.build.testOutputDirectory}")), this.executionEnvironment());
    }

    public void runUnitTests(Map<String, Object> systemProperties, String excludedGroups, String category) throws MojoExecutionException {
        MojoExecutor.Element systemProps = this.convertPropsToElements(systemProperties);
        Xpp3Dom config = MojoExecutor.configuration(systemProps, MojoExecutor.element(MojoExecutor.name("excludes"), MojoExecutor.element(MojoExecutor.name("exclude"), REGEX_INTEGRATION_TESTS), MojoExecutor.element(MojoExecutor.name("exclude"), "**/*$*")), MojoExecutor.element(MojoExecutor.name("excludedGroups"), excludedGroups));
        if (this.isRelevantCategory(category)) {
            this.appendJunitCategoryToConfiguration(category, config);
        }
        String version = this.defaultArtifactIdToVersionMap.get("maven-surefire-plugin");
        this.log.info((CharSequence)("Surefire " + version + " test configuration:"));
        this.log.info((CharSequence)config.toString());
        MojoUtils.executeWithMergedConfig(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-surefire-plugin"), MojoExecutor.version(version)), MojoExecutor.goal("test"), config, this.executionEnvironment());
    }

    public File copyWebappWar(String productId, File targetDirectory, ProductArtifact artifact) throws MojoExecutionException {
        File webappWarFile = new File(targetDirectory, productId + "-original.war");
        MojoUtils.executeWithMergedConfig(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-dependency-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-dependency-plugin"))), MojoExecutor.goal("copy"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("artifactItems"), MojoExecutor.element(MojoExecutor.name("artifactItem"), MojoExecutor.element(MojoExecutor.name("groupId"), artifact.getGroupId()), MojoExecutor.element(MojoExecutor.name("artifactId"), artifact.getArtifactId()), MojoExecutor.element(MojoExecutor.name("type"), "war"), MojoExecutor.element(MojoExecutor.name("version"), artifact.getVersion()), MojoExecutor.element(MojoExecutor.name("destFileName"), webappWarFile.getName()))), MojoExecutor.element(MojoExecutor.name("outputDirectory"), targetDirectory.getPath())), this.executionEnvironment());
        return webappWarFile;
    }

    public void unpackWebappWar(File targetDirectory, ProductArtifact artifact) throws MojoExecutionException {
        MojoUtils.executeWithMergedConfig(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-dependency-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-dependency-plugin"))), MojoExecutor.goal("unpack"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("artifactItems"), MojoExecutor.element(MojoExecutor.name("artifactItem"), MojoExecutor.element(MojoExecutor.name("groupId"), artifact.getGroupId()), MojoExecutor.element(MojoExecutor.name("artifactId"), artifact.getArtifactId()), MojoExecutor.element(MojoExecutor.name("type"), "war"), MojoExecutor.element(MojoExecutor.name("version"), artifact.getVersion()))), MojoExecutor.element(MojoExecutor.name("outputDirectory"), targetDirectory.getPath()), MojoExecutor.element(MojoExecutor.name("overWriteReleases"), "true"), MojoExecutor.element(MojoExecutor.name("overWriteSnapshots"), "true"), MojoExecutor.element(MojoExecutor.name("useJvmChmod"), "true")), this.executionEnvironment());
    }

    public void copyPlugins(File outputDirectory, List<ProductArtifact> artifacts) throws MojoExecutionException {
        for (ProductArtifact artifact : artifacts) {
            MavenProject artifactReactorProject = this.getReactorProjectForArtifact(artifact);
            if (artifactReactorProject != null) {
                this.log.debug((CharSequence)(artifact + " will be copied from reactor project " + artifactReactorProject));
                File artifactFile = artifactReactorProject.getArtifact().getFile();
                if (artifactFile == null) {
                    this.log.warn((CharSequence)("The plugin " + artifact + " is in the reactor but not the file hasn't been attached.  Skipping."));
                    continue;
                }
                this.log.debug((CharSequence)("Copying " + artifactFile + " to " + outputDirectory));
                try {
                    org.apache.commons.io.FileUtils.copyFile((File)artifactFile, (File)new File(outputDirectory, artifactFile.getName()));
                    continue;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Could not copy " + artifact + " to " + outputDirectory, (Exception)e);
                }
            }
            MojoUtils.executeWithMergedConfig(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-dependency-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-dependency-plugin"))), MojoExecutor.goal("copy"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("artifactItems"), MojoExecutor.element(MojoExecutor.name("artifactItem"), MojoExecutor.element(MojoExecutor.name("groupId"), artifact.getGroupId()), MojoExecutor.element(MojoExecutor.name("artifactId"), artifact.getArtifactId()), MojoExecutor.element(MojoExecutor.name("version"), artifact.getVersion()))), MojoExecutor.element(MojoExecutor.name("outputDirectory"), outputDirectory.getPath())), this.executionEnvironment());
        }
    }

    private MavenProject getReactorProjectForArtifact(ProductArtifact artifact) {
        for (MavenProject project : this.ctx.getReactor()) {
            if (!project.getGroupId().equals(artifact.getGroupId()) || !project.getArtifactId().equals(artifact.getArtifactId()) || !project.getVersion().equals(artifact.getVersion())) continue;
            return project;
        }
        return null;
    }

    private void unpackContainer(Container container) throws MojoExecutionException {
        MojoUtils.executeWithMergedConfig(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-dependency-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-dependency-plugin"))), MojoExecutor.goal("unpack"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("artifactItems"), MojoExecutor.element(MojoExecutor.name("artifactItem"), MojoExecutor.element(MojoExecutor.name("groupId"), container.getGroupId()), MojoExecutor.element(MojoExecutor.name("artifactId"), container.getArtifactId()), MojoExecutor.element(MojoExecutor.name("version"), container.getVersion()), MojoExecutor.element(MojoExecutor.name("classifier"), container.getClassifier()), MojoExecutor.element(MojoExecutor.name("type"), "zip"))), MojoExecutor.element(MojoExecutor.name("outputDirectory"), container.getRootDirectory(this.getBuildDirectory()))), this.executionEnvironment());
    }

    private String getBuildDirectory() {
        return this.ctx.getProject().getBuild().getDirectory();
    }

    private static Xpp3Dom configurationWithoutNullElements(MojoExecutor.Element ... elements) {
        return MojoExecutor.configuration(MavenGoals.removeNullElements(elements));
    }

    private static MojoExecutor.Element[] removeNullElements(MojoExecutor.Element ... elements) {
        return (MojoExecutor.Element[])Arrays.stream(elements).filter(Objects::nonNull).toArray(MojoExecutor.Element[]::new);
    }

    private Plugin bndPlugin() {
        String bundleVersion = this.defaultArtifactIdToVersionMap.get("maven-bundle-plugin");
        this.log.info((CharSequence)("using maven-bundle-plugin v" + bundleVersion));
        return MojoExecutor.plugin(MojoExecutor.groupId("org.apache.felix"), MojoExecutor.artifactId("maven-bundle-plugin"), MojoExecutor.version(bundleVersion));
    }

    public int startWebapp(String productInstanceId, File war, Map<String, String> systemProperties, List<ProductArtifact> extraContainerDependencies, List<ProductArtifact> extraProductDeployables, Product webappContext) throws MojoExecutionException {
        int actualAjpPort;
        int actualRmiPort;
        int actualHttpPort;
        String protocol;
        int httpPort;
        Container container = this.getContainerFromWebappContext(webappContext);
        File containerDir = new File(container.getInstallDirectory(this.getBuildDirectory()));
        if (!container.isEmbedded()) {
            if (containerDir.exists()) {
                this.log.info((CharSequence)("Reusing unpacked container '" + container.getId() + "' from " + containerDir.getPath()));
            } else {
                this.log.info((CharSequence)("Unpacking container '" + container.getId() + "' from container artifact: " + container.toString()));
                this.unpackContainer(container);
            }
        }
        if (webappContext.isHttps()) {
            httpPort = webappContext.getHttpsPort();
            protocol = "https";
        } else {
            httpPort = webappContext.getHttpPort();
            protocol = "http";
        }
        if (httpPort == 0) {
            actualHttpPort = ProductHandlerUtil.pickFreePort(httpPort);
        } else {
            actualHttpPort = httpPort;
            if (!ProductHandlerUtil.isPortFree(actualHttpPort)) {
                String httpErrorMessage = String.format("%s: The configured HTTP port, %d, is in use", productInstanceId, httpPort);
                this.log.error((CharSequence)httpErrorMessage);
                throw new MojoExecutionException(httpErrorMessage);
            }
        }
        int rmiPort = webappContext.getRmiPort();
        if (rmiPort == 0) {
            actualRmiPort = ProductHandlerUtil.pickFreePort(rmiPort);
        } else {
            actualRmiPort = rmiPort;
            if (!ProductHandlerUtil.isPortFree(actualRmiPort)) {
                String rmiErrorMessage = String.format("%s: The configured RMI port, %d, is in use", productInstanceId, rmiPort);
                this.log.error((CharSequence)rmiErrorMessage);
                throw new MojoExecutionException(rmiErrorMessage);
            }
        }
        int ajpPort = webappContext.getAjpPort();
        if (ajpPort == 0) {
            actualAjpPort = ProductHandlerUtil.pickFreePort(ajpPort);
        } else {
            actualAjpPort = ajpPort;
            if (!ProductHandlerUtil.isPortFree(actualAjpPort)) {
                String ajpErrorMessage = String.format("%s: The configured AJP port, %d, is in use", productInstanceId, ajpPort);
                this.log.error((CharSequence)ajpErrorMessage);
                throw new MojoExecutionException(ajpErrorMessage);
            }
        }
        ArrayList<MojoExecutor.Element> sysProps = new ArrayList<MojoExecutor.Element>();
        systemProperties.forEach((key, value) -> sysProps.add(MojoExecutor.element(MojoExecutor.name(key), value)));
        this.log.info((CharSequence)("Starting " + productInstanceId + " on the " + container.getId() + " container on ports " + actualHttpPort + " (" + protocol + "), " + actualRmiPort + " (rmi) and " + actualAjpPort + " (ajp)"));
        String baseUrl = MavenGoals.getBaseUrl(webappContext, actualHttpPort);
        sysProps.add(MojoExecutor.element(MojoExecutor.name("baseurl"), baseUrl));
        List<MojoExecutor.Element> deps = this.extractDependencies(extraContainerDependencies, webappContext);
        ArrayList<MojoExecutor.Element> deployables = new ArrayList<MojoExecutor.Element>();
        deployables.add(MojoExecutor.element(MojoExecutor.name("deployable"), MojoExecutor.element(MojoExecutor.name("groupId"), "foo"), MojoExecutor.element(MojoExecutor.name("artifactId"), "bar"), MojoExecutor.element(MojoExecutor.name("type"), "war"), MojoExecutor.element(MojoExecutor.name("location"), war.getPath()), MojoExecutor.element(MojoExecutor.name("properties"), MojoExecutor.element(MojoExecutor.name("context"), webappContext.getContextPath()))));
        for (ProductArtifact extra : extraProductDeployables) {
            deployables.add(MojoExecutor.element(MojoExecutor.name("deployable"), MojoExecutor.element(MojoExecutor.name("groupId"), extra.getGroupId()), MojoExecutor.element(MojoExecutor.name("artifactId"), extra.getArtifactId()), MojoExecutor.element(MojoExecutor.name("type"), extra.getType()), MojoExecutor.element(MojoExecutor.name("location"), extra.getPath())));
        }
        List<MojoExecutor.Element> props = this.getConfigurationProperties(systemProperties, webappContext, actualRmiPort, actualHttpPort, actualAjpPort, protocol);
        int startupTimeout = webappContext.getStartupTimeout();
        if (Boolean.FALSE.equals(webappContext.getSynchronousStartup())) {
            startupTimeout = 0;
        }
        Plugin cargo = this.cargo(webappContext);
        MojoUtils.execute(cargo, MojoExecutor.goal("start"), MavenGoals.configurationWithoutNullElements(MojoExecutor.element(MojoExecutor.name("deployables"), deployables.toArray(new MojoExecutor.Element[0])), this.waitElement(cargo), MojoExecutor.element(MojoExecutor.name("container"), MojoExecutor.element(MojoExecutor.name("containerId"), container.getId()), MojoExecutor.element(MojoExecutor.name("type"), container.getType()), MojoExecutor.element(MojoExecutor.name("home"), container.getInstallDirectory(this.getBuildDirectory())), MojoExecutor.element(MojoExecutor.name("output"), webappContext.getOutput()), MojoExecutor.element(MojoExecutor.name("systemProperties"), sysProps.toArray(new MojoExecutor.Element[0])), MojoExecutor.element(MojoExecutor.name("dependencies"), deps.toArray(new MojoExecutor.Element[0])), MojoExecutor.element(MojoExecutor.name("timeout"), String.valueOf(startupTimeout))), MojoExecutor.element(MojoExecutor.name("configuration"), MavenGoals.removeNullElements(MojoExecutor.element(MojoExecutor.name("configfiles"), this.getExtraContainerConfigurationFiles()), MojoExecutor.element(MojoExecutor.name("home"), container.getConfigDirectory(this.getBuildDirectory(), productInstanceId)), MojoExecutor.element(MojoExecutor.name("type"), "standalone"), MojoExecutor.element(MojoExecutor.name("properties"), props.toArray(new MojoExecutor.Element[0])), this.xmlReplacementsElement(webappContext.getCargoXmlOverrides()))), MojoExecutor.element(MojoExecutor.name("deployer"), new MojoExecutor.Element[0])), this.executionEnvironment());
        return actualHttpPort;
    }

    private Container getContainerFromWebappContext(Product webappContext) {
        if (webappContext.getCustomContainerArtifact() == null) {
            return this.findContainer(webappContext.getContainerId());
        }
        return this.convertCustomContainerStringToContainerObject(webappContext);
    }

    private Container convertCustomContainerStringToContainerObject(Product webappContext) {
        String[] containerData = webappContext.getCustomContainerArtifact().trim().split(":");
        String cargoContainerId = this.findContainer(webappContext.getContainerId()).getId();
        switch (containerData.length) {
            case 5: {
                return new Container(cargoContainerId, containerData[0], containerData[1], containerData[2], containerData[4]);
            }
            case 4: {
                return new Container(cargoContainerId, containerData[0], containerData[1], containerData[2], containerData[3]);
            }
            case 3: {
                return new Container(cargoContainerId, containerData[0], containerData[1], containerData[2]);
            }
        }
        throw new IllegalArgumentException("Container artifact string must have format groupId:artifactId:version[:packaging:classifier] or groupId:artifactId:version:classifier");
    }

    private MojoExecutor.Element[] getExtraContainerConfigurationFiles() throws MojoExecutionException {
        return new MojoExecutor.Element[]{MojoExecutor.element("configfile", MojoExecutor.element("file", this.getContextXml().getAbsolutePath()), MojoExecutor.element("todir", "conf"), MojoExecutor.element("tofile", "context.xml"), MojoExecutor.element("configfile", "true"))};
    }

    private File getContextXml() throws MojoExecutionException {
        try {
            File tempContextXml = File.createTempFile("context.xml", null);
            InputStream contextXmlToCopy = Objects.requireNonNull(this.getClass().getResourceAsStream("context.xml"));
            org.apache.commons.io.FileUtils.copyInputStreamToFile((InputStream)contextXmlToCopy, (File)tempContextXml);
            return tempContextXml;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create Tomcat context.xml", (Exception)e);
        }
    }

    private List<MojoExecutor.Element> extractDependencies(List<ProductArtifact> extraContainerDependencies, Product webappContext) throws MojoExecutionException {
        ArrayList<MojoExecutor.Element> deps = new ArrayList<MojoExecutor.Element>();
        for (ProductArtifact dep : extraContainerDependencies) {
            deps.add(MojoExecutor.element(MojoExecutor.name("dependency"), MojoExecutor.element(MojoExecutor.name("location"), webappContext.getArtifactRetriever().resolve(dep))));
        }
        for (DataSource dataSource : webappContext.getDataSources()) {
            for (ProductArtifact productArtifact : dataSource.getLibArtifacts()) {
                deps.add(MojoExecutor.element(MojoExecutor.name("dependency"), MojoExecutor.element(MojoExecutor.name("location"), webappContext.getArtifactRetriever().resolve(productArtifact))));
            }
        }
        return deps;
    }

    private MojoExecutor.Element xmlReplacementsElement(Collection<XmlOverride> cargoXmlOverrides) {
        if (cargoXmlOverrides == null) {
            return null;
        }
        MojoExecutor.Element[] xmlReplacementsElements = (MojoExecutor.Element[])cargoXmlOverrides.stream().map(xmlOverride -> MojoExecutor.element(MojoExecutor.name("xmlReplacement"), MojoExecutor.element(MojoExecutor.name("file"), xmlOverride.getFile()), MojoExecutor.element(MojoExecutor.name("xpathExpression"), xmlOverride.getxPathExpression()), MojoExecutor.element(MojoExecutor.name("attributeName"), xmlOverride.getAttributeName()), MojoExecutor.element(MojoExecutor.name("value"), xmlOverride.getValue()))).toArray(MojoExecutor.Element[]::new);
        return MojoExecutor.element(MojoExecutor.name("xmlReplacements"), xmlReplacementsElements);
    }

    @VisibleForTesting
    List<MojoExecutor.Element> getConfigurationProperties(Map<String, String> systemProperties, Product webappContext, int rmiPort, int actualHttpPort, int actualAjpPort, String protocol) {
        ArrayList<MojoExecutor.Element> props = new ArrayList<MojoExecutor.Element>();
        for (Map.Entry<String, String> entry : systemProperties.entrySet()) {
            props.add(MojoExecutor.element(MojoExecutor.name(entry.getKey()), entry.getValue()));
        }
        props.add(MojoExecutor.element(MojoExecutor.name("cargo.servlet.port"), String.valueOf(actualHttpPort)));
        if (webappContext.getUseHttps().booleanValue()) {
            this.log.debug((CharSequence)"starting tomcat using Https via cargo with the following parameters:");
            this.log.debug((CharSequence)("cargo.servlet.port = " + actualHttpPort));
            this.log.debug((CharSequence)("cargo.protocol = " + protocol));
            props.add(MojoExecutor.element(MojoExecutor.name("cargo.protocol"), protocol));
            this.log.debug((CharSequence)("cargo.tomcat.connector.clientAuth = " + webappContext.getHttpsClientAuth()));
            props.add(MojoExecutor.element(MojoExecutor.name("cargo.tomcat.connector.clientAuth"), webappContext.getHttpsClientAuth()));
            this.log.debug((CharSequence)("cargo.tomcat.connector.sslProtocol = " + webappContext.getHttpsSSLProtocol()));
            props.add(MojoExecutor.element(MojoExecutor.name("cargo.tomcat.connector.sslProtocol"), webappContext.getHttpsSSLProtocol()));
            this.log.debug((CharSequence)("cargo.tomcat.connector.keystoreFile = " + webappContext.getHttpsKeystoreFile()));
            props.add(MojoExecutor.element(MojoExecutor.name("cargo.tomcat.connector.keystoreFile"), webappContext.getHttpsKeystoreFile()));
            this.log.debug((CharSequence)("cargo.tomcat.connector.keystorePass = " + webappContext.getHttpsKeystorePass()));
            props.add(MojoExecutor.element(MojoExecutor.name("cargo.tomcat.connector.keystorePass"), webappContext.getHttpsKeystorePass()));
            this.log.debug((CharSequence)("cargo.tomcat.connector.keyAlias = " + webappContext.getHttpsKeyAlias()));
            props.add(MojoExecutor.element(MojoExecutor.name("cargo.tomcat.connector.keyAlias"), webappContext.getHttpsKeyAlias()));
            this.log.debug((CharSequence)("cargo.tomcat.httpSecure = " + webappContext.getHttpsHttpSecure().toString()));
            props.add(MojoExecutor.element(MojoExecutor.name("cargo.tomcat.httpSecure"), webappContext.getHttpsHttpSecure().toString()));
        }
        props.add(MojoExecutor.element(MojoExecutor.name(AJP_PORT_PROPERTY), String.valueOf(actualAjpPort)));
        props.add(MojoExecutor.element(MojoExecutor.name("cargo.rmi.port"), String.valueOf(rmiPort)));
        props.add(MojoExecutor.element(MojoExecutor.name("cargo.jvmargs"), webappContext.getJvmArgs() + webappContext.getDebugArgs()));
        return props;
    }

    public void stopWebapp(String productId, String containerId, Product webappContext) throws MojoExecutionException {
        Container container = this.getContainerFromWebappContext(webappContext);
        String actualShutdownTimeout = webappContext.getSynchronousStartup() != false ? "0" : String.valueOf(webappContext.getShutdownTimeout());
        MojoUtils.execute(this.cargo(webappContext), MojoExecutor.goal("stop"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("container"), MojoExecutor.element(MojoExecutor.name("containerId"), container.getId()), MojoExecutor.element(MojoExecutor.name("type"), container.getType()), MojoExecutor.element(MojoExecutor.name("timeout"), actualShutdownTimeout), MojoExecutor.element(MojoExecutor.name("home"), container.getInstallDirectory(this.getBuildDirectory()))), MojoExecutor.element(MojoExecutor.name("configuration"), MojoExecutor.element(MojoExecutor.name("home"), container.getConfigDirectory(this.getBuildDirectory(), productId)), MojoExecutor.element(MojoExecutor.name("properties"), this.createShutdownPortsPropertiesConfiguration(webappContext)))), this.executionEnvironment());
    }

    private MojoExecutor.Element[] createShutdownPortsPropertiesConfiguration(Product webappContext) {
        String httpPort = String.valueOf(webappContext.isHttps() ? webappContext.getHttpsPort() : webappContext.getHttpPort());
        ArrayList<MojoExecutor.Element> properties = new ArrayList<MojoExecutor.Element>();
        properties.add(MojoExecutor.element(MojoExecutor.name("cargo.servlet.port"), httpPort));
        properties.add(MojoExecutor.element(MojoExecutor.name(AJP_PORT_PROPERTY), httpPort));
        return properties.toArray(new MojoExecutor.Element[properties.size()]);
    }

    protected Plugin cargo(Product context) {
        String cargoVersion = this.defaultArtifactIdToVersionMap.get("cargo-maven2-plugin");
        this.log.info((CharSequence)("using codehaus cargo v" + cargoVersion));
        return MojoExecutor.plugin(MojoExecutor.groupId("org.codehaus.cargo"), MojoExecutor.artifactId("cargo-maven2-plugin"), MojoExecutor.version(cargoVersion));
    }

    private MojoExecutor.Element waitElement(Plugin cargo) {
        if (cargo.getGroupId().equals("org.twdata.maven")) {
            return MojoExecutor.element(MojoExecutor.name("wait"), "false");
        }
        return null;
    }

    public static String getBaseUrl(Product product, int actualHttpPort) {
        return MavenGoals.getBaseUrl(product.getServer(), actualHttpPort, product.getContextPath());
    }

    private static String getBaseUrl(String server, int actualHttpPort, String contextPath) {
        String port = actualHttpPort != 80 ? ":" + actualHttpPort : "";
        String string = server = server.startsWith("http") ? server : "http://" + server;
        if (!contextPath.startsWith("/") && StringUtils.isNotBlank((CharSequence)contextPath)) {
            contextPath = "/" + contextPath;
        }
        return server + port + contextPath;
    }

    public void runIntegrationTests(String testGroupId, String containerId, List<String> includes, List<String> excludes, Map<String, Object> systemProperties, File targetDirectory, String category, boolean skipVerifyGoal, @Nullable String debug) throws MojoExecutionException {
        ArrayList<MojoExecutor.Element> includeElements = new ArrayList<MojoExecutor.Element>(includes.size());
        for (String string : includes) {
            includeElements.add(MojoExecutor.element(MojoExecutor.name("include"), string));
        }
        ArrayList<MojoExecutor.Element> excludeElements = new ArrayList<MojoExecutor.Element>(excludes.size() + 2);
        excludeElements.add(MojoExecutor.element(MojoExecutor.name("exclude"), "**/*$*"));
        excludeElements.add(MojoExecutor.element(MojoExecutor.name("exclude"), "**/Abstract*"));
        for (String exclude : excludes) {
            excludeElements.add(MojoExecutor.element(MojoExecutor.name("exclude"), exclude));
        }
        String string = targetDirectory.getAbsolutePath() + "/" + testGroupId + "/" + containerId + "/surefire-reports";
        String reportsDirectory = "reportsDirectory";
        systemProperties.put("reportsDirectory", string);
        MojoExecutor.Element systemProps = this.convertPropsToElements(systemProperties);
        Xpp3Dom config = MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("includes"), includeElements.toArray(new MojoExecutor.Element[0])), MojoExecutor.element(MojoExecutor.name("excludes"), excludeElements.toArray(new MojoExecutor.Element[0])), systemProps, MojoExecutor.element(MojoExecutor.name("reportsDirectory"), string));
        if (debug != null) {
            config.addChild(MojoExecutor.element(MojoExecutor.name("debugForkedProcess"), debug).toDom());
        }
        if (this.isRelevantCategory(category)) {
            this.appendJunitCategoryToConfiguration(category, config);
        }
        String version = this.defaultArtifactIdToVersionMap.get("maven-failsafe-plugin");
        this.log.info((CharSequence)("Failsafe " + version + " integration-test configuration:"));
        this.log.info((CharSequence)config.toString());
        MojoUtils.executeWithMergedConfig(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-failsafe-plugin"), MojoExecutor.version(version)), MojoExecutor.goal("integration-test"), config, this.executionEnvironment());
        if (!skipVerifyGoal) {
            MojoUtils.executeWithMergedConfig(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-failsafe-plugin"), MojoExecutor.version(version)), MojoExecutor.goal("verify"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("reportsDirectory"), string)), this.executionEnvironment());
        } else {
            this.log.info((CharSequence)"Skipping failsafe IT failure verification.");
        }
    }

    public void runPreIntegrationTest(DataSource dataSource) throws MojoExecutionException {
        String dumpFilePath = dataSource.getDumpFilePath();
        JiraDatabaseFactory factory = JiraDatabaseFactory.getJiraDatabaseFactory();
        JiraDatabase jiraDatabase = factory.getJiraDatabase(dataSource);
        Xpp3Dom sqlMavenPluginConfiguration = jiraDatabase.getPluginConfiguration();
        List<Dependency> libs = jiraDatabase.getDependencies();
        Plugin sqlMaven = MojoExecutor.plugin(MojoExecutor.groupId("org.codehaus.mojo"), MojoExecutor.artifactId("sql-maven-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("sql-maven-plugin")));
        ArrayList<Dependency> pluginDependencies = new ArrayList<Dependency>(sqlMaven.getDependencies().size() + libs.size());
        pluginDependencies.addAll(sqlMaven.getDependencies());
        pluginDependencies.addAll(libs);
        sqlMaven.setDependencies(pluginDependencies);
        MojoUtils.executeWithMergedConfig(sqlMaven, MojoExecutor.goal("execute"), sqlMavenPluginConfiguration, this.executionEnvironment());
        if (StringUtils.isNotEmpty((CharSequence)dumpFilePath)) {
            this.log.info((CharSequence)("Do import for dump file: " + dumpFilePath));
            File dumpFile = new File(dumpFilePath);
            if (!dumpFile.exists() || !dumpFile.isFile()) {
                throw new MojoExecutionException("SQL dump file does not exist: " + dumpFilePath);
            }
            if (ImportMethod.SQL.equals((Object)ImportMethod.getValueOf(dataSource.getImportMethod()))) {
                MojoUtils.executeWithMergedConfig(sqlMaven, MojoExecutor.goal("execute"), jiraDatabase.getConfigImportFile(), this.executionEnvironment());
            } else {
                Xpp3Dom configDatabaseTool = jiraDatabase.getConfigDatabaseTool();
                Plugin execMaven = MojoExecutor.plugin(MojoExecutor.groupId("org.codehaus.mojo"), MojoExecutor.artifactId("exec-maven-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-exec-plugin")));
                MojoUtils.executeWithMergedConfig(execMaven, MojoExecutor.goal("exec"), configDatabaseTool, this.executionEnvironment());
            }
        }
    }

    private void appendJunitCategoryToConfiguration(String category, Xpp3Dom config) {
        MojoExecutor.Element groups = MojoExecutor.element(MojoExecutor.name("groups"), category);
        config.addChild(groups.toDom());
    }

    private boolean isRelevantCategory(String category) {
        return category != null && !"".equals(category);
    }

    private MojoExecutor.Element convertPropsToElements(Map<String, Object> systemProperties) {
        ArrayList<MojoExecutor.Element> properties = new ArrayList<MojoExecutor.Element>();
        for (Map.Entry<String, Object> entry : systemProperties.entrySet()) {
            this.log.info((CharSequence)("adding system property to configuration: " + entry.getKey() + "::" + entry.getValue()));
            properties.add(MojoExecutor.element(MojoExecutor.name(entry.getKey()), entry.getValue().toString()));
        }
        return MojoExecutor.element(MojoExecutor.name("systemPropertyVariables"), properties.toArray(new MojoExecutor.Element[0]));
    }

    private Container findContainer(String containerId) {
        Container container = this.idToContainerMap.get(containerId);
        if (container == null) {
            throw new IllegalArgumentException("Container " + containerId + " not supported");
        }
        return container;
    }

    public void installPlugin(PdkParams pdkParams) throws MojoExecutionException {
        String baseUrl = MavenGoals.getBaseUrl(pdkParams.getServer(), pdkParams.getPort(), pdkParams.getContextPath());
        MojoUtils.executeWithMergedConfig(MojoExecutor.plugin(MojoExecutor.groupId("com.atlassian.maven.plugins"), MojoExecutor.artifactId("atlassian-pdk"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("atlassian-pdk"))), MojoExecutor.goal("install"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("pluginFile"), pdkParams.getPluginFile()), MojoExecutor.element(MojoExecutor.name("username"), pdkParams.getUsername()), MojoExecutor.element(MojoExecutor.name("password"), pdkParams.getPassword()), MojoExecutor.element(MojoExecutor.name("serverUrl"), baseUrl), MojoExecutor.element(MojoExecutor.name("pluginKey"), pdkParams.getPluginKey())), this.executionEnvironment());
    }

    public void installIdeaPlugin() throws MojoExecutionException {
        MojoUtils.executeWithMergedConfig(MojoExecutor.plugin(MojoExecutor.groupId("org.twdata.maven"), MojoExecutor.artifactId("maven-cli-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-cli-plugin"))), MojoExecutor.goal("idea"), MojoExecutor.configuration(new MojoExecutor.Element[0]), this.executionEnvironment());
    }

    public File copyDist(File targetDirectory, ProductArtifact artifact) throws MojoExecutionException {
        return this.copyZip(targetDirectory, artifact, "test-dist.zip");
    }

    public File copyHome(File targetDirectory, ProductArtifact artifact) throws MojoExecutionException {
        return this.copyZip(targetDirectory, artifact, artifact.getArtifactId() + ".zip");
    }

    public File copyZip(File targetDirectory, ProductArtifact artifact, String localName) throws MojoExecutionException {
        File artifactZip = new File(targetDirectory, localName);
        MojoUtils.executeWithMergedConfig(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-dependency-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-dependency-plugin"))), MojoExecutor.goal("copy"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("artifactItems"), MojoExecutor.element(MojoExecutor.name("artifactItem"), MojoExecutor.element(MojoExecutor.name("groupId"), artifact.getGroupId()), MojoExecutor.element(MojoExecutor.name("artifactId"), artifact.getArtifactId()), MojoExecutor.element(MojoExecutor.name("type"), "zip"), MojoExecutor.element(MojoExecutor.name("version"), artifact.getVersion()), MojoExecutor.element(MojoExecutor.name("destFileName"), artifactZip.getName()))), MojoExecutor.element(MojoExecutor.name("outputDirectory"), artifactZip.getParent())), this.executionEnvironment());
        return artifactZip;
    }

    public void generateBundleManifest(Map<String, String> instructions, Map<String, String> basicAttributes) throws MojoExecutionException {
        ArrayList<MojoExecutor.Element> instlist = new ArrayList<MojoExecutor.Element>();
        for (Map.Entry<String, String> entry : instructions.entrySet()) {
            instlist.add(MojoExecutor.element(entry.getKey(), entry.getValue()));
        }
        if (!instructions.containsKey("Import-Package")) {
            instlist.add(MojoExecutor.element("Import-Package", "*;resolution:=optional"));
        }
        for (Map.Entry<String, String> entry : basicAttributes.entrySet()) {
            instlist.add(MojoExecutor.element(entry.getKey(), entry.getValue()));
        }
        MojoUtils.executeWithMergedConfig(this.bndPlugin(), MojoExecutor.goal("manifest"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("supportedProjectTypes"), MojoExecutor.element(MojoExecutor.name("supportedProjectType"), "jar"), MojoExecutor.element(MojoExecutor.name("supportedProjectType"), "bundle"), MojoExecutor.element(MojoExecutor.name("supportedProjectType"), "war"), MojoExecutor.element(MojoExecutor.name("supportedProjectType"), "atlassian-plugin")), MojoExecutor.element(MojoExecutor.name("instructions"), instlist.toArray(new MojoExecutor.Element[0]))), this.executionEnvironment());
    }

    public void generateTestBundleManifest(Map<String, String> instructions, Map<String, String> basicAttributes) throws MojoExecutionException {
        ArrayList<MojoExecutor.Element> instlist = new ArrayList<MojoExecutor.Element>();
        for (Map.Entry<String, String> entry : instructions.entrySet()) {
            instlist.add(MojoExecutor.element(entry.getKey(), entry.getValue()));
        }
        if (!instructions.containsKey("Import-Package")) {
            instlist.add(MojoExecutor.element("Import-Package", "*;resolution:=optional"));
        }
        for (Map.Entry<String, String> entry : basicAttributes.entrySet()) {
            instlist.add(MojoExecutor.element(entry.getKey(), entry.getValue()));
        }
        MojoUtils.executeWithMergedConfig(this.bndPlugin(), MojoExecutor.goal("manifest"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("manifestLocation"), "${project.build.testOutputDirectory}/META-INF"), MojoExecutor.element(MojoExecutor.name("supportedProjectTypes"), MojoExecutor.element(MojoExecutor.name("supportedProjectType"), "jar"), MojoExecutor.element(MojoExecutor.name("supportedProjectType"), "bundle"), MojoExecutor.element(MojoExecutor.name("supportedProjectType"), "war"), MojoExecutor.element(MojoExecutor.name("supportedProjectType"), "atlassian-plugin")), MojoExecutor.element(MojoExecutor.name("instructions"), instlist.toArray(new MojoExecutor.Element[0]))), this.executionEnvironment());
    }

    public void generateMinimalManifest(Map<String, String> basicAttributes) throws MojoExecutionException {
        File metaInf = FileUtils.file(this.ctx.getProject().getBuild().getOutputDirectory(), "META-INF");
        if (!metaInf.exists()) {
            metaInf.mkdirs();
        }
        File mf = FileUtils.file(this.ctx.getProject().getBuild().getOutputDirectory(), "META-INF", "MANIFEST.MF");
        Manifest m = new Manifest();
        m.getMainAttributes().putValue("Manifest-Version", "1.0");
        for (Map.Entry<String, String> entry : basicAttributes.entrySet()) {
            m.getMainAttributes().putValue(entry.getKey(), entry.getValue());
        }
        try (FileOutputStream fos = new FileOutputStream(mf);){
            m.write(fos);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to create manifest", (Exception)e);
        }
    }

    public void generateTestMinimalManifest(Map<String, String> basicAttributes) throws MojoExecutionException {
        File metaInf = FileUtils.file(this.ctx.getProject().getBuild().getTestOutputDirectory(), "META-INF");
        if (!metaInf.exists()) {
            metaInf.mkdirs();
        }
        File mf = FileUtils.file(this.ctx.getProject().getBuild().getTestOutputDirectory(), "META-INF", "MANIFEST.MF");
        Manifest m = new Manifest();
        m.getMainAttributes().putValue("Manifest-Version", "1.0");
        for (Map.Entry<String, String> entry : basicAttributes.entrySet()) {
            m.getMainAttributes().putValue(entry.getKey(), entry.getValue());
        }
        try (FileOutputStream fos = new FileOutputStream(mf);){
            m.write(fos);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to create manifest", (Exception)e);
        }
    }

    public void jarWithOptionalManifest(boolean manifestExists) throws MojoExecutionException {
        MojoExecutor.Element[] archive = new MojoExecutor.Element[]{};
        if (manifestExists) {
            archive = new MojoExecutor.Element[]{MojoExecutor.element(MojoExecutor.name("manifestFile"), "${project.build.outputDirectory}/META-INF/MANIFEST.MF")};
        }
        MojoUtils.executeWithMergedConfig(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-jar-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-jar-plugin"))), MojoExecutor.goal("jar"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("archive"), archive)), this.executionEnvironment());
    }

    public void jarTests(String finalName) throws MojoExecutionException {
        MojoUtils.executeWithMergedConfig(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-jar-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-jar-plugin"))), MojoExecutor.goal("test-jar"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("finalName"), finalName), MojoExecutor.element(MojoExecutor.name("archive"), MojoExecutor.element(MojoExecutor.name("manifestFile"), "${project.build.testOutputDirectory}/META-INF/MANIFEST.MF"))), this.executionEnvironment());
    }

    public void generateObrXml(File dep, File obrXml) throws MojoExecutionException {
        MojoUtils.executeWithMergedConfig(this.bndPlugin(), MojoExecutor.goal("install-file"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("obrRepository"), obrXml.getPath()), MojoExecutor.element(MojoExecutor.name("groupId"), "doesntmatter"), MojoExecutor.element(MojoExecutor.name("artifactId"), "doesntmatter"), MojoExecutor.element(MojoExecutor.name("version"), "doesntmatter"), MojoExecutor.element(MojoExecutor.name("packaging"), "jar"), MojoExecutor.element(MojoExecutor.name("file"), dep.getPath())), this.executionEnvironment());
    }

    public void attachArtifact(File file, String type) throws MojoExecutionException {
        MojoUtils.executeWithMergedConfig(MojoExecutor.plugin(MojoExecutor.groupId("org.codehaus.mojo"), MojoExecutor.artifactId("build-helper-maven-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("build-helper-maven-plugin"))), MojoExecutor.goal("attach-artifact"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("artifacts"), MojoExecutor.element(MojoExecutor.name("artifact"), MojoExecutor.element(MojoExecutor.name("file"), file.getAbsolutePath()), MojoExecutor.element(MojoExecutor.name("type"), type)))), this.executionEnvironment());
    }

    public void release(String mavenArgs) throws MojoExecutionException {
        String args = "";
        if (StringUtils.isNotBlank((CharSequence)mavenArgs)) {
            args = mavenArgs;
        }
        MojoUtils.executeWithMergedConfig(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-release-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-release-plugin"))), MojoExecutor.goal("prepare"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("arguments"), args), MojoExecutor.element(MojoExecutor.name("autoVersionSubmodules"), "true")), this.executionEnvironment());
        MojoUtils.executeWithMergedConfig(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-release-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-release-plugin"))), MojoExecutor.goal("perform"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("arguments"), args), MojoExecutor.element(MojoExecutor.name("useReleaseProfile"), "true")), this.executionEnvironment());
    }

    public void generateRestDocs(String jacksonModules) throws MojoExecutionException {
        MavenProject prj = this.ctx.getProject();
        StringBuilder packagesPath = new StringBuilder();
        List<PluginXmlUtils.RESTModuleInfo> restModules = PluginXmlUtils.getRestModules(this.ctx);
        for (PluginXmlUtils.RESTModuleInfo moduleInfo : restModules) {
            List<String> packageList = moduleInfo.getPackagesToScan();
            for (String packageToScan : packageList) {
                if (packagesPath.length() > 0) {
                    packagesPath.append(File.pathSeparator);
                }
                String filePath = prj.getBuild().getSourceDirectory() + File.separator + packageToScan.replaceAll("\\.", Matcher.quoteReplacement(File.separator));
                packagesPath.append(filePath);
            }
        }
        if (!restModules.isEmpty() && packagesPath.length() > 0) {
            MojoExecutor.Element[] elementArray;
            HashSet<String> docletPaths = new HashSet<String>();
            StringBuilder docletPath = new StringBuilder(File.pathSeparator + prj.getBuild().getOutputDirectory());
            String resourcedocPath = FileUtils.fixWindowsSlashes(prj.getBuild().getOutputDirectory() + File.separator + "resourcedoc.xml");
            PluginXmlUtils.PluginInfo pluginInfo = PluginXmlUtils.getPluginInfo(this.ctx);
            try {
                docletPaths.addAll(prj.getCompileClasspathElements());
                docletPaths.addAll(prj.getRuntimeClasspathElements());
                docletPaths.addAll(prj.getSystemClasspathElements());
                URL[] pluginUrls = ((URLClassLoader)Thread.currentThread().getContextClassLoader()).getURLs();
                for (URL pluginUrl : pluginUrls) {
                    docletPaths.add(new File(pluginUrl.getFile()).getPath());
                }
                for (String path : docletPaths) {
                    docletPath.append(File.pathSeparator);
                    docletPath.append(path);
                }
            }
            catch (DependencyResolutionRequiredException e) {
                throw new MojoExecutionException("Dependencies must be resolved", (Exception)((Object)e));
            }
            MojoExecutor.Element outputOption = MojoExecutor.element(MojoExecutor.name("additionalOption"), "-output \"" + resourcedocPath + "\"");
            if (jacksonModules == null) {
                MojoExecutor.Element[] elementArray2 = new MojoExecutor.Element[1];
                elementArray = elementArray2;
                elementArray2[0] = outputOption;
            } else {
                MojoExecutor.Element[] elementArray3 = new MojoExecutor.Element[2];
                elementArray3[0] = outputOption;
                elementArray = elementArray3;
                elementArray3[1] = MojoExecutor.element(MojoExecutor.name("additionalOption"), " -modules \"" + jacksonModules + "\"");
            }
            MojoExecutor.Element[] additionalOptions = elementArray;
            Plugin globalJavadoc = this.executionEnvironment().getMavenProject().getPlugin("org.apache.maven.plugins:maven-javadoc-plugin");
            if (null != globalJavadoc) {
                this.executionEnvironment().getMavenProject().getBuild().removePlugin(globalJavadoc);
            }
            MojoUtils.executeWithMergedConfig(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-javadoc-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-javadoc-plugin"))), MojoExecutor.goal("javadoc"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("maxmemory"), "1024m"), MojoExecutor.element(MojoExecutor.name("sourcepath"), packagesPath.toString()), MojoExecutor.element(MojoExecutor.name("doclet"), "com.sun.jersey.wadl.resourcedoc.ResourceDocletJSON"), MojoExecutor.element(MojoExecutor.name("docletPath"), docletPath.toString()), MojoExecutor.element(MojoExecutor.name("docletArtifacts"), MojoExecutor.element(MojoExecutor.name("docletArtifact"), MojoExecutor.element(MojoExecutor.name("groupId"), "com.atlassian.plugins.rest"), MojoExecutor.element(MojoExecutor.name("artifactId"), "atlassian-rest-doclet"), MojoExecutor.element(MojoExecutor.name("version"), "2.9.2")), MojoExecutor.element(MojoExecutor.name("docletArtifact"), MojoExecutor.element(MojoExecutor.name("groupId"), "xerces"), MojoExecutor.element(MojoExecutor.name("artifactId"), "xercesImpl"), MojoExecutor.element(MojoExecutor.name("version"), "2.9.1")), MojoExecutor.element(MojoExecutor.name("docletArtifact"), MojoExecutor.element(MojoExecutor.name("groupId"), "commons-lang"), MojoExecutor.element(MojoExecutor.name("artifactId"), "commons-lang"), MojoExecutor.element(MojoExecutor.name("version"), "2.6"))), MojoExecutor.element(MojoExecutor.name("outputDirectory"), new MojoExecutor.Element[0]), MojoExecutor.element(MojoExecutor.name("additionalOptions"), additionalOptions), MojoExecutor.element(MojoExecutor.name("useStandardDocletOptions"), "false")), this.executionEnvironment());
            if (null != globalJavadoc) {
                this.executionEnvironment().getMavenProject().getBuild().addPlugin(globalJavadoc);
            }
            try {
                File userGrammars;
                File userAppDocs = new File(prj.getBuild().getOutputDirectory(), "application-doc.xml");
                if (!userAppDocs.exists()) {
                    String appDocText = Resources.toString((URL)Resources.getResource((String)"application-doc.xml"), (Charset)StandardCharsets.UTF_8);
                    appDocText = StringUtils.replace((String)appDocText, (String)"${rest.doc.title}", (String)pluginInfo.getName());
                    appDocText = StringUtils.replace((String)appDocText, (String)"${rest.doc.description}", (String)pluginInfo.getDescription());
                    File appDocFile = new File(prj.getBuild().getOutputDirectory(), "application-doc.xml");
                    org.apache.commons.io.FileUtils.writeStringToFile((File)appDocFile, (String)appDocText, (Charset)StandardCharsets.UTF_8);
                    this.log.info((CharSequence)("Wrote " + appDocFile.getAbsolutePath()));
                }
                if (!(userGrammars = new File(prj.getBuild().getOutputDirectory(), "application-grammars.xml")).exists()) {
                    String grammarText = Resources.toString((URL)Resources.getResource((String)"application-grammars.xml"), (Charset)StandardCharsets.UTF_8);
                    File grammarFile = new File(prj.getBuild().getOutputDirectory(), "application-grammars.xml");
                    org.apache.commons.io.FileUtils.writeStringToFile((File)grammarFile, (String)grammarText, (Charset)StandardCharsets.UTF_8);
                    this.log.info((CharSequence)("Wrote " + grammarFile.getAbsolutePath()));
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error writing REST application xml files", e);
            }
        }
    }

    public void copyContainerToOutputDirectory(String containerVersion) throws MojoExecutionException {
        MojoUtils.executeWithMergedConfig(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-dependency-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-dependency-plugin"))), MojoExecutor.goal("copy"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("artifactItems"), MojoExecutor.element(MojoExecutor.name("artifactItem"), MojoExecutor.element(MojoExecutor.name("groupId"), "com.atlassian.plugins"), MojoExecutor.element(MojoExecutor.name("artifactId"), "remotable-plugins-container"), MojoExecutor.element(MojoExecutor.name("version"), containerVersion))), MojoExecutor.element(MojoExecutor.name("stripVersion"), "true"), MojoExecutor.element(MojoExecutor.name("outputDirectory"), "${project.build.directory}")), this.executionEnvironment());
    }

    public void debugStandaloneContainer(File pluginFile) throws MojoExecutionException {
        StringBuilder resourceProp = new StringBuilder();
        List resList = this.getContextProject().getResources();
        for (int i = 0; i < resList.size(); ++i) {
            resourceProp.append(((Resource)resList.get(i)).getDirectory());
            if (i + 1 == resList.size()) continue;
            resourceProp.append(",");
        }
        MojoUtils.executeWithMergedConfig(MojoExecutor.plugin(MojoExecutor.groupId("org.codehaus.mojo"), MojoExecutor.artifactId("exec-maven-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-exec-plugin"))), MojoExecutor.goal("exec"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("executable"), "java"), MojoExecutor.element(MojoExecutor.name("arguments"), MojoExecutor.element(MojoExecutor.name("argument"), "-Datlassian.dev.mode=true"), MojoExecutor.element(MojoExecutor.name("argument"), "-Datlassian.allow.insecure.url.parameter.login=true"), MojoExecutor.element(MojoExecutor.name("argument"), "-Dplugin.resource.directories=" + resourceProp), MojoExecutor.element(MojoExecutor.name("argument"), "-Xdebug"), MojoExecutor.element(MojoExecutor.name("argument"), "-Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=5004"), MojoExecutor.element(MojoExecutor.name("argument"), "-jar"), MojoExecutor.element(MojoExecutor.name("argument"), "${project.build.directory}/remotable-plugins-container-standalone.jar"), MojoExecutor.element(MojoExecutor.name("argument"), pluginFile.getPath()))), this.executionEnvironment());
    }

    public File generateEffectivePom(ProductArtifact artifact, File parentDir) throws MojoExecutionException {
        File effectivePom = new File(parentDir, "effectivePom.xml");
        MojoUtils.executeWithMergedConfig(MojoExecutor.plugin(MojoExecutor.groupId("org.apache.maven.plugins"), MojoExecutor.artifactId("maven-help-plugin"), MojoExecutor.version(this.defaultArtifactIdToVersionMap.get("maven-help-plugin"))), MojoExecutor.goal("effective-pom"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("artifact"), artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion()), MojoExecutor.element(MojoExecutor.name("output"), effectivePom.getAbsolutePath())), this.executionEnvironment());
        return effectivePom;
    }

    private static class Container
    extends ProductArtifact {
        private final String id;
        private final String type;
        private final String classifier;

        Container(String id, String groupId, String artifactId, String version) {
            super(groupId, artifactId, version);
            this.id = id;
            this.type = "installed";
            this.classifier = "";
        }

        Container(String id, String groupId, String artifactId, String version, String classifier) {
            super(groupId, artifactId, version);
            this.id = id;
            this.type = "installed";
            this.classifier = classifier;
        }

        Container(String id) {
            this.id = id;
            this.type = "embedded";
            this.classifier = "";
        }

        public String getId() {
            return this.id;
        }

        @Override
        public String getType() {
            return this.type;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public boolean isEmbedded() {
            return "embedded".equals(this.type);
        }

        public String getRootDirectory(String buildDir) {
            return buildDir + File.separator + "container" + File.separator + this.getId();
        }

        public String getInstallDirectory(String buildDir) {
            String installDirectory = this.getRootDirectory(buildDir) + File.separator + this.getArtifactId() + "-";
            String version = this.getVersion();
            if (version.endsWith("-atlassian-hosted") && !new File(installDirectory + version).exists()) {
                version = version.substring(0, version.indexOf("-atlassian-hosted"));
            }
            return installDirectory + version;
        }

        public String getConfigDirectory(String buildDir, String productId) {
            return this.getRootDirectory(buildDir) + File.separator + "cargo-" + productId + "-home";
        }
    }
}

