/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.minifier.strategies.googleclosure;

import com.google.javascript.jscomp.CompilerOptions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.logging.Log;

public class GoogleClosureOptionsHandler {
    private CompilerOptions compilerOptions;
    private Log log;
    private final Map<String, Method> configOptions = new HashMap<String, Method>();

    public GoogleClosureOptionsHandler(Log log) {
        this.compilerOptions = new CompilerOptions();
        this.log = log;
        this.compilerOptions.setLanguageIn(CompilerOptions.LanguageMode.ECMASCRIPT_2018);
        this.compilerOptions.setEmitUseStrict(false);
        for (Method m : this.getClass().getDeclaredMethods()) {
            if (!Modifier.isPrivate(m.getModifiers()) || m.getParameterCount() != 1 || m.getParameterTypes()[0] != String.class || !m.getName().startsWith("set")) continue;
            String name = m.getName().substring(3).toLowerCase();
            this.configOptions.put(name, m);
        }
    }

    public void setOption(@Nonnull String optionName, String value) {
        String key = optionName.toLowerCase();
        if (this.configOptions.containsKey(key)) {
            try {
                this.configOptions.get(key).invoke((Object)this, value);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                this.log.warn((CharSequence)(optionName + " could not be configured.  Ignoring this option."), (Throwable)e);
            }
        } else {
            this.log.warn((CharSequence)(optionName + " is not configurable. Ignoring this option."));
        }
    }

    public CompilerOptions getCompilerOptions() {
        return this.compilerOptions;
    }

    private void setLanguageIn(String value) {
        this.compilerOptions.setLanguageIn(CompilerOptions.LanguageMode.valueOf((String)value));
    }

    private void setLanguageOut(String value) {
        this.compilerOptions.setLanguageOut(CompilerOptions.LanguageMode.valueOf((String)value));
    }

    private void setEmitUseStrict(String value) {
        this.compilerOptions.setEmitUseStrict(Boolean.parseBoolean(value));
    }
}

