/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.refapp.ctk;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.util.ClassLoaderUtils;
import com.atlassian.refapp.ctk.VersionStringComparator;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.osgi.service.packageadmin.ExportedPackage;
import org.twdata.pkgscanner.DefaultOsgiVersionConverter;
import org.twdata.pkgscanner.OsgiVersionConverter;

public final class PlatformVersionSpecReader {
    private static final String PLATFORM_VERSION_PATH = "platformversions.xml";

    static Document readPlatformVersionDocument() {
        InputStream in = ClassLoaderUtils.getResourceAsStream((String)PLATFORM_VERSION_PATH, PlatformVersionSpecReader.class);
        try {
            SAXReader reader = new SAXReader();
            Document document = reader.read(in);
            return document;
        }
        catch (DocumentException e) {
            throw new IllegalStateException("Cannot read the platform version definition", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public static String getPlatformVersion() {
        Document document = PlatformVersionSpecReader.readPlatformVersionDocument();
        List nodes = document.selectNodes("/platform");
        return ((Node)nodes.get(0)).valueOf("@version");
    }

    public static List<ExportVersionCheck> getExportVersionChecks() {
        Document document = PlatformVersionSpecReader.readPlatformVersionDocument();
        List nodes = document.selectNodes("/platform/export-version-check");
        return nodes.stream().map(PlatformVersionSpecReader::parseExportVersionCheck).collect(Collectors.toList());
    }

    private static ExportVersionCheck parseExportVersionCheck(Node node) {
        String pkg = node.valueOf("@package");
        String version = node.valueOf("@version");
        String moduleName = node.valueOf("@modulename");
        boolean optional = Boolean.parseBoolean(node.valueOf("@optional"));
        return new ExportVersionCheck(pkg, version, moduleName, optional);
    }

    public static List<PluginVersionCheck> getPluginVersionChecks() {
        Document document = PlatformVersionSpecReader.readPlatformVersionDocument();
        List pluginCheckNodes = document.selectNodes("/platform/plugin-version-check");
        return pluginCheckNodes.stream().map(PlatformVersionSpecReader::parsePluginVersionCheck).collect(Collectors.toList());
    }

    private static PluginVersionCheck parsePluginVersionCheck(Node node) {
        String pluginKey = node.valueOf("@key");
        String version = node.valueOf("@version");
        String moduleName = node.valueOf("@modulename");
        boolean optional = Boolean.parseBoolean(node.valueOf("@optional"));
        return new PluginVersionCheck(pluginKey, version, moduleName, optional);
    }

    private PlatformVersionSpecReader() {
    }

    public static class ExportVersionCheck
    extends VersionCheck {
        private final String pkg;

        private ExportVersionCheck(String pkg, String version, String moduleName, boolean optional) {
            super(version, moduleName, optional);
            Validate.notEmpty((String)pkg);
            this.pkg = pkg;
        }

        public String getPkg() {
            return this.pkg;
        }

        public boolean isValid(@Nullable ExportedPackage export) {
            if (export == null) {
                return this.isOptional();
            }
            return VersionStringComparator.isSameOrNewerVersion(this.getOsgiVersion(this.getVersion()), export.getVersion().toString());
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("pkg", (Object)this.pkg).append("optional", this.isOptional()).toString();
        }
    }

    public static class PluginVersionCheck
    extends VersionCheck {
        private final String pluginKey;

        private PluginVersionCheck(String pluginKey, String version, String moduleName, boolean optional) {
            super(version, moduleName, optional);
            Validate.notEmpty((String)pluginKey);
            this.pluginKey = pluginKey;
        }

        public String getPluginKey() {
            return this.pluginKey;
        }

        public boolean isValid(@Nullable Plugin plugin) {
            if (plugin == null) {
                return this.isOptional();
            }
            return VersionStringComparator.isSameOrNewerVersion(this.getOsgiVersion(this.getVersion()), plugin.getPluginInformation().getVersion());
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("pluginKey", (Object)this.pluginKey).append("optional", this.isOptional()).toString();
        }
    }

    static abstract class VersionCheck {
        private static final OsgiVersionConverter OSGI_VERSION_CONVERTER = new DefaultOsgiVersionConverter();
        protected final String version;
        protected final String moduleName;
        private final boolean optional;

        VersionCheck(String version, String moduleName, boolean optional) {
            Validate.notEmpty((String)version);
            Validate.notEmpty((String)moduleName);
            this.version = version;
            this.moduleName = moduleName;
            this.optional = optional;
        }

        public String getVersion() {
            return this.version;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public boolean isOptional() {
            return this.optional;
        }

        protected final String getOsgiVersion(String version) {
            return OSGI_VERSION_CONVERTER.getVersion(version);
        }

        public String toString() {
            return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("version", (Object)this.version).append("moduleName", (Object)this.moduleName).toString();
        }
    }
}

