/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.refapp.ctk.sal;

import com.atlassian.functest.junit.SpringAwareTestCase;
import com.atlassian.sal.api.auth.LoginUriProvider;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class LoginUriProviderTest
extends SpringAwareTestCase {
    private LoginUriProvider provider;

    public void setProvider(LoginUriProvider provider) {
        this.provider = provider;
    }

    @Test
    public void testLoginUriProviderAvailable() {
        Assert.assertNotNull((String)"LoginUriProvider should be available to plugins", (Object)this.provider);
    }

    public static void assertThatDestinationUriIsEncodedAsLoginUriQueryParameterValue(String destUri, URI loginUri) {
        String query = loginUri.getRawQuery();
        Assert.assertNotNull((Object)query);
        ArrayList<String> allValues = new ArrayList<String>();
        for (String q : query.split("&")) {
            int i = q.indexOf(61);
            if (i < 0) continue;
            String encodedVal = q.substring(i + 1);
            try {
                String val = URLDecoder.decode(encodedVal, "utf-8");
                allValues.add(val);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        Assert.assertTrue((String)("Login URI should contain destination: " + destUri + " should be in " + allValues), (boolean)allValues.contains(destUri));
    }

    @Test
    public void testGetLoginUriMustContainDestinationUriAsParameterValue() throws URISyntaxException, UnsupportedEncodingException {
        String destUri = "http://server/dest.html?param=value";
        URI loginUri = this.provider.getLoginUri(new URI(destUri));
        LoginUriProviderTest.assertThatDestinationUriIsEncodedAsLoginUriQueryParameterValue(destUri, loginUri);
    }

    @Test
    public void testGetLoginUriMustContainDestinationUriWithAmpersandAsParameterValue() throws URISyntaxException, UnsupportedEncodingException {
        String destUri = "http://server/dest.html?param=value&p2=val2";
        URI loginUri = this.provider.getLoginUri(new URI(destUri));
        LoginUriProviderTest.assertThatDestinationUriIsEncodedAsLoginUriQueryParameterValue(destUri, loginUri);
    }
}

