/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.refapp.ctk.scheduler;

import com.atlassian.functest.junit.SpringAwareTestCase;
import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.Response;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.cron.CronSyntaxException;
import com.atlassian.tenancy.api.TenantContext;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;

public final class SchedulerServiceTest
extends SpringAwareTestCase {
    private SchedulerService schedulerService;
    private TenantContext tenantContext;
    private ApplicationProperties applicationProperties;
    private HttpClient httpClient;
    private final JobId localJob = JobId.of((String)"localJob");
    private final JobId clusteredJob = JobId.of((String)"clusteredJob");
    private final JobRunnerKey jobRunnerKey = JobRunnerKey.of((String)"test-job-runner");

    @Before
    public void before() {
        this.schedulerService.unscheduleJob(this.localJob);
        this.schedulerService.unscheduleJob(this.clusteredJob);
        this.schedulerService.unregisterJobRunner(this.jobRunnerKey);
    }

    @Test
    public void testScheduleLocalJob() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        JobRunnerKey jobRunnerKey = JobRunnerKey.of((String)"test-job-runner");
        this.schedulerService.registerJobRunner(jobRunnerKey, new JobRunner(){

            @Nullable
            public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
                latch.countDown();
                return null;
            }
        });
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)jobRunnerKey).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.runOnce(null));
        this.schedulerService.scheduleJob(this.localJob, jobConfig);
        MatcherAssert.assertThat((Object)this.isJobExistInEss(this.localJob), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)latch.await(30L, TimeUnit.SECONDS), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testScheduleLocalJobEmptyCronExpression() throws Exception {
        JobRunnerKey jobRunnerKey = JobRunnerKey.of((String)"test-job-runner");
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)jobRunnerKey).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forCronExpression((String)""));
        try {
            this.schedulerService.scheduleJob(this.localJob, jobConfig);
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(CronSyntaxException.class)));
        }
        MatcherAssert.assertThat((Object)this.isJobExistInEss(this.localJob), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testScheduleLocalJobInvalidCronExpression() throws Exception {
        JobRunnerKey jobRunnerKey = JobRunnerKey.of((String)"test-job-runner");
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)jobRunnerKey).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forCronExpression((String)"0 * * * *"));
        try {
            this.schedulerService.scheduleJob(this.localJob, jobConfig);
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(CronSyntaxException.class)));
        }
        MatcherAssert.assertThat((Object)this.isJobExistInEss(this.localJob), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testScheduleClusteredJobRunOnceNoRunTime() throws Exception {
        this.testScheduleClusteredJob(Schedule.runOnce(null));
    }

    @Test
    public void testScheduleClusteredJobRunOnceWithRunTime() throws Exception {
        this.testScheduleClusteredJob(Schedule.runOnce((Date)new Date()));
    }

    @Test
    public void testScheduleClusteredJobIntervalNoStart() throws Exception {
        this.testScheduleClusteredJob(Schedule.forInterval((long)60000L, null));
    }

    @Test
    public void testScheduleClusteredJobIntervalWithStart() throws Exception {
        this.testScheduleClusteredJob(Schedule.forInterval((long)60000L, (Date)new Date()));
    }

    @Test
    public void testScheduleClusteredJobCron() throws Exception {
        this.testScheduleClusteredJob(Schedule.forCronExpression((String)"0 0/1 * * * ? *"));
    }

    private void testScheduleClusteredJob(Schedule schedule) throws SchedulerServiceException, InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        this.schedulerService.registerJobRunner(this.jobRunnerKey, new JobRunner(){

            @Nullable
            public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
                latch.countDown();
                return null;
            }
        });
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)this.jobRunnerKey).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(schedule);
        this.schedulerService.scheduleJob(this.localJob, jobConfig);
        MatcherAssert.assertThat((Object)this.isJobExistInEss(this.localJob), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)latch.await(30L, TimeUnit.SECONDS), (Matcher)CoreMatchers.is((Object)true));
    }

    private boolean isJobExistInEss(JobId id) {
        int statusCode = ((Response)this.httpClient.newRequest(this.uri(id)).head().claim()).getStatusCode();
        if (statusCode >= 200 && statusCode < 300) {
            return true;
        }
        if (statusCode == 404) {
            return false;
        }
        throw new RuntimeException("Unexpected status when querying jobs from ESS " + statusCode);
    }

    protected URI uri(JobId jobId) {
        try {
            return new URI(this.getBaseUrl() + "/scheduler/client/" + this.tenantContext.getCurrentTenant().name() + "/context/" + this.applicationProperties.getPlatformId() + "/schedule/" + jobId);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private String getBaseUrl() {
        return System.getProperty("ess.baseurl");
    }

    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    public void setTenantContext(TenantContext tenantContext) {
        this.tenantContext = tenantContext;
    }

    public void setApplicationProperties(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }
}

