/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.util;

import com.atlassian.plugin.spring.scanner.util.ProductFilterUtil;
import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class AnnotationIndexReader {
    private static final boolean isDevMode = Boolean.parseBoolean(System.getProperty("atlassian.dev.mode", "false"));
    private static final Log logger = LogFactory.getLog(AnnotationIndexReader.class);

    public static List<String> readIndexFile(String resourceFile, Bundle bundle) {
        URL url = bundle.getResource(resourceFile);
        return AnnotationIndexReader.readIndexFile(url);
    }

    public static List<String> readIndexFile(String resourceFile, ClassLoader classLoader) {
        URL url = classLoader.getResource(resourceFile);
        List<String> strings = AnnotationIndexReader.readIndexFile(url);
        if (isDevMode) {
            logger.warn((Object)("Read annotation index file: " + resourceFile));
            logger.warn((Object)"Printing out found annotated beans: ");
            logger.warn(strings);
        }
        return strings;
    }

    public static List<String> readAllIndexFilesForProduct(String resourceFile, Bundle bundle) {
        ArrayList<String> entries = new ArrayList<String>();
        URL url = bundle.getResource(resourceFile);
        entries.addAll(AnnotationIndexReader.readIndexFile(url));
        String productName = ProductFilterUtil.getLowerCurrentProductName(bundle.getBundleContext());
        if (StringUtils.isNotBlank((String)productName)) {
            entries.addAll(AnnotationIndexReader.readIndexFile(resourceFile + "-" + productName, bundle));
        }
        return entries;
    }

    public static List<String> readAllIndexFilesForProduct(String resourceFile, ClassLoader classLoader, BundleContext bundleContext) {
        ArrayList<String> entries = new ArrayList<String>();
        URL url = classLoader.getResource(resourceFile);
        entries.addAll(AnnotationIndexReader.readIndexFile(url));
        String productName = ProductFilterUtil.getLowerCurrentProductName(bundleContext);
        if (StringUtils.isNotBlank((String)productName)) {
            entries.addAll(AnnotationIndexReader.readIndexFile(resourceFile + "-" + productName, classLoader));
        }
        return entries;
    }

    public static List<String> readIndexFile(URL url) {
        ArrayList<String> resources = new ArrayList<String>();
        try {
            BufferedReader reader;
            if (null == url) {
                return resources;
            }
            try {
                reader = new BufferedReader(new InputStreamReader(url.openStream(), Charsets.UTF_8));
            }
            catch (FileNotFoundException e) {
                return resources;
            }
            String line = reader.readLine();
            while (line != null) {
                resources.add(line);
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read index file [" + url.toString() + "]", e);
        }
        return resources;
    }

    public static Properties readPropertiesFile(URL url) {
        Properties resources = new Properties();
        try {
            BufferedReader reader;
            if (null == url) {
                return resources;
            }
            try {
                reader = new BufferedReader(new InputStreamReader(url.openStream(), Charsets.UTF_8));
            }
            catch (FileNotFoundException e) {
                return resources;
            }
            resources.load(reader);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read properties file [" + url.toString() + "]", e);
        }
        return resources;
    }
}

