/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin;

import com.atlassian.fugue.Option;
import com.google.common.base.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum InstallationMode {
    REMOTE("remote"),
    LOCAL("local");

    private static final Logger LOGGER;
    private final String key;

    private InstallationMode(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public static Option<InstallationMode> of(String name) {
        for (InstallationMode mode : InstallationMode.values()) {
            if (!mode.getKey().equalsIgnoreCase(name)) continue;
            return Option.some((Object)((Object)mode));
        }
        if (!Strings.isNullOrEmpty((String)name)) {
            LOGGER.warn("Could not match installation mode '{}' to any of existing {}. Ignoring.", (Object)name, (Object)InstallationMode.values());
        }
        return Option.none();
    }

    static {
        LOGGER = LoggerFactory.getLogger(InstallationMode.class);
    }
}

