/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.manager;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginDependencies;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nonnull;

final class DependentPlugins {
    private final SortedMap<Plugin, PluginDependencies.Type> plugins;

    public DependentPlugins(Collection<String> rootPluginKeys, Iterable<Plugin> pluginList, Set<PluginDependencies.Type> dependencyTypes) {
        if (dependencyTypes.isEmpty()) {
            throw new IllegalArgumentException("Dependency types must be provided");
        }
        this.plugins = new TreeMap<Plugin, PluginDependencies.Type>();
        PluginDependencies.Type leastSignificantType = this.getLeastSignificantType(dependencyTypes);
        this.buildPluginDependencies(rootPluginKeys, dependencyTypes, this.dependencyMap(pluginList, leastSignificantType));
    }

    private void buildPluginDependencies(Collection<String> rootPluginKeys, Set<PluginDependencies.Type> dependencyTypes, Multimap<String, Pair<Plugin, PluginDependencies.Type>> dependencies) {
        DependencyQueue queue = new DependencyQueue();
        HashSet visited = Sets.newHashSet();
        for (String rootPluginKey : rootPluginKeys) {
            queue.addLast(new CappedDep(rootPluginKey, PluginDependencies.Type.MANDATORY));
            for (PluginDependencies.Type type : PluginDependencies.Type.values()) {
                visited.add(new CappedDep(rootPluginKey, type));
            }
        }
        while (!queue.isEmpty()) {
            CappedDep currentPlugin = queue.removeFirst();
            for (Pair pluginWithDependencyType : dependencies.get((Object)currentPlugin.key)) {
                Plugin dependentPlugin;
                String dependentPluginKey;
                CappedDep newDep;
                PluginDependencies.Type dependencyType = currentPlugin.cap((PluginDependencies.Type)pluginWithDependencyType.right());
                if (!dependencyTypes.contains(dependencyType) || !visited.add(newDep = new CappedDep(dependentPluginKey = (dependentPlugin = (Plugin)pluginWithDependencyType.left()).getKey(), dependencyType))) continue;
                this.add(dependentPlugin, dependencyType);
                queue.addLast(newDep);
            }
        }
    }

    private Multimap<String, Pair<Plugin, PluginDependencies.Type>> dependencyMap(Iterable<Plugin> pluginList, PluginDependencies.Type leastSignificantType) {
        ArrayListMultimap dependencies = ArrayListMultimap.create();
        for (Plugin p : pluginList) {
            for (Map.Entry keyType : p.getDependencies().getByPluginKey().entries()) {
                if (((PluginDependencies.Type)keyType.getValue()).lessSignificant(leastSignificantType)) continue;
                dependencies.put((Object)((String)keyType.getKey()), (Object)Pair.pair((Object)p, (Object)((PluginDependencies.Type)keyType.getValue())));
            }
        }
        return dependencies;
    }

    private PluginDependencies.Type getLeastSignificantType(Set<PluginDependencies.Type> dependencyTypes) {
        PluginDependencies.Type leastSignificantType = PluginDependencies.Type.MANDATORY;
        for (PluginDependencies.Type type : dependencyTypes) {
            if (!type.lessSignificant(leastSignificantType)) continue;
            leastSignificantType = type;
        }
        return leastSignificantType;
    }

    private void add(Plugin plugin, PluginDependencies.Type dependencyType) {
        PluginDependencies.Type existingDependencyType = (PluginDependencies.Type)this.plugins.get(plugin);
        if (existingDependencyType == null || existingDependencyType.lessSignificant(dependencyType)) {
            this.plugins.put(plugin, dependencyType);
        }
    }

    public Iterable<String> toPluginKeyDependencyTypes(Set<PluginDependencies.Type> dependencyTypes) {
        ArrayList<String> output = new ArrayList<String>();
        for (Map.Entry<Plugin, PluginDependencies.Type> entry : this.plugins.entrySet()) {
            if (!dependencyTypes.contains(entry.getValue())) continue;
            output.add(entry.getKey().getKey() + "(" + entry.getValue() + ")");
        }
        return output;
    }

    public Iterable<String> toPluginKeyDependencyTypes() {
        return this.toPluginKeyDependencyTypes(EnumSet.allOf(PluginDependencies.Type.class));
    }

    public Set<Plugin> get() {
        return this.plugins.keySet();
    }

    public Set<Plugin> getByTypes(Set<PluginDependencies.Type> dependencyTypes) {
        return Maps.filterEntries(this.plugins, input -> dependencyTypes.contains(input.getValue())).keySet();
    }

    private static class DependencyQueue {
        private final Deque<CappedDep> queue = new ArrayDeque<CappedDep>();

        private DependencyQueue() {
        }

        public CappedDep removeFirst() {
            return this.queue.removeFirst();
        }

        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        public void addLast(CappedDep newDep) {
            boolean addToQueue = true;
            Iterator<CappedDep> iter = this.queue.iterator();
            while (iter.hasNext()) {
                CappedDep next = iter.next();
                if (!next.key.equals(newDep.key)) continue;
                boolean bl = addToQueue = next.cap(newDep.cap) != newDep.cap;
                if (!addToQueue) break;
                iter.remove();
                break;
            }
            if (addToQueue) {
                this.queue.addLast(newDep);
            }
        }
    }

    private static class CappedDep {
        @Nonnull
        public final String key;
        @Nonnull
        public final PluginDependencies.Type cap;

        public CappedDep(String key, PluginDependencies.Type cap) {
            this.key = key;
            this.cap = cap;
        }

        public PluginDependencies.Type cap(PluginDependencies.Type depType) {
            return depType.lessSignificant(this.cap) ? depType : this.cap;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CappedDep cappedDep = (CappedDep)o;
            if (!this.key.equals(cappedDep.key)) {
                return false;
            }
            return this.cap == cappedDep.cap;
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + this.cap.hashCode();
            return result;
        }
    }
}

