/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.descriptors;

import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.UnrecognisedModuleDescriptor;
import org.dom4j.Element;

public final class UnrecognisedModuleDescriptorFactory {
    public static UnrecognisedModuleDescriptor createUnrecognisedModuleDescriptor(Plugin plugin, Element element, Throwable e, ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        UnrecognisedModuleDescriptor descriptor = new UnrecognisedModuleDescriptor();
        descriptor.init(plugin, element);
        String name = element.getName();
        Class descriptorClass = moduleDescriptorFactory.getModuleDescriptorClass(name);
        String descriptorClassName = descriptorClass == null ? descriptor.getKey() : descriptorClass.getName();
        String errorMsg = UnrecognisedModuleDescriptorFactory.constructErrorMessage(plugin, name, descriptorClassName, e);
        descriptor.setErrorText(errorMsg);
        return descriptor;
    }

    private static String constructErrorMessage(Plugin plugin, String moduleName, String moduleClass, Throwable e) {
        String errorMsg = e.getMessage() == null || "".equals(e.getMessage()) ? (e instanceof PluginParseException ? "There was a problem loading the descriptor for module '" + moduleName + "' in plugin '" + (plugin == null ? "null" : plugin.getName()) + "'.\n " : (e instanceof InstantiationException ? "Could not instantiate module descriptor: " + moduleClass + ".<br/>" : (e instanceof IllegalAccessException ? "Exception instantiating module descriptor: " + moduleClass + ".<br/>" : (e instanceof ClassNotFoundException ? "Could not find module descriptor class: " + moduleClass + ".<br/>" : (e instanceof NoClassDefFoundError ? "A required class was missing: " + moduleClass + ". Please check that you have all of the required dependencies.<br/>" : "There was a problem loading the module descriptor: " + moduleClass + ".<br/>"))))) : e.getMessage();
        return errorMsg;
    }
}

