/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.assembler;

import com.atlassian.fugue.Option;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.json.marshal.wrapped.JsonableBoolean;
import com.atlassian.json.marshal.wrapped.JsonableNumber;
import com.atlassian.json.marshal.wrapped.JsonableString;
import com.atlassian.plugin.webresource.ContextBatchBuilder;
import com.atlassian.plugin.webresource.DefaultResourceDependencyResolver;
import com.atlassian.plugin.webresource.DefaultWebResourceFilter;
import com.atlassian.plugin.webresource.PluginResource;
import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.ResourceDependencyResolver;
import com.atlassian.plugin.webresource.TransformDescriptorToKey;
import com.atlassian.plugin.webresource.WebResourceFilter;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.atlassian.plugin.webresource.assembler.DefaultWebResourceSet;
import com.atlassian.plugin.webresource.assembler.InclusionState;
import com.atlassian.plugin.webresource.assembler.WebResourceSetCache;
import com.atlassian.plugin.webresource.condition.ConditionState;
import com.atlassian.plugin.webresource.condition.ConditionsCache;
import com.atlassian.plugin.webresource.data.DefaultPluginDataResource;
import com.atlassian.plugin.webresource.transformer.StaticTransformers;
import com.atlassian.webresource.api.assembler.AssembledResources;
import com.atlassian.webresource.api.assembler.RequiredData;
import com.atlassian.webresource.api.assembler.RequiredResources;
import com.atlassian.webresource.api.assembler.WebResourceAssembler;
import com.atlassian.webresource.api.assembler.WebResourceSet;
import com.atlassian.webresource.api.data.PluginDataResource;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultWebResourceAssembler
implements WebResourceAssembler {
    private static final Logger log = LoggerFactory.getLogger(DefaultWebResourceAssembler.class);
    private final Set<String> webResourcesToInclude;
    private final Set<String> contextsToInclude;
    private final Map<String, Jsonable> dataToInclude;
    private final AssembledResources assembledResources;
    private final RequiredResources requiredResources;
    private final RequiredData requiredData;
    private final ResourceRequirer resourceRequirer;
    private final ConditionsCache conditionsCache;
    private InclusionState inclusion;
    private final WebResourceSetCache webResourceSetCache;

    public DefaultWebResourceAssembler(ResourceBatchingConfiguration batchingConfiguration, WebResourceIntegration webResourceIntegration, PluginResourceLocator pluginResourceLocator, StaticTransformers staticTransformers, WebResourceSetCache webResourceSetCache) {
        this(batchingConfiguration, webResourceIntegration, pluginResourceLocator, staticTransformers, Sets.newLinkedHashSet(), Sets.newLinkedHashSet(), Maps.newLinkedHashMap(), new InclusionState(Sets.newHashSet(), Sets.newHashSet(), Sets.newHashSet()), webResourceSetCache, new ConditionsCache());
    }

    private DefaultWebResourceAssembler(ResourceBatchingConfiguration batchingConfiguration, WebResourceIntegration webResourceIntegration, PluginResourceLocator pluginResourceLocator, StaticTransformers staticTransformers, Set<String> webResourcesToInclude, Set<String> contextsToInclude, Map<String, Jsonable> dataToInclude, InclusionState inclusionState, WebResourceSetCache webResourceSetCache, ConditionsCache conditionsCache) {
        this.resourceRequirer = new ResourceRequirer(batchingConfiguration, webResourceIntegration, pluginResourceLocator, new DefaultResourceDependencyResolver(webResourceIntegration, batchingConfiguration), staticTransformers, webResourceSetCache, conditionsCache);
        this.webResourcesToInclude = webResourcesToInclude;
        this.contextsToInclude = contextsToInclude;
        this.dataToInclude = dataToInclude;
        this.inclusion = inclusionState;
        this.webResourceSetCache = webResourceSetCache;
        this.assembledResources = new DefaultAssembledResources();
        this.requiredResources = new DefaultRequiredResources();
        this.requiredData = new DefaultRequiredData();
        this.conditionsCache = conditionsCache;
    }

    public AssembledResources assembled() {
        return this.assembledResources;
    }

    public RequiredResources resources() {
        return this.requiredResources;
    }

    public RequiredData data() {
        return this.requiredData;
    }

    public WebResourceAssembler copy() {
        return new DefaultWebResourceAssembler(this.resourceRequirer.batchingConfiguration, this.resourceRequirer.webResourceIntegration, this.resourceRequirer.pluginResourceLocator, this.resourceRequirer.staticTransformers, Sets.newLinkedHashSet(this.webResourcesToInclude), Sets.newLinkedHashSet(this.contextsToInclude), Maps.newLinkedHashMap(this.dataToInclude), this.inclusion.copy(), this.webResourceSetCache, this.conditionsCache);
    }

    private static class ResourceRequirer {
        private final ResourceBatchingConfiguration batchingConfiguration;
        private final WebResourceIntegration webResourceIntegration;
        private final PluginResourceLocator pluginResourceLocator;
        private final ResourceDependencyResolver dependencyResolver;
        private final StaticTransformers staticTransformers;
        private final WebResourceSetCache webResourceSetCache;
        private final ConditionsCache conditionsCache;

        private ResourceRequirer(ResourceBatchingConfiguration batchingConfiguration, WebResourceIntegration webResourceIntegration, PluginResourceLocator pluginResourceLocator, ResourceDependencyResolver dependencyResolver, StaticTransformers staticTransformers, WebResourceSetCache webResourceSetCache, ConditionsCache conditionsCache) {
            this.batchingConfiguration = batchingConfiguration;
            this.webResourceIntegration = webResourceIntegration;
            this.pluginResourceLocator = pluginResourceLocator;
            this.dependencyResolver = dependencyResolver;
            this.staticTransformers = staticTransformers;
            this.webResourceSetCache = webResourceSetCache;
            this.conditionsCache = conditionsCache;
        }

        private WebResourceSet includeResources(Set<String> requiredWebResources, Set<String> requiredContexts, Map<String, Jsonable> requiredData, WebResourceFilter filter, InclusionState inclusion) {
            Resources resourcesToInclude = new Resources();
            WebResourceSetCache.WebResourceSetCacheKey key = new WebResourceSetCache.WebResourceSetCacheKey(requiredWebResources, requiredContexts, requiredData.keySet(), filter, inclusion);
            Option<WebResourceSetCache.WebResourceSetEntry> webResourceSet = this.webResourceSetCache.get(key, this.pluginResourceLocator.getTransformerCache(), this.conditionsCache);
            if (webResourceSet.isDefined()) {
                for (WebResourceModuleDescriptor wrmd : ((WebResourceSetCache.WebResourceSetEntry)webResourceSet.get()).includedModules()) {
                    if (inclusion.getWebresources().contains(wrmd.getCompleteKey())) continue;
                    Iterables.addAll((Collection)resourcesToInclude.data, this.pluginResourceLocator.getPluginDataResources(wrmd, this.conditionsCache));
                }
                this.addDataResources(requiredData, inclusion, resourcesToInclude);
                InclusionState cachedInclusion = ((WebResourceSetCache.WebResourceSetEntry)webResourceSet.get()).inclusion();
                inclusion.reset(cachedInclusion);
                return ((WebResourceSetCache.WebResourceSetEntry)webResourceSet.get()).webResourceSet().data(resourcesToInclude.data).build(this.batchingConfiguration);
            }
            ConditionState conditionsRun = new ConditionState();
            this.addContextBatchDependencies(resourcesToInclude, filter, requiredWebResources, requiredContexts, inclusion, conditionsRun, this.conditionsCache);
            Iterable<String> dependencyModuleKeys = this.getAllModuleKeysDependencies(requiredWebResources, conditionsRun);
            this.addModuleResources(resourcesToInclude, dependencyModuleKeys, inclusion.getWebresources(), filter, conditionsRun);
            this.addDataResources(requiredData, inclusion, resourcesToInclude);
            Iterables.addAll(inclusion.getContexts(), requiredContexts);
            Iterables.addAll(inclusion.getWebresources(), dependencyModuleKeys);
            Iterables.addAll(inclusion.getDataKeys(), requiredData.keySet());
            DefaultWebResourceSet.Builder builder = DefaultWebResourceSet.builder(this.webResourceIntegration).resources(resourcesToInclude.resources);
            this.webResourceSetCache.add(key, conditionsRun, inclusion, builder, this.pluginResourceLocator.getTransformerCache(), this.conditionsCache);
            return builder.data(resourcesToInclude.data).build(this.batchingConfiguration);
        }

        private void addDataResources(Map<String, Jsonable> requiredData, InclusionState inclusion, Resources resourcesToInclude) {
            for (Map.Entry<String, Jsonable> data : requiredData.entrySet()) {
                if (inclusion.getDataKeys().contains(data.getKey())) continue;
                resourcesToInclude.data.add(new DefaultPluginDataResource(data.getKey(), data.getValue()));
            }
        }

        private void addContextBatchDependencies(Resources resourcesToInclude, WebResourceFilter filter, Set<String> requiredWebResources, Set<String> requiredContexts, InclusionState inclusion, ConditionState conditionsRun, ConditionsCache conditionsCache) {
            ContextBatchBuilder builder = new ContextBatchBuilder(this.pluginResourceLocator, this.dependencyResolver, this.batchingConfiguration);
            Iterable<PluginResource> contextResources = builder.build(new ArrayList<String>(requiredContexts), inclusion.getContexts(), filter, conditionsRun, conditionsCache);
            boolean isAnyContextAlreadyIncluded = false;
            for (String moduleKey : builder.getAllIncludedResources()) {
                if (inclusion.getWebresources().contains(moduleKey)) {
                    isAnyContextAlreadyIncluded = true;
                    log.debug("The module '{}' has already been included in the Assembler. Inclusion contexts = {}, required contexts = {}", new Object[]{moduleKey, inclusion.getContexts(), requiredContexts});
                    continue;
                }
                Option<WebResourceModuleDescriptor> wrmd = this.pluginResourceLocator.getDescriptor(moduleKey);
                if (!wrmd.isDefined()) continue;
                conditionsRun.addWebResourceModuleDescriptor((WebResourceModuleDescriptor)((Object)wrmd.get()));
                Iterables.addAll((Collection)resourcesToInclude.data, this.pluginResourceLocator.getPluginDataResources((WebResourceModuleDescriptor)((Object)wrmd.get()), conditionsCache));
            }
            if (isAnyContextAlreadyIncluded) {
                Iterables.addAll(requiredWebResources, builder.getAllIncludedResources());
            } else {
                Iterables.addAll((Collection)resourcesToInclude.resources, contextResources);
                Iterables.addAll(inclusion.getWebresources(), builder.getAllIncludedResources());
            }
            Iterables.addAll(requiredWebResources, builder.getSkippedResources());
        }

        private Iterable<String> getAllModuleKeysDependencies(Iterable<String> moduleCompleteKeys, ConditionState conditionsRun) {
            LinkedHashSet dependencyModuleCompleteKeys = Sets.newLinkedHashSet();
            for (String moduleCompleteKey : moduleCompleteKeys) {
                Iterable<String> dependencies = this.toModuleKeys(this.dependencyResolver.getDependencies(moduleCompleteKey, false, conditionsRun, this.conditionsCache));
                Iterables.addAll((Collection)dependencyModuleCompleteKeys, dependencies);
            }
            return dependencyModuleCompleteKeys;
        }

        private void addModuleResources(Resources resourcesToInclude, Iterable<String> dependencyModuleCompleteKeys, Set<String> excludeModuleKeys, WebResourceFilter filter, ConditionState conditionsRun) {
            for (String moduleKey : dependencyModuleCompleteKeys) {
                Option<WebResourceModuleDescriptor> wrmd;
                if (excludeModuleKeys.contains(moduleKey) || (wrmd = this.pluginResourceLocator.getDescriptor(moduleKey)).isEmpty()) continue;
                conditionsRun.addWebResourceModuleDescriptor((WebResourceModuleDescriptor)((Object)wrmd.get()));
                List<PluginResource> moduleResources = this.pluginResourceLocator.getPluginResources((WebResourceModuleDescriptor)((Object)wrmd.get()), conditionsRun, this.conditionsCache);
                for (PluginResource moduleResource : moduleResources) {
                    if (!filter.matches(moduleResource.getResourceName())) continue;
                    resourcesToInclude.resources.add(moduleResource);
                }
                Iterables.addAll((Collection)resourcesToInclude.data, this.pluginResourceLocator.getPluginDataResources((WebResourceModuleDescriptor)((Object)wrmd.get()), this.conditionsCache));
            }
        }

        private Iterable<String> toModuleKeys(Iterable<WebResourceModuleDescriptor> descriptors) {
            return Iterables.transform(descriptors, (Function)new TransformDescriptorToKey());
        }

        private static class Resources {
            private final Collection<PluginResource> resources = Lists.newLinkedList();
            private final Collection<PluginDataResource> data = Lists.newLinkedList();

            private Resources() {
            }
        }
    }

    private final class DefaultAssembledResources
    implements AssembledResources {
        private DefaultAssembledResources() {
        }

        public WebResourceSet drainIncludedResources() {
            InclusionState nextInclusion = DefaultWebResourceAssembler.this.inclusion.copy();
            WebResourceSet webResourceSet = DefaultWebResourceAssembler.this.resourceRequirer.includeResources(DefaultWebResourceAssembler.this.webResourcesToInclude, DefaultWebResourceAssembler.this.contextsToInclude, DefaultWebResourceAssembler.this.dataToInclude, DefaultWebResourceFilter.INSTANCE, nextInclusion);
            DefaultWebResourceAssembler.this.webResourcesToInclude.clear();
            DefaultWebResourceAssembler.this.contextsToInclude.clear();
            DefaultWebResourceAssembler.this.dataToInclude.clear();
            DefaultWebResourceAssembler.this.inclusion = nextInclusion;
            return webResourceSet;
        }

        public WebResourceSet peek() {
            InclusionState fakeInclusion = DefaultWebResourceAssembler.this.inclusion.copy();
            return DefaultWebResourceAssembler.this.resourceRequirer.includeResources(DefaultWebResourceAssembler.this.webResourcesToInclude, DefaultWebResourceAssembler.this.contextsToInclude, DefaultWebResourceAssembler.this.dataToInclude, DefaultWebResourceFilter.INSTANCE, fakeInclusion);
        }
    }

    private final class DefaultRequiredData
    implements RequiredData {
        private DefaultRequiredData() {
        }

        public RequiredData requireData(String key, Jsonable content) {
            DefaultWebResourceAssembler.this.dataToInclude.put(key, content);
            return this;
        }

        public RequiredData requireData(String key, Number content) {
            DefaultWebResourceAssembler.this.dataToInclude.put(key, new JsonableNumber(content));
            return this;
        }

        public RequiredData requireData(String key, String content) {
            DefaultWebResourceAssembler.this.dataToInclude.put(key, new JsonableString(content));
            return this;
        }

        public RequiredData requireData(String key, Boolean content) {
            DefaultWebResourceAssembler.this.dataToInclude.put(key, new JsonableBoolean(content));
            return this;
        }

        public RequiredData requireData(String key, Future<Jsonable> content) {
            throw new UnsupportedOperationException("Not implemented");
        }
    }

    private final class DefaultRequiredResources
    implements RequiredResources {
        private DefaultRequiredResources() {
        }

        public RequiredResources requireWebResource(String moduleCompleteKey) {
            DefaultWebResourceAssembler.this.webResourcesToInclude.add(moduleCompleteKey);
            return this;
        }

        public RequiredResources requireContext(String context) {
            DefaultWebResourceAssembler.this.contextsToInclude.add(context);
            return this;
        }

        public RequiredResources exclude(Set<String> webResources, Set<String> contexts) {
            InclusionState nextInclusion = DefaultWebResourceAssembler.this.inclusion.copy();
            HashSet excludeWebResources = null == webResources ? Collections.emptySet() : Sets.newHashSet(webResources);
            HashSet excludeContexts = null == contexts ? Sets.newHashSet() : Sets.newHashSet(contexts);
            excludeContexts.add(DefaultResourceDependencyResolver.IMPLICIT_CONTEXT_NAME);
            DefaultWebResourceAssembler.this.contextsToInclude.remove(DefaultResourceDependencyResolver.IMPLICIT_CONTEXT_NAME);
            DefaultWebResourceAssembler.this.resourceRequirer.includeResources(excludeWebResources, excludeContexts, Collections.emptyMap(), DefaultWebResourceFilter.INSTANCE, nextInclusion);
            DefaultWebResourceAssembler.this.inclusion = nextInclusion;
            return this;
        }
    }
}

