/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.impl;

import com.atlassian.plugin.webresource.impl.CachedCondition;
import com.atlassian.plugin.webresource.impl.Globals;
import com.atlassian.plugin.webresource.impl.snapshot.Bundle;
import com.atlassian.plugin.webresource.impl.snapshot.Resource;
import com.atlassian.plugin.webresource.impl.snapshot.Snapshot;
import com.atlassian.plugin.webresource.url.DefaultUrlBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RequestCache {
    protected final Globals globals;
    protected final Map<Bundle, LinkedHashMap<String, Resource>> cachedResources = new HashMap<Bundle, LinkedHashMap<String, Resource>>();
    protected final Map<ResourceKeysSupplier, List<Resource>> cachedResourceLists = new HashMap<ResourceKeysSupplier, List<Resource>>();
    protected final Map<CachedCondition, Boolean> cachedConditionsEvaluation = new HashMap<CachedCondition, Boolean>();
    protected final Map<CachedCondition, DefaultUrlBuilder> cachedConditionsParameters = new HashMap<CachedCondition, DefaultUrlBuilder>();
    protected Snapshot cachedSnapshot;

    public static List<ResourceKey> toResourceKeys(List<Resource> resources) {
        ArrayList<ResourceKey> resourceKeys = new ArrayList<ResourceKey>();
        for (Resource resource : resources) {
            resourceKeys.add(new ResourceKey(resource.getKey(), resource.getName()));
        }
        return resourceKeys;
    }

    public RequestCache(Globals globals) {
        this.globals = globals;
    }

    public Globals getGlobals() {
        return this.globals;
    }

    public Map<Bundle, LinkedHashMap<String, Resource>> getCachedResources() {
        return this.cachedResources;
    }

    public List<Resource> getCachedResources(ResourceKeysSupplier resourceKeysSupplier) {
        List<Resource> resources = this.cachedResourceLists.get(resourceKeysSupplier);
        if (resources == null) {
            resources = new ArrayList<Resource>();
            for (ResourceKey key : resourceKeysSupplier.getKeys()) {
                resources.add(this.cachedSnapshot.get(key.key).getResources(this).get(key.name));
            }
            this.cachedResourceLists.put(resourceKeysSupplier, resources);
        }
        return resources;
    }

    public Map<CachedCondition, Boolean> getCachedConditionsEvaluation() {
        return this.cachedConditionsEvaluation;
    }

    public Map<CachedCondition, DefaultUrlBuilder> getCachedConditionsParameters() {
        return this.cachedConditionsParameters;
    }

    public Snapshot getSnapshot() {
        if (this.cachedSnapshot == null) {
            this.cachedSnapshot = this.globals.getSnapshot();
        }
        return this.cachedSnapshot;
    }

    public static class ResourceKeysSupplier {
        private final List<ResourceKey> keys;

        public ResourceKeysSupplier(List<ResourceKey> keys) {
            this.keys = keys;
        }

        public List<ResourceKey> getKeys() {
            return this.keys;
        }
    }

    public static class ResourceKey {
        public String key;
        public String name;

        public ResourceKey(String key, String name) {
            this.key = key;
            this.name = name;
        }
    }
}

