/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.impl.annotators;

import com.atlassian.plugin.webresource.impl.annotators.ResourceContentAnnotator;
import com.atlassian.plugin.webresource.impl.snapshot.ModuleResource;
import com.atlassian.plugin.webresource.impl.snapshot.Resource;
import com.atlassian.plugin.webresource.impl.snapshot.WebModule;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashSet;
import java.util.Map;

public class ModuleAnnotator
extends ResourceContentAnnotator {
    @Override
    public int beforeResourceInBatch(LinkedHashSet<String> requiredResources, Resource resource, Map<String, String> params, OutputStream stream) throws IOException {
        return this.before(requiredResources, resource, params, stream);
    }

    @Override
    public int beforeResource(LinkedHashSet<String> requiredResources, String url, Resource resource, Map<String, String> params, OutputStream stream) throws IOException {
        return this.before(requiredResources, resource, params, stream);
    }

    @Override
    public void afterResourceInBatch(LinkedHashSet<String> requiredResources, Resource resource, Map<String, String> params, OutputStream stream) throws IOException {
        this.after(requiredResources, resource, params, stream);
    }

    @Override
    public void afterResource(LinkedHashSet<String> requiredResources, String url, Resource resource, Map<String, String> params, OutputStream stream) throws IOException {
        this.after(requiredResources, resource, params, stream);
    }

    protected int before(LinkedHashSet<String> requiredResources, Resource resource, Map<String, String> params, OutputStream stream) throws IOException {
        if (!(resource instanceof ModuleResource)) {
            return 0;
        }
        WebModule module = (WebModule)resource.getParent();
        if ("soy".equals(module.getSrcType())) {
            stream.write(("define(\"" + module.getKey() + "\", function(){ return " + module.getSoyNamespace() + "; });\n").getBytes());
            return 1;
        }
        stream.write(("\nWRM.atlassianModule(\"" + module.getKey() + "\"").getBytes());
        stream.write(", {".getBytes());
        boolean isFirst = true;
        for (Map.Entry<String, String> entry : module.getUnresolvedDependencies().entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                stream.write(", ".getBytes());
            }
            stream.write("\"".getBytes());
            stream.write(entry.getKey().getBytes());
            stream.write("\": \"".getBytes());
            stream.write(entry.getValue().getBytes());
            stream.write("\"".getBytes());
        }
        stream.write("}, function(define) {\n".getBytes());
        return 1;
    }

    protected void after(LinkedHashSet<String> requiredResources, Resource resource, Map<String, String> params, OutputStream stream) throws IOException {
        if (resource instanceof ModuleResource) {
            WebModule module = (WebModule)resource.getParent();
            if (!"soy".equals(module.getSrcType())) {
                stream.write("\n});\n".getBytes());
            }
            if (requiredResources.contains(module.getKey()) || requiredResources.contains(module.getBaseName())) {
                stream.write(("require([\"" + module.getKey() + "\"], function(){});\n").getBytes());
            }
        }
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

