/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.utils;

import java.io.ObjectInputFilter;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.context.support.AbstractApplicationContext;

public class BlocklistDeserializationFilter
implements ObjectInputFilter {
    private static final Logger log = LoggerFactory.getLogger(BlocklistDeserializationFilter.class);
    private final Set<String> blockedClasses;

    public BlocklistDeserializationFilter(Set<String> blockedClasses) {
        this.blockedClasses = new HashSet<String>(blockedClasses);
    }

    @Override
    public ObjectInputFilter.Status checkInput(ObjectInputFilter.FilterInfo filterInfo) {
        String className;
        ObjectInputFilter.Status classNameCheck;
        Class<?> rawClass = filterInfo.serialClass();
        if (rawClass == null) {
            return ObjectInputFilter.Status.ALLOWED;
        }
        if (rawClass.isArray()) {
            rawClass = this.getClassTypeOfArray(rawClass);
        }
        if ((classNameCheck = this.checkClassName(className = rawClass.getName())) == ObjectInputFilter.Status.REJECTED) {
            return classNameCheck;
        }
        return this.checkForBelongingToSpecificClasses(rawClass);
    }

    private Class<?> getClassTypeOfArray(Class<?> rawClass) {
        while (rawClass.isArray()) {
            rawClass = rawClass.getComponentType();
        }
        return rawClass;
    }

    private ObjectInputFilter.Status checkClassName(String className) {
        if (this.blockedClasses.contains(className)) {
            log.debug("Deserialize step prevented for class: {}. This class is blocked", (Object)className);
            return ObjectInputFilter.Status.REJECTED;
        }
        return ObjectInputFilter.Status.ALLOWED;
    }

    private ObjectInputFilter.Status checkForBelongingToSpecificClasses(Class<?> rawClass) {
        if (rawClass.isInterface()) {
            return ObjectInputFilter.Status.ALLOWED;
        }
        String className = rawClass.getName();
        if (AbstractPointcutAdvisor.class.isAssignableFrom(rawClass) || AbstractApplicationContext.class.isAssignableFrom(rawClass)) {
            log.debug("Deserialize step prevented for class: {}.", (Object)className);
            return ObjectInputFilter.Status.REJECTED;
        }
        if (className.startsWith("com.mchange.v2.c3p0.") && className.endsWith("DataSource")) {
            log.debug("Deserialize step prevented for class: {}.", (Object)className);
            return ObjectInputFilter.Status.REJECTED;
        }
        return ObjectInputFilter.Status.ALLOWED;
    }
}

