/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.internal.querydsl;

import com.atlassian.annotations.Internal;
import com.atlassian.fugue.Effect;
import com.atlassian.fugue.Option;
import com.atlassian.pocketknife.api.querydsl.ClosePromise;
import com.atlassian.pocketknife.api.querydsl.CloseableIterable;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.mysema.commons.lang.CloseableIterator;
import java.util.NoSuchElementException;

@Internal
public class CloseableIterableImpl<S, T>
implements CloseableIterable<T> {
    private final CloseableIteratorImpl<S, T> closeableIterator;
    private final ClosePromise closePromise;

    public CloseableIterableImpl(CloseableIterator<S> srcIterator, Function<S, T> mapper, ClosePromise parentPromise) {
        this(srcIterator, mapper, parentPromise, Predicates.alwaysTrue(), Predicates.alwaysTrue());
    }

    public CloseableIterableImpl(CloseableIterator<S> srcIterator, Function<S, T> mapper, ClosePromise parentPromise, Predicate<S> filterPredicate, Predicate<S> takeWhilePredicate) {
        IteratorInstructions<S, T> instructions = new IteratorInstructions<S, T>(srcIterator, mapper, parentPromise, filterPredicate, takeWhilePredicate);
        this.closeableIterator = new CloseableIteratorImpl<S, T>(instructions);
        this.closePromise = new ClosePromise(parentPromise, new Runnable(){

            @Override
            public void run() {
                CloseableIterableImpl.this.closeImpl();
            }
        });
    }

    public CloseableIterableImpl(CloseableIteratorImpl<S, T> closeableIterator) {
        this.closeableIterator = closeableIterator;
        this.closePromise = ((CloseableIteratorImpl)closeableIterator).closePromise;
    }

    @Override
    public CloseableIterator<T> iterator() {
        return this.closeableIterator;
    }

    @Override
    public ClosePromise getClosePromise() {
        return this.closePromise;
    }

    @Override
    public CloseableIterable<T> take(int n) {
        Preconditions.checkArgument((n >= 0 ? 1 : 0) != 0, (Object)"take(n) argument must be >= 0");
        Preconditions.checkState((!this.closeableIterator.hasStarted() ? 1 : 0) != 0, (Object)"You cant take(n) from an iterable that has been read");
        Predicate<T> nTaken = CloseableIterableImpl.nTakenPredicate(n);
        return this.takeWhile(nTaken);
    }

    @Override
    public CloseableIterable<T> takeWhile(Predicate<T> takeWhilePredicate) {
        Preconditions.checkNotNull(takeWhilePredicate);
        Preconditions.checkState((!this.closeableIterator.hasStarted() ? 1 : 0) != 0, (Object)"You cant takeWhile() from an iterable that has been read");
        final CloseableIteratorImpl<S, T> src = this.closeableIterator;
        Predicate composedTakeWhile = Predicates.compose(takeWhilePredicate, (Function)new Function<S, T>(){

            public T apply(S input) {
                return src.mapper.apply(input);
            }
        });
        IteratorInstructions instructions = new IteratorInstructions(((CloseableIteratorImpl)src).instructions);
        instructions.takeWhilePredicate = composedTakeWhile;
        CloseableIteratorImpl newIterator = new CloseableIteratorImpl(instructions);
        return new CloseableIterableImpl(newIterator);
    }

    @Override
    public CloseableIterable<T> filter(Predicate<T> filterPredicate) {
        Preconditions.checkNotNull(filterPredicate);
        final CloseableIteratorImpl<S, T> src = this.closeableIterator;
        Predicate composedFilterPredicate = Predicates.compose(filterPredicate, (Function)new Function<S, T>(){

            public T apply(S input) {
                return src.mapper.apply(input);
            }
        });
        IteratorInstructions instructions = new IteratorInstructions(((CloseableIteratorImpl)src).instructions);
        instructions.filterPredicate = composedFilterPredicate;
        CloseableIteratorImpl newIterator = new CloseableIteratorImpl(instructions);
        return new CloseableIterableImpl(newIterator);
    }

    public static <T> Predicate<T> nTakenPredicate(final int n) {
        return new Predicate<T>(){
            int takenSoFar = 0;

            public boolean apply(T s) {
                if (this.takenSoFar < n) {
                    ++this.takenSoFar;
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    public <D> CloseableIterable<D> map(final Function<T, D> mapper) {
        final CloseableIteratorImpl<S, T> src = this.closeableIterator;
        Function composedMapper = new Function<S, D>(){

            public D apply(S input) {
                return Functions.compose((Function)mapper, (Function)src.mapper).apply(input);
            }
        };
        IteratorInstructions instructions = new IteratorInstructions(((CloseableIteratorImpl)src).srcIterator, composedMapper, this.closePromise, ((CloseableIteratorImpl)src).filterPredicate, ((CloseableIteratorImpl)src).takeWhilePredicate);
        CloseableIteratorImpl composedIterator = new CloseableIteratorImpl(instructions);
        return new CloseableIterableImpl(composedIterator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Option<T> fetchFirst() {
        if (!this.closePromise.isClosed()) {
            try {
                CloseableIterator<T> iterator = this.iterator();
                if (iterator.hasNext()) {
                    Option option = Option.some((Object)iterator.next());
                    return option;
                }
            }
            finally {
                this.closePromise.close();
            }
        }
        return Option.none();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void foreach(Effect<T> effect) {
        if (!this.closePromise.isClosed()) {
            try {
                for (Object t : this) {
                    effect.apply(t);
                }
            }
            finally {
                this.closePromise.close();
            }
        }
    }

    @Override
    public void close() {
        this.closePromise.close();
    }

    private void closeImpl() {
        this.closeableIterator.close();
    }

    static class CloseableIteratorImpl<S, T>
    implements CloseableIterator<T> {
        private final CloseableIterator<S> srcIterator;
        private final Function<S, T> mapper;
        private final ClosePromise closePromise;
        private final Predicate<S> filterPredicate;
        private final Predicate<S> takeWhilePredicate;
        private final IteratorInstructions<S, T> instructions;
        int returnedSoFar;
        S nextObject;
        boolean nextObjectAccessed = true;

        CloseableIteratorImpl(IteratorInstructions<S, T> instructions) {
            this.instructions = instructions;
            this.srcIterator = ((IteratorInstructions)instructions).srcIterator;
            this.mapper = ((IteratorInstructions)instructions).mapper;
            this.closePromise = ((IteratorInstructions)instructions).closePromise;
            this.filterPredicate = ((IteratorInstructions)instructions).filterPredicate;
            this.takeWhilePredicate = ((IteratorInstructions)instructions).takeWhilePredicate;
            this.returnedSoFar = 0;
        }

        boolean hasStarted() {
            return this.returnedSoFar > 0;
        }

        public boolean hasNext() {
            if (!this.nextObjectAccessed) {
                return true;
            }
            if (this.closePromise.isClosed()) {
                return false;
            }
            boolean hasNext = this.srcIterator.hasNext();
            while (hasNext) {
                this.nextObject = this.nextImpl();
                this.nextObjectAccessed = false;
                if (this.filterPredicate.apply(this.nextObject)) break;
                hasNext = this.srcIterator.hasNext();
            }
            if (hasNext && !this.takeWhilePredicate.apply(this.nextObject)) {
                hasNext = false;
            }
            if (!hasNext) {
                this.nextObject = null;
                this.close();
            }
            return hasNext;
        }

        private S nextImpl() {
            Object next = this.srcIterator.next();
            ++this.returnedSoFar;
            return (S)next;
        }

        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.nextObjectAccessed = true;
            return (T)this.mapper.apply(this.nextObject);
        }

        public void close() {
            this.closePromise.close();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class IteratorInstructions<S, T> {
        private CloseableIterator<S> srcIterator;
        private Function<S, T> mapper;
        private ClosePromise closePromise;
        private Predicate<S> filterPredicate;
        private Predicate<S> takeWhilePredicate;

        public IteratorInstructions(CloseableIterator<S> srcIterator, Function<S, T> mapper, ClosePromise closePromise, Predicate<S> filterPredicate, Predicate<S> takeWhilePredicate) {
            this.srcIterator = srcIterator;
            this.mapper = mapper;
            this.closePromise = closePromise;
            this.filterPredicate = filterPredicate;
            this.takeWhilePredicate = takeWhilePredicate;
        }

        IteratorInstructions(IteratorInstructions<S, T> instructions) {
            this.srcIterator = instructions.srcIterator;
            this.mapper = instructions.mapper;
            this.closePromise = instructions.closePromise;
            this.takeWhilePredicate = instructions.takeWhilePredicate;
            this.filterPredicate = instructions.filterPredicate;
        }
    }
}

