/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.spi.querydsl;

import com.atlassian.annotations.PublicSpi;
import com.atlassian.fugue.Pair;
import com.atlassian.pocketknife.api.querydsl.DialectProvider;
import com.atlassian.pocketknife.api.querydsl.LoggingSqlListener;
import com.atlassian.pocketknife.api.querydsl.SchemaProvider;
import com.atlassian.pocketknife.internal.querydsl.DialectHelper;
import com.atlassian.pocketknife.internal.querydsl.util.MemoizingResettingReference;
import com.atlassian.pocketknife.spi.querydsl.DialectConfiguration;
import com.google.common.base.Function;
import com.mysema.query.sql.Configuration;
import com.mysema.query.sql.H2Templates;
import com.mysema.query.sql.HSQLDBTemplates;
import com.mysema.query.sql.MySQLTemplates;
import com.mysema.query.sql.OracleTemplates;
import com.mysema.query.sql.PostgresTemplates;
import com.mysema.query.sql.SQLListener;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.sql.types.AbstractType;
import com.mysema.query.sql.types.Null;
import com.mysema.query.sql.types.Type;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@PublicSpi
public class DefaultDialectConfiguration
implements DialectConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DefaultDialectConfiguration.class);
    private final SchemaProvider schemaProvider;
    private final MemoizingResettingReference<Connection, DialectProvider.Config> configurationReference = new MemoizingResettingReference<Connection, DialectProvider.Config>(new Function<Connection, DialectProvider.Config>(){

        public DialectProvider.Config apply(@Nullable Connection connection) {
            return DefaultDialectConfiguration.this.detect(connection);
        }
    });
    private static Map<String, Pair<SQLTemplates.Builder, DialectProvider.SupportedDatabase>> support = new LinkedHashMap<String, Pair<SQLTemplates.Builder, DialectProvider.SupportedDatabase>>();

    @Autowired
    public DefaultDialectConfiguration(SchemaProvider schemaProvider) {
        this.schemaProvider = schemaProvider;
    }

    @Override
    public DialectProvider.Config getDialectConfig(Connection connection) {
        this.schemaProvider.prime(connection);
        return this.configurationReference.get(connection);
    }

    private DialectProvider.Config detect(Connection connection) {
        Pair<SQLTemplates, DialectProvider.SupportedDatabase> pair = this.buildTemplates(connection);
        SQLTemplates sqlTemplates = (SQLTemplates)pair.left();
        Configuration configuration = this.enrich(new Configuration(sqlTemplates));
        configuration.addListener((SQLListener)new LoggingSqlListener(configuration));
        configuration.register((Type)new NullType());
        return new DialectProvider.Config(sqlTemplates, configuration, this.buildDatabaseInfo((DialectProvider.SupportedDatabase)((Object)pair.right()), connection));
    }

    @Override
    public SQLTemplates.Builder enrich(SQLTemplates.Builder builder) {
        return builder.newLineToSingleSpace().quote();
    }

    @Override
    public Configuration enrich(Configuration configuration) {
        return configuration;
    }

    private Pair<SQLTemplates, DialectProvider.SupportedDatabase> buildTemplates(Connection connection) {
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            String connStr = metaData.getURL();
            Pair<SQLTemplates.Builder, DialectProvider.SupportedDatabase> pair = this.getDBTemplate(connStr, metaData);
            if (pair == null) {
                throw new UnsupportedOperationException(String.format("Unable to detect QueryDSL template support for database %s", connStr));
            }
            SQLTemplates templates = this.enrich((SQLTemplates.Builder)pair.left()).build();
            return Pair.pair((Object)templates, (Object)pair.right());
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to enquire on JDBC metadata to configure QueryDSL", e);
        }
    }

    @Nullable
    Pair<SQLTemplates.Builder, DialectProvider.SupportedDatabase> getDBTemplate(String connStr, DatabaseMetaData metaData) throws SQLException {
        Pair<SQLTemplates.Builder, DialectProvider.SupportedDatabase> sqlTemplatePair = DialectHelper.isSQLServer(connStr) ? DialectHelper.getSQLServerDBTemplate(metaData) : this.getStaticSupportedDBTemplate(connStr);
        if (sqlTemplatePair != null) {
            log.debug("SQL template has been initialized successfully {}", (Object)sqlTemplatePair.toString());
        } else {
            log.warn("System was unable to initialize SQL template for {}", (Object)connStr);
        }
        return sqlTemplatePair;
    }

    @Nullable
    Pair<SQLTemplates.Builder, DialectProvider.SupportedDatabase> getStaticSupportedDBTemplate(String connStr) {
        Pair<SQLTemplates.Builder, DialectProvider.SupportedDatabase> pair = null;
        for (String db : support.keySet()) {
            if (!connStr.contains(db)) continue;
            pair = support.get(db);
            break;
        }
        return pair;
    }

    private DialectProvider.DatabaseInfo buildDatabaseInfo(DialectProvider.SupportedDatabase supportedDatabase, Connection connection) {
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            return new DialectProvider.DatabaseInfo(supportedDatabase, metaData.getDatabaseProductName(), metaData.getDatabaseProductVersion(), metaData.getDatabaseMajorVersion(), metaData.getDatabaseMinorVersion(), metaData.getDriverName(), metaData.getDriverMajorVersion(), metaData.getDriverMinorVersion());
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to enquire on JDBC metadata to determine DatabaseInfo", e);
        }
    }

    static {
        support.put(":postgresql:", (Pair<SQLTemplates.Builder, DialectProvider.SupportedDatabase>)Pair.pair((Object)PostgresTemplates.builder(), (Object)((Object)DialectProvider.SupportedDatabase.POSTGRESSQL)));
        support.put(":oracle:", (Pair<SQLTemplates.Builder, DialectProvider.SupportedDatabase>)Pair.pair((Object)OracleTemplates.builder(), (Object)((Object)DialectProvider.SupportedDatabase.ORACLE)));
        support.put(":hsqldb:", (Pair<SQLTemplates.Builder, DialectProvider.SupportedDatabase>)Pair.pair((Object)HSQLDBTemplates.builder(), (Object)((Object)DialectProvider.SupportedDatabase.HSQLDB)));
        support.put(":mysql:", (Pair<SQLTemplates.Builder, DialectProvider.SupportedDatabase>)Pair.pair((Object)MySQLTemplates.builder(), (Object)((Object)DialectProvider.SupportedDatabase.MYSQL)));
        support.put(":h2:", (Pair<SQLTemplates.Builder, DialectProvider.SupportedDatabase>)Pair.pair((Object)H2Templates.builder(), (Object)((Object)DialectProvider.SupportedDatabase.H2)));
    }

    private static class NullType
    extends AbstractType<Null> {
        public NullType() {
            super(0);
        }

        public Null getValue(ResultSet rs, int startIndex) throws SQLException {
            return Null.DEFAULT;
        }

        public Class<Null> getReturnedClass() {
            return Null.class;
        }

        public void setValue(PreparedStatement st, int startIndex, Null value) throws SQLException {
            if (!ArrayUtils.isNotEmpty((int[])this.getSQLTypes())) {
                throw new RuntimeException("Unable to set database column to null");
            }
            st.setNull(startIndex, this.getSQLTypes()[0]);
        }

        public String getLiteral(Null value) {
            return "null";
        }
    }
}

