/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.scheduler.core.status;

import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.core.AbstractSchedulerService;
import com.atlassian.scheduler.core.status.LazyJobDetails;
import com.atlassian.scheduler.status.JobDetails;
import com.atlassian.util.concurrent.Assertions;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractJobDetailsFactory<T> {
    private final AbstractSchedulerService schedulerService;

    protected AbstractJobDetailsFactory(AbstractSchedulerService schedulerService) {
        this.schedulerService = (AbstractSchedulerService)Assertions.notNull((String)"schedulerService", (Object)schedulerService);
    }

    public JobDetails buildJobDetails(JobId jobId, T jobData, RunMode runMode) {
        Assertions.notNull((String)"jobId", (Object)jobId);
        Assertions.notNull((String)"jobData", jobData);
        Assertions.notNull((String)"runMode", (Object)runMode);
        JobRunnerKey jobRunnerKey = (JobRunnerKey)Assertions.notNull((String)"jobRunnerKey", (Object)this.getJobRunnerKey(jobData));
        Schedule schedule = (Schedule)Assertions.notNull((String)"schedule", (Object)this.getSchedule(jobData));
        Date nextRunTime = this.getNextRunTime(jobData);
        byte[] parameters = this.getSerializedParameters(jobData);
        return new LazyJobDetails(this.schedulerService, jobId, jobRunnerKey, runMode, schedule, nextRunTime, parameters);
    }

    @Nonnull
    protected abstract JobRunnerKey getJobRunnerKey(T var1);

    @Nonnull
    protected abstract Schedule getSchedule(T var1);

    @Nullable
    protected abstract Date getNextRunTime(T var1);

    @Nullable
    protected abstract byte[] getSerializedParameters(T var1);
}

