/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.seraph.filter;

import com.atlassian.seraph.filter.PasswordBasedLoginFilter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginFilter
extends PasswordBasedLoginFilter {
    private static final Logger log = LoggerFactory.getLogger(LoginFilter.class);
    private static final String ALLOW_URL_PARAMETER_VALUE_PARAMETER_NAME = "allowUrlParameterValue";
    private static final String ENCODING = "UTF-8";
    private volatile boolean allowUrlParameterValue = false;

    @Override
    public void init(FilterConfig config) {
        super.init(config);
        String configValue = config.getInitParameter(ALLOW_URL_PARAMETER_VALUE_PARAMETER_NAME);
        if (StringUtils.isNotBlank((CharSequence)configValue)) {
            this.setAllowUrlParameterValue(Boolean.parseBoolean(configValue));
        }
    }

    public void setAllowUrlParameterValue(boolean allowUrlParameterValue) {
        this.allowUrlParameterValue = allowUrlParameterValue;
    }

    @Override
    protected PasswordBasedLoginFilter.UserPasswordPair extractUserPasswordPair(HttpServletRequest request) {
        String username = request.getParameter("os_username");
        String password = request.getParameter("os_password");
        boolean persistentLogin = "true".equals(request.getParameter("os_cookie"));
        if (!this.allowUrlParameterValue && StringUtils.isNotEmpty((CharSequence)password) && LoginFilter.hasOsPasswordQueryParam(request)) {
            log.info("Not accepting an authentication attempt for user \"{}\", as authentication url parameter values are not being accepted.", (Object)username);
            return null;
        }
        return new PasswordBasedLoginFilter.UserPasswordPair(username, password, persistentLogin);
    }

    private static boolean hasOsPasswordQueryParam(HttpServletRequest request) {
        if (request.getQueryString() == null) {
            return false;
        }
        String decodedQueryString = LoginFilter.decodeQueryString(request.getQueryString());
        return decodedQueryString.contains("os_password=");
    }

    private static String decodeQueryString(String queryString) {
        try {
            return URLDecoder.decode(queryString, ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }
}

