/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.memcached;

import com.atlassian.marshalling.api.MarshallingPair;
import com.atlassian.vcache.ExternalCacheException;
import com.atlassian.vcache.ExternalCacheSettings;
import com.atlassian.vcache.PutPolicy;
import com.atlassian.vcache.internal.MetricLabel;
import com.atlassian.vcache.internal.RequestContext;
import com.atlassian.vcache.internal.core.ExternalCacheKeyGenerator;
import com.atlassian.vcache.internal.core.VCacheCoreUtils;
import com.atlassian.vcache.internal.core.metrics.CacheType;
import com.atlassian.vcache.internal.core.metrics.MetricsRecorder;
import com.atlassian.vcache.internal.core.service.AbstractStableReadExternalCache;
import com.atlassian.vcache.internal.core.service.VersionedExternalCacheRequestContext;
import com.atlassian.vcache.internal.memcached.MemcachedUtils;
import com.atlassian.vcache.internal.memcached.MemcachedVCacheServiceSettings;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.spy.memcached.MemcachedClientIF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MemcachedStableReadExternalCache<V>
extends AbstractStableReadExternalCache<V> {
    private static final Logger log = LoggerFactory.getLogger(MemcachedStableReadExternalCache.class);
    private final Supplier<MemcachedClientIF> clientSupplier;
    private final Supplier<RequestContext> contextSupplier;
    private final ExternalCacheKeyGenerator keyGenerator;
    private final MarshallingPair<V> valueMarshalling;
    private final int ttlSeconds;

    MemcachedStableReadExternalCache(MemcachedVCacheServiceSettings serviceSettings, Supplier<RequestContext> contextSupplier, ExternalCacheKeyGenerator keyGenerator, String name, MarshallingPair<V> valueMarshalling, ExternalCacheSettings settings, MetricsRecorder metricsRecorder) {
        super(name, metricsRecorder, serviceSettings.getLockTimeout(), serviceSettings.getExternalCacheExceptionListener());
        this.clientSupplier = Objects.requireNonNull(serviceSettings.getClientSupplier());
        this.contextSupplier = Objects.requireNonNull(contextSupplier);
        this.keyGenerator = Objects.requireNonNull(keyGenerator);
        this.valueMarshalling = Objects.requireNonNull(valueMarshalling);
        this.ttlSeconds = VCacheCoreUtils.roundUpToSeconds((Duration)((Duration)settings.getDefaultTtl().get()));
    }

    public boolean internalPut(String internalKey, V value, PutPolicy policy) {
        String externalKey = this.ensureCacheContext().externalEntryKeyFor(internalKey);
        byte[] valueBytes = this.valueMarshalling.getMarshaller().marshallToBytes(value);
        try {
            Future<Boolean> putOp = MemcachedUtils.putOperationForPolicy(policy, this.clientSupplier.get(), externalKey, MemcachedUtils.expiryTime(this.ttlSeconds), valueBytes);
            return putOp.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new ExternalCacheException(ExternalCacheException.Reason.UNCLASSIFIED_FAILURE, (Throwable)e);
        }
    }

    protected void internalRemove(Iterable<String> internalKeys) {
        if (VCacheCoreUtils.isEmpty(internalKeys)) {
            return;
        }
        VersionedExternalCacheRequestContext<V> cacheContext = this.ensureCacheContext();
        Map<String, Future> deleteOps = StreamSupport.stream(internalKeys.spliterator(), false).distinct().collect(Collectors.toMap(k -> k, k -> this.clientSupplier.get().delete(cacheContext.externalEntryKeyFor(k))));
        Exception failureException = null;
        for (Map.Entry<String, Future> delOp : deleteOps.entrySet()) {
            try {
                delOp.getValue().get();
                cacheContext.recordValue(delOp.getKey(), Optional.empty());
            }
            catch (InterruptedException | ExecutionException ex) {
                log.info("Cache {}: unable to remove key {}", new Object[]{this.name, delOp.getKey(), ex});
                failureException = ex;
            }
        }
        if (failureException != null) {
            throw new ExternalCacheException(ExternalCacheException.Reason.NETWORK_FAILURE, failureException);
        }
    }

    protected void internalRemoveAll() {
        VersionedExternalCacheRequestContext<V> cacheContext = this.ensureCacheContext();
        cacheContext.updateCacheVersion(MemcachedUtils.cacheVersionIncrementer(this.clientSupplier));
    }

    protected Logger getLogger() {
        return log;
    }

    protected VersionedExternalCacheRequestContext<V> ensureCacheContext() {
        RequestContext requestContext = this.contextSupplier.get();
        return (VersionedExternalCacheRequestContext)requestContext.computeIfAbsent((Object)this, () -> {
            log.trace("Cache {}: Setting up a new context", (Object)this.name);
            return new VersionedExternalCacheRequestContext(this.keyGenerator, this.name, () -> ((RequestContext)requestContext).partitionIdentifier(), MemcachedUtils.cacheVersionSupplier(this.clientSupplier), this.lockTimeout);
        });
    }

    protected V handleCreation(String internalKey, V candidateValue) throws ExecutionException, InterruptedException {
        VersionedExternalCacheRequestContext<V> cacheContext = this.ensureCacheContext();
        byte[] candidateValueBytes = this.valueMarshalling.getMarshaller().marshallToBytes(candidateValue);
        String externalKey = cacheContext.externalEntryKeyFor(internalKey);
        while (true) {
            this.metricsRecorder.record(this.name, CacheType.EXTERNAL, MetricLabel.NUMBER_OF_REMOTE_GET, 1L);
            Future addOp = this.clientSupplier.get().add(externalKey, MemcachedUtils.expiryTime(this.ttlSeconds), (Object)candidateValueBytes);
            if (((Boolean)addOp.get()).booleanValue()) break;
            this.getLogger().info("Cache {}, unable to add candidate for key {}, retrieve what was added", (Object)this.name, (Object)internalKey);
            this.metricsRecorder.record(this.name, CacheType.EXTERNAL, MetricLabel.NUMBER_OF_REMOTE_GET, 1L);
            Optional otherAddedValue = VCacheCoreUtils.unmarshall((byte[])((byte[])this.clientSupplier.get().get(externalKey)), this.valueMarshalling);
            if (otherAddedValue.isPresent()) {
                return (V)otherAddedValue.get();
            }
            this.getLogger().info("Cache {}, unable to retrieve recently added candidate for key {}, looping", (Object)this.name, (Object)internalKey);
        }
        return candidateValue;
    }

    protected final ExternalCacheException mapException(Exception ex) {
        return MemcachedUtils.mapException(ex);
    }

    protected final Optional<V> directGet(String externalKey) {
        return VCacheCoreUtils.unmarshall((byte[])((byte[])this.clientSupplier.get().get(externalKey)), this.valueMarshalling);
    }

    protected final Map<String, Optional<V>> directGetBulk(Set<String> externalKeys) {
        return MemcachedUtils.directGetBulk(externalKeys, this.clientSupplier, this.valueMarshalling);
    }
}

