/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.config;

import com.atomikos.datasource.RecoverableResource;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.ExportingTransactionManager;
import com.atomikos.icatch.ImportingTransactionManager;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TSListener;
import com.atomikos.icatch.admin.LogAdministrator;
import com.atomikos.icatch.config.TSInitInfo;
import com.atomikos.icatch.config.TSMetaData;
import com.atomikos.icatch.config.UserTransactionService;
import com.atomikos.icatch.config.UserTransactionServiceFactory;
import com.atomikos.util.ClassLoadingHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;

public class UserTransactionServiceImp
implements Serializable,
UserTransactionService {
    private static final long serialVersionUID = -3374591336514451887L;
    public static final String NO_FILE_PROPERTY_NAME = "com.atomikos.icatch.no_file";
    public static final String FILE_PATH_PROPERTY_NAME = "com.atomikos.icatch.file";
    public static final String HIDE_INIT_FILE_PATH_PROPERTY_NAME = "com.atomikos.icatch.hide_init_file_path";
    public static final String DEFAULT_PROPERTIES_FILE_NAME = "transactions.properties";
    private static final String PRE_3_0_DEFAULT_PROPERTIES_FILE_NAME = "jta.properties";
    private Properties properties_;
    private List tsListeners_ = new ArrayList();
    private List logAdministrators_ = new ArrayList();
    private List resources_ = new ArrayList();
    private transient UserTransactionService delegate_;

    private static String evaluateReference(String value, Properties properties) {
        String result = value;
        int startIndex = value.indexOf(36);
        if (startIndex > -1 && value.charAt(startIndex + 1) == '{') {
            int endIndex = value.indexOf(125);
            if (startIndex + 2 == endIndex) {
                throw new IllegalArgumentException("property ref cannot refer to an empty name: ${}");
            }
            if (endIndex == -1) {
                throw new IllegalArgumentException("unclosed property ref: ${" + value.substring(startIndex + 2));
            }
            String subPropertyKey = value.substring(startIndex + 2, endIndex);
            String subPropertyValue = properties.getProperty(subPropertyKey);
            if (subPropertyValue == null) {
                subPropertyValue = System.getProperty(subPropertyKey);
            }
            if (subPropertyValue != null) {
                result = result.substring(0, startIndex) + subPropertyValue + result.substring(endIndex + 1);
                result = UserTransactionServiceImp.evaluateReference(result, properties);
            }
        }
        return result;
    }

    private static void logToStdErr(String msg) {
        if (System.getProperty(HIDE_INIT_FILE_PATH_PROPERTY_NAME) == null) {
            System.err.println(msg);
        }
    }

    private static Properties mergeProperties(Properties first, Properties defaults) {
        Enumeration<?> names = first.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = first.getProperty(name);
            defaults.setProperty(name, value);
        }
        return defaults;
    }

    private URL findPropertiesFileInClasspath(String fileName) {
        URL ret = null;
        ret = ClassLoadingHelper.loadResourceFromClasspath(this.getClass(), (String)fileName);
        if (ret == null) {
            this.getClass().getClassLoader();
            ret = ClassLoader.getSystemResource(fileName);
        }
        return ret;
    }

    private Properties findProperties() {
        Properties p = new Properties();
        URL url = null;
        if (System.getProperty(NO_FILE_PROPERTY_NAME) == null) {
            String filename = System.getProperty(FILE_PATH_PROPERTY_NAME);
            if (filename == null) {
                filename = DEFAULT_PROPERTIES_FILE_NAME;
                UserTransactionServiceImp.logToStdErr("No properties path set - looking for transactions.properties in classpath...");
                url = this.findPropertiesFileInClasspath(filename);
                if (url == null) {
                    filename = PRE_3_0_DEFAULT_PROPERTIES_FILE_NAME;
                    UserTransactionServiceImp.logToStdErr("transactions.properties not found - looking for jta.properties in classpath...");
                    url = this.findPropertiesFileInClasspath(filename);
                }
            } else {
                File file = new File(filename);
                try {
                    url = file.toURL();
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            try {
                if (url == null) {
                    throw new IOException();
                }
                UserTransactionServiceImp.logToStdErr("Using init file: " + url.getPath());
                InputStream in = url.openStream();
                p.load(in);
                in.close();
            }
            catch (IOException io) {
                String msg = "Failed to open transactions properties file - using default values";
                UserTransactionServiceImp.logToStdErr(msg);
                p.setProperty("com.atomikos.icatch.service", "com.atomikos.icatch.standalone.UserTransactionServiceFactory");
            }
        } else {
            p.setProperty("com.atomikos.icatch.service", System.getProperty("com.atomikos.icatch.service"));
        }
        Enumeration<?> allProps = p.propertyNames();
        while (allProps.hasMoreElements()) {
            String value;
            String key = (String)allProps.nextElement();
            String raw = p.getProperty(key);
            if (raw.equals(value = UserTransactionServiceImp.evaluateReference(raw, p))) continue;
            p.setProperty(key, value);
        }
        return p;
    }

    private String getOrFindProperty(String name) {
        if (this.properties_ == null) {
            this.properties_ = this.findProperties();
        }
        return this.properties_.getProperty(name);
    }

    public UserTransactionServiceImp() {
    }

    public UserTransactionServiceImp(Properties properties) {
        this();
        this.properties_ = this.findProperties();
        this.properties_.putAll((Map<?, ?>)properties);
    }

    private void checkInit() {
        if (this.delegate_ != null) {
            return;
        }
        String factoryClassName = this.getOrFindProperty("com.atomikos.icatch.service");
        if (factoryClassName == null) {
            throw new SysException("UserTransactionServiceImp: property not defined: com.atomikos.icatch.service");
        }
        try {
            Class factoryClass = ClassLoadingHelper.loadClass((String)factoryClassName);
            UserTransactionServiceFactory factory = (UserTransactionServiceFactory)factoryClass.newInstance();
            this.delegate_ = factory.getUserTransactionService(this.properties_);
        }
        catch (Exception e) {
            Stack<Exception> errors = new Stack<Exception>();
            errors.push(e);
            throw new SysException("Error in init of UserTransactionServiceImp: " + e.getMessage(), errors);
        }
    }

    public TSInitInfo createTSInitInfo() {
        TSInitInfo ret = null;
        this.checkInit();
        ret = this.delegate_.createTSInitInfo();
        Properties p = UserTransactionServiceImp.mergeProperties(this.properties_, ret.getProperties());
        ret.setProperties(p);
        return ret;
    }

    public void shutdown(boolean force) throws IllegalStateException {
        this.checkInit();
        this.delegate_.shutdown(force);
    }

    public void init(TSInitInfo info) throws SysException {
        this.checkInit();
        for (Object nxt : this.resources_) {
            this.registerResource((RecoverableResource)nxt);
        }
        for (Object nxt : this.logAdministrators_) {
            this.registerLogAdministrator((LogAdministrator)nxt);
        }
        for (Object nxt : this.tsListeners_) {
            this.registerTSListener((TSListener)nxt);
        }
        this.delegate_.init(info);
    }

    public CompositeTransactionManager getCompositeTransactionManager() {
        this.checkInit();
        return this.delegate_.getCompositeTransactionManager();
    }

    public TransactionManager getTransactionManager() {
        this.checkInit();
        return this.delegate_.getTransactionManager();
    }

    public UserTransaction getUserTransaction() {
        this.checkInit();
        return this.delegate_.getUserTransaction();
    }

    public ImportingTransactionManager getImportingTransactionManager() {
        this.checkInit();
        return this.delegate_.getImportingTransactionManager();
    }

    public ExportingTransactionManager getExportingTransactionManager() {
        this.checkInit();
        return this.delegate_.getExportingTransactionManager();
    }

    public TSMetaData getTSMetaData() {
        this.checkInit();
        return this.delegate_.getTSMetaData();
    }

    public void registerResource(RecoverableResource res) {
        this.checkInit();
        this.delegate_.registerResource(res);
    }

    public void registerLogAdministrator(LogAdministrator admin) {
        this.checkInit();
        this.delegate_.registerLogAdministrator(admin);
    }

    public Enumeration getResources() {
        this.checkInit();
        return this.delegate_.getResources();
    }

    public Enumeration getLogAdministrators() {
        this.checkInit();
        return this.delegate_.getLogAdministrators();
    }

    public void removeResource(RecoverableResource res) {
        this.checkInit();
        this.delegate_.removeResource(res);
    }

    public void removeLogAdministrator(LogAdministrator admin) {
        this.checkInit();
        this.delegate_.removeLogAdministrator(admin);
    }

    public void registerTSListener(TSListener listener) {
        this.checkInit();
        this.delegate_.registerTSListener(listener);
    }

    public void removeTSListener(TSListener listener) {
        this.checkInit();
        this.delegate_.removeTSListener(listener);
    }

    public void shutdownForce() {
        this.shutdown(true);
    }

    public void shutdownWait() {
        this.shutdown(false);
    }

    public void setInitialRecoverableResources(List resources) {
        this.resources_ = resources;
    }

    public void setInitialLogAdministrators(List administrators) {
        this.logAdministrators_ = administrators;
    }

    public void setInitialTSListeners(List listeners) {
        this.tsListeners_ = listeners;
    }

    public void init() {
        TSInitInfo info = this.createTSInitInfo();
        this.init(info);
    }

    public void init(Properties properties) throws SysException {
        TSInitInfo info = this.createTSInitInfo();
        UserTransactionServiceImp.mergeProperties(properties, info.getProperties());
        this.init(info);
    }
}

